/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.xml.xmp;

import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.xml.xmp.DublinCoreSchema;
import com.itextpdf.text.xml.xmp.LangAlt;
import com.itextpdf.text.xml.xmp.PdfSchema;
import com.itextpdf.text.xml.xmp.XmpBasicSchema;
import com.itextpdf.text.xml.xmp.XmpSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpWriter {
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF16BE = "UTF-16BE";
    public static final String UTF16LE = "UTF-16LE";
    public static final String EXTRASPACE = "                                                                                                   \n";
    protected int extraSpace;
    protected OutputStreamWriter writer;
    protected String about;
    public static final String XPACKET_PI_BEGIN = "<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n";
    public static final String XPACKET_PI_END_W = "<?xpacket end=\"w\"?>";
    public static final String XPACKET_PI_END_R = "<?xpacket end=\"r\"?>";
    protected char end = (char)119;

    public XmpWriter(OutputStream os, String utfEncoding, int extraSpace) throws IOException {
        this.extraSpace = extraSpace;
        this.writer = new OutputStreamWriter(os, utfEncoding);
        this.writer.write(XPACKET_PI_BEGIN);
        this.writer.write("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n");
        this.writer.write("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        this.about = "";
    }

    public XmpWriter(OutputStream os) throws IOException {
        this(os, UTF8, 20);
    }

    public void setReadOnly() {
        this.end = (char)114;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public void addRdfDescription(String xmlns, String content) throws IOException {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(xmlns);
        this.writer.write(">");
        this.writer.write(content);
        this.writer.write("</rdf:Description>\n");
    }

    public void addRdfDescription(XmpSchema s) throws IOException {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(s.getXmlns());
        this.writer.write(">");
        this.writer.write(s.toString());
        this.writer.write("</rdf:Description>\n");
    }

    public void close() throws IOException {
        this.writer.write("</rdf:RDF>");
        this.writer.write("</x:xmpmeta>\n");
        for (int i2 = 0; i2 < this.extraSpace; ++i2) {
            this.writer.write(EXTRASPACE);
        }
        this.writer.write(this.end == 'r' ? XPACKET_PI_END_R : XPACKET_PI_END_W);
        this.writer.flush();
        this.writer.close();
    }

    public XmpWriter(OutputStream os, PdfDictionary info, int PdfXConformance2) throws IOException {
        this(os, info);
        if (info != null) {
            DublinCoreSchema dc = new DublinCoreSchema();
            PdfSchema p = new PdfSchema();
            XmpBasicSchema basic = new XmpBasicSchema();
            for (PdfName pdfName : info.getKeys()) {
                PdfName key2 = pdfName;
                PdfObject obj = info.get(key2);
                if (obj == null || !obj.isString()) continue;
                String value = ((PdfString)obj).toUnicodeString();
                if (PdfName.TITLE.equals(key2)) {
                    dc.addTitle(new LangAlt(value));
                }
                if (PdfName.AUTHOR.equals(key2)) {
                    dc.addAuthor(value);
                }
                if (PdfName.SUBJECT.equals(key2)) {
                    dc.addSubject(value);
                    dc.addDescription(new LangAlt(value));
                }
                if (PdfName.KEYWORDS.equals(key2)) {
                    p.addKeywords(value);
                }
                if (PdfName.CREATOR.equals(key2)) {
                    basic.addCreatorTool(value);
                }
                if (PdfName.PRODUCER.equals(key2)) {
                    p.addProducer(value);
                }
                if (PdfName.CREATIONDATE.equals(key2)) {
                    basic.addCreateDate(PdfDate.getW3CDate(obj.toString()));
                }
                if (!PdfName.MODDATE.equals(key2)) continue;
                basic.addModDate(PdfDate.getW3CDate(obj.toString()));
            }
            if (dc.size() > 0) {
                this.addRdfDescription(dc);
            }
            if (p.size() > 0) {
                this.addRdfDescription(p);
            }
            if (basic.size() > 0) {
                this.addRdfDescription(basic);
            }
        }
    }

    public XmpWriter(OutputStream os, PdfDictionary info) throws IOException {
        this(os);
        if (info != null) {
            DublinCoreSchema dc = new DublinCoreSchema();
            PdfSchema p = new PdfSchema();
            XmpBasicSchema basic = new XmpBasicSchema();
            for (PdfName pdfName : info.getKeys()) {
                PdfName key2 = pdfName;
                PdfObject obj = info.get(key2);
                if (obj == null || !obj.isString()) continue;
                String value = ((PdfString)obj).toUnicodeString();
                if (PdfName.TITLE.equals(key2)) {
                    dc.addTitle(new LangAlt(value));
                }
                if (PdfName.AUTHOR.equals(key2)) {
                    dc.addAuthor(value);
                }
                if (PdfName.SUBJECT.equals(key2)) {
                    dc.addSubject(value);
                    dc.addDescription(new LangAlt(value));
                }
                if (PdfName.KEYWORDS.equals(key2)) {
                    p.addKeywords(value);
                }
                if (PdfName.CREATOR.equals(key2)) {
                    basic.addCreatorTool(value);
                }
                if (PdfName.PRODUCER.equals(key2)) {
                    p.addProducer(value);
                }
                if (PdfName.CREATIONDATE.equals(key2)) {
                    basic.addCreateDate(PdfDate.getW3CDate(obj.toString()));
                }
                if (!PdfName.MODDATE.equals(key2)) continue;
                basic.addModDate(PdfDate.getW3CDate(obj.toString()));
            }
            if (dc.size() > 0) {
                this.addRdfDescription(dc);
            }
            if (p.size() > 0) {
                this.addRdfDescription(p);
            }
            if (basic.size() > 0) {
                this.addRdfDescription(basic);
            }
        }
    }

    public XmpWriter(OutputStream os, Map<String, String> info) throws IOException {
        this(os);
        if (info != null) {
            DublinCoreSchema dc = new DublinCoreSchema();
            PdfSchema p = new PdfSchema();
            XmpBasicSchema basic = new XmpBasicSchema();
            for (Map.Entry<String, String> entry : info.entrySet()) {
                String key2 = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                if ("Title".equals(key2)) {
                    dc.addTitle(new LangAlt(value));
                }
                if ("Author".equals(key2)) {
                    dc.addAuthor(value);
                }
                if ("Subject".equals(key2)) {
                    dc.addSubject(value);
                    dc.addDescription(new LangAlt(value));
                }
                if ("Keywords".equals(key2)) {
                    p.addKeywords(value);
                }
                if ("Creator".equals(key2)) {
                    basic.addCreatorTool(value);
                }
                if ("Producer".equals(key2)) {
                    p.addProducer(value);
                }
                if ("CreationDate".equals(key2)) {
                    basic.addCreateDate(PdfDate.getW3CDate(value));
                }
                if (!"ModDate".equals(key2)) continue;
                basic.addModDate(PdfDate.getW3CDate(value));
            }
            if (dc.size() > 0) {
                this.addRdfDescription(dc);
            }
            if (p.size() > 0) {
                this.addRdfDescription(p);
            }
            if (basic.size() > 0) {
                this.addRdfDescription(basic);
            }
        }
    }
}

