/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.cache;

import com.jfoenix.transitions.CacheMemento;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public interface CachePolicy<T extends Node> {
    public static final CachePolicy<Node> CACHE = new CachePolicy<Node>(){
        private WeakHashMap<Node, CacheMemento> cache = new WeakHashMap();

        @Override
        public void cache(Node node2) {
            if (!this.cache.containsKey(node2)) {
                CacheMemento cacheMemento = new CacheMemento(node2);
                this.cache.put(node2, cacheMemento);
                cacheMemento.cache();
            }
        }

        @Override
        public void restore(Node node2) {
            CacheMemento cacheMemento = this.cache.remove(node2);
            if (cacheMemento != null) {
                cacheMemento.restore();
            }
        }
    };
    public static final CachePolicy<Node> NONE = new CachePolicy<Node>(){

        @Override
        public void cache(Node node2) {
        }

        @Override
        public void restore(Node node2) {
        }
    };
    public static final CachePolicy<Pane> IMAGE = new CachePolicy<Pane>(){
        private WeakHashMap<Node, ArrayList<Node>> cache = new WeakHashMap();

        @Override
        public void cache(Pane node2) {
            if (!this.cache.containsKey(node2)) {
                SnapshotParameters snapShotparams = new SnapshotParameters();
                snapShotparams.setFill((Paint)Color.TRANSPARENT);
                WritableImage temp = node2.snapshot(snapShotparams, new WritableImage((int)node2.getLayoutBounds().getWidth(), (int)node2.getLayoutBounds().getHeight()));
                ImageView tempImage = new ImageView((Image)temp);
                tempImage.setCache(true);
                tempImage.setCacheHint(CacheHint.SPEED);
                this.cache.put((Node)node2, new ArrayList(node2.getChildren()));
                node2.getChildren().setAll((Object[])new Node[]{tempImage});
            }
        }

        @Override
        public void restore(Pane node2) {
            ArrayList<Node> children = this.cache.remove(node2);
            if (children != null) {
                node2.getChildren().setAll(children);
            }
        }
    };

    public void cache(T var1);

    public void restore(T var1);
}

