/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.converters.ButtonTypeConverter;
import com.jfoenix.skins.JFXButtonSkin;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.paint.Paint;

public class JFXButton
extends Button {
    private ObjectProperty<Paint> ripplerFill = new SimpleObjectProperty(null);
    private static final String DEFAULT_STYLE_CLASS = "jfx-button";
    private static final String USER_AGENT_STYLESHEET = JFXButton.class.getResource("/css/controls/jfx-button.css").toExternalForm();
    private StyleableObjectProperty<ButtonType> buttonType = new SimpleStyleableObjectProperty(StyleableProperties.access$000(), (Object)this, "buttonType", (Object)ButtonType.FLAT);
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.access$100(), (Object)this, "disableVisualFocus", false);
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXButton() {
        this.initialize();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < stackTraceElements.length && i2 < 15; ++i2) {
            if (!stackTraceElements[i2].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("Button");
            break;
        }
    }

    public JFXButton(String text2) {
        super(text2);
        this.initialize();
    }

    public JFXButton(String text2, Node graphic) {
        super(text2, graphic);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXButtonSkin(this);
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public final ObjectProperty<Paint> ripplerFillProperty() {
        return this.ripplerFill;
    }

    public final Paint getRipplerFill() {
        return (Paint)this.ripplerFillProperty().get();
    }

    public final void setRipplerFill(Paint ripplerFill) {
        this.ripplerFillProperty().set((Object)ripplerFill);
    }

    public ButtonType getButtonType() {
        return this.buttonType == null ? ButtonType.FLAT : (ButtonType)((Object)this.buttonType.get());
    }

    public StyleableObjectProperty<ButtonType> buttonTypeProperty() {
        return this.buttonType;
    }

    public void setButtonType(ButtonType type2) {
        this.buttonType.set((Object)type2);
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean disabled) {
        this.disableVisualFocusProperty().set(disabled.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.addAll(JFXButton.getClassCssMetaData());
            styleables.addAll(Labeled.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXButton, ButtonType> BUTTON_TYPE = new CssMetaData<JFXButton, ButtonType>("-jfx-button-type", ButtonTypeConverter.getInstance(), ButtonType.FLAT){

            public boolean isSettable(JFXButton control) {
                return control.buttonType == null || !control.buttonType.isBound();
            }

            public StyleableProperty<ButtonType> getStyleableProperty(JFXButton control) {
                return control.buttonTypeProperty();
            }
        };
        private static final CssMetaData<JFXButton, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXButton, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXButton control) {
                return control.disableVisualFocus == null || !control.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXButton control) {
                return control.disableVisualFocusProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return BUTTON_TYPE;
        }

        static /* synthetic */ CssMetaData access$100() {
            return DISABLE_VISUAL_FOCUS;
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, BUTTON_TYPE, DISABLE_VISUAL_FOCUS);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum ButtonType {
        FLAT,
        RAISED;

    }
}

