/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXMasonryPane$$Lambda$1;
import com.jfoenix.controls.JFXMasonryPane$1$$Lambda$1;
import com.jfoenix.controls.JFXMasonryPane$2$$Lambda$1;
import com.jfoenix.transitions.CachedTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.event.ActionEvent;
import javafx.geometry.BoundingBox;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class JFXMasonryPane
extends Pane {
    private boolean performingLayout = false;
    private int[][] matrix;
    private HashMap<Region, Transition> animationMap = null;
    private ParallelTransition trans = new ParallelTransition();
    private HashMap<Node, BoundingBox> boundingBoxes = new HashMap();
    private boolean dirtyBoxes = false;
    private final ListChangeListener<Node> childrenListener = JFXMasonryPane$$Lambda$1.lambdaFactory$(this);
    private ObjectProperty<LayoutMode> layoutMode = new SimpleObjectProperty((Object)LayoutMode.MASONRY);
    private DoubleProperty cellWidth = new SimpleDoubleProperty(70.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private DoubleProperty cellHeight = new SimpleDoubleProperty(70.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private DoubleProperty hSpacing = new SimpleDoubleProperty(5.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private DoubleProperty vSpacing = new SimpleDoubleProperty(5.0){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private IntegerProperty limitColumn = new SimpleIntegerProperty(-1){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };
    private IntegerProperty limitRow = new SimpleIntegerProperty(100){

        protected void invalidated() {
            JFXMasonryPane.this.requestLayout();
        }
    };

    public JFXMasonryPane() {
        this.getChildren().addListener((ListChangeListener)new WeakListChangeListener(this.childrenListener));
    }

    protected double computePrefWidth(double height) {
        return this.snappedLeftInset() + this.getCellWidth() + this.snappedRightInset() + 2.0 * this.getHSpacing();
    }

    protected void layoutChildren() {
        this.performingLayout = true;
        int col = (int)Math.floor((this.getWidth() + this.getHSpacing() - this.snappedLeftInset() - this.snappedRightInset()) / (this.getCellWidth() + this.getHSpacing()));
        int n = col = this.getLimitColumn() != -1 && col > this.getLimitColumn() ? this.getLimitColumn() : col;
        if (this.matrix != null && col == this.matrix[0].length) {
            this.performingLayout = false;
            return;
        }
        int row2 = this.getLimitRow();
        this.matrix = new int[row2][col];
        double minWidth = -1.0;
        double minHeight = -1.0;
        List managedChildren = this.getManagedChildren();
        for (int i2 = 0; i2 < managedChildren.size(); ++i2) {
            if (managedChildren.get(i2) instanceof Region) continue;
            managedChildren.remove(i2);
            --i2;
        }
        List<BoundingBox> newBoxes = ((LayoutMode)this.layoutMode.get()).fillGrid(this.matrix, managedChildren, this.getCellWidth(), this.getCellHeight(), row2, col, this.getHSpacing(), this.getVSpacing());
        if (newBoxes == null) {
            this.performingLayout = false;
            return;
        }
        HashMap<Node, BoundingBox> oldBoxes = this.boundingBoxes;
        if (this.dirtyBoxes) {
            this.boundingBoxes = new HashMap();
        }
        for (int i3 = 0; i3 < managedChildren.size() && i3 < newBoxes.size(); ++i3) {
            double blockHeight;
            double blockWidth;
            double blockY;
            double blockX;
            final Region child = (Region)managedChildren.get(i3);
            BoundingBox boundingBox = newBoxes.get(i3);
            if (child instanceof GridPane) continue;
            if (boundingBox != null) {
                blockX = boundingBox.getMinY() * this.getCellWidth() + boundingBox.getMinY() * this.getHSpacing() + this.snappedLeftInset();
                blockY = boundingBox.getMinX() * this.getCellHeight() + boundingBox.getMinX() * this.getVSpacing() + this.snappedTopInset();
                blockWidth = boundingBox.getWidth() * this.getCellWidth() + (boundingBox.getWidth() - 1.0) * this.getHSpacing();
                blockHeight = boundingBox.getHeight() * this.getCellHeight() + (boundingBox.getHeight() - 1.0) * this.getVSpacing();
            } else {
                blockX = child.getLayoutX();
                blockY = child.getLayoutY();
                blockWidth = -1.0;
                blockHeight = -1.0;
            }
            if (this.animationMap == null) {
                child.setPrefSize(blockWidth, blockHeight);
                child.resizeRelocate(blockX, blockY, blockWidth, blockHeight);
            } else {
                KeyFrame keyFrame;
                BoundingBox oldBoundingBox = oldBoxes.get(child);
                if (oldBoundingBox == null || !oldBoundingBox.equals((Object)boundingBox) && this.dirtyBoxes) {
                    child.setOpacity(0.0);
                    child.setPrefSize(blockWidth, blockHeight);
                    child.resizeRelocate(blockX, blockY, blockWidth, blockHeight);
                }
                if (boundingBox != null) {
                    if (child.getWidth() != blockWidth || child.getHeight() != blockHeight) {
                        child.setOpacity(0.0);
                        child.setPrefSize(blockWidth, blockHeight);
                        child.resizeRelocate(blockX, blockY, blockWidth, blockHeight);
                    }
                    keyFrame = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)child.opacityProperty(), (Object)1, Interpolator.LINEAR), new KeyValue((WritableValue)child.layoutXProperty(), (Object)blockX, Interpolator.LINEAR), new KeyValue((WritableValue)child.layoutYProperty(), (Object)blockY, Interpolator.LINEAR)});
                    this.animationMap.put(child, new CachedTransition((Node)child, new Timeline(new KeyFrame[]{keyFrame})){
                        {
                            super(node2, timeline);
                            this.setCycleDuration(Duration.seconds((double)0.32));
                            this.setDelay(Duration.seconds((double)0.0));
                            this.setOnFinished(JFXMasonryPane$1$$Lambda$1.lambdaFactory$(child, blockX, blockY));
                        }

                        static /* synthetic */ void lambda$new$0(Region child2, double blockX2, double blockY2, ActionEvent finish) {
                            child2.setLayoutX(blockX2);
                            child2.setLayoutY(blockY2);
                            child2.setOpacity(1.0);
                        }
                    });
                } else {
                    keyFrame = new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)child.opacityProperty(), (Object)0, Interpolator.LINEAR), new KeyValue((WritableValue)child.layoutXProperty(), (Object)blockX, Interpolator.LINEAR), new KeyValue((WritableValue)child.layoutYProperty(), (Object)blockY, Interpolator.LINEAR)});
                    this.animationMap.put(child, new CachedTransition((Node)child, new Timeline(new KeyFrame[]{keyFrame})){
                        {
                            super(node2, timeline);
                            this.setCycleDuration(Duration.seconds((double)0.32));
                            this.setDelay(Duration.seconds((double)0.0));
                            this.setOnFinished(JFXMasonryPane$2$$Lambda$1.lambdaFactory$(child, blockX, blockY));
                        }

                        static /* synthetic */ void lambda$new$0(Region child2, double blockX2, double blockY2, ActionEvent finish) {
                            child2.setLayoutX(blockX2);
                            child2.setLayoutY(blockY2);
                            child2.setOpacity(0.0);
                        }
                    });
                }
            }
            this.boundingBoxes.put((Node)child, boundingBox);
            if (boundingBox == null) continue;
            if (blockX + blockWidth > minWidth) {
                minWidth = blockX + blockWidth;
            }
            if (!(blockY + blockHeight > minHeight)) continue;
            minHeight = blockY + blockHeight;
        }
        if (minHeight != -1.0) {
            this.setPrefHeight(minHeight += this.snappedBottomInset());
        }
        if (this.animationMap == null) {
            this.animationMap = new HashMap();
        }
        this.trans.stop();
        ParallelTransition newTransition = new ParallelTransition();
        newTransition.getChildren().addAll(this.animationMap.values());
        newTransition.play();
        this.trans = newTransition;
        this.dirtyBoxes = false;
        this.performingLayout = false;
    }

    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        super.requestLayout();
    }

    public final void clearLayout() {
        this.matrix = null;
    }

    public final ObjectProperty<LayoutMode> layoutModeProperty() {
        return this.layoutMode;
    }

    public final LayoutMode getLayoutMode() {
        return (LayoutMode)this.layoutModeProperty().get();
    }

    public final void setLayoutMode(LayoutMode layoutMode) {
        this.layoutModeProperty().set((Object)layoutMode);
    }

    public final DoubleProperty cellWidthProperty() {
        return this.cellWidth;
    }

    public final double getCellWidth() {
        return this.cellWidthProperty().get();
    }

    public final void setCellWidth(double cellWidth) {
        this.cellWidthProperty().set(cellWidth);
    }

    public final DoubleProperty cellHeightProperty() {
        return this.cellHeight;
    }

    public final double getCellHeight() {
        return this.cellHeightProperty().get();
    }

    public final void setCellHeight(double cellHeight) {
        this.cellHeightProperty().set(cellHeight);
    }

    public final DoubleProperty hSpacingProperty() {
        return this.hSpacing;
    }

    public final double getHSpacing() {
        return this.hSpacingProperty().get();
    }

    public final void setHSpacing(double spacing) {
        this.hSpacingProperty().set(spacing);
    }

    public final DoubleProperty vSpacingProperty() {
        return this.vSpacing;
    }

    public final double getVSpacing() {
        return this.vSpacingProperty().get();
    }

    public final void setVSpacing(double spacing) {
        this.vSpacingProperty().set(spacing);
    }

    public final IntegerProperty limitColumnProperty() {
        return this.limitColumn;
    }

    public final int getLimitColumn() {
        return this.limitColumnProperty().get();
    }

    public final void setLimitColumn(int limitColumn) {
        this.limitColumnProperty().set(limitColumn);
    }

    public final IntegerProperty limitRowProperty() {
        return this.limitRow;
    }

    public final int getLimitRow() {
        return this.limitRowProperty().get();
    }

    public final void setLimitRow(int limitRow) {
        this.limitRowProperty().set(limitRow);
    }

    static /* synthetic */ void lambda$new$0(JFXMasonryPane this_, ListChangeListener.Change change) {
        if (change.next()) {
            this_.dirtyBoxes = true;
            for (Node removedNode : change.getRemoved()) {
                this_.animationMap.remove(removedNode);
            }
        }
        this_.clearLayout();
        this_.requestLayout();
    }

    private static class BinPackingLayout
    extends LayoutMode {
        private BinPackingLayout() {
        }

        @Override
        public List<BoundingBox> fillGrid(int[][] matrix, List<Region> children, double cellWidth, double cellHeight, int limitRow, int limitCol, double gutterX, double gutterY) {
            int row2 = matrix.length;
            if (row2 <= 0) {
                return null;
            }
            int col = matrix[0].length;
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            block0: for (int b = 0; b < children.size(); ++b) {
                Region block = children.get(b);
                for (int i2 = 0; i2 < row2; ++i2) {
                    int old = boxes.size();
                    for (int j = 0; j < col; ++j) {
                        BoundingBox box;
                        if (matrix[i2][j] != 0 || !this.validWidth(box = this.getFreeArea(matrix, i2, j, block, cellWidth, cellHeight, limitRow, limitCol, gutterX, gutterY), block, cellWidth, gutterX, gutterY) || !this.validHeight(box, block, cellHeight, gutterX, gutterY)) continue;
                        matrix = this.fillMatrix(matrix, b + 1, box.getMinX(), box.getMinY(), box.getWidth(), box.getHeight());
                        boxes.add(box);
                        break;
                    }
                    if (boxes.size() != old) continue block0;
                    if (i2 != row2 - 1) continue;
                    boxes.add(null);
                }
            }
            return boxes;
        }
    }

    private static class MasonryLayout
    extends LayoutMode {
        private MasonryLayout() {
        }

        @Override
        public List<BoundingBox> fillGrid(int[][] matrix, List<Region> children, double cellWidth, double cellHeight, int limitRow, int limitCol, double gutterX, double gutterY) {
            int row2 = matrix.length;
            if (row2 <= 0) {
                return null;
            }
            int col = matrix[0].length;
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            block0: for (int b = 0; b < children.size(); ++b) {
                Region block = children.get(b);
                for (int i2 = 0; i2 < row2; ++i2) {
                    int old = boxes.size();
                    for (int j = 0; j < col; ++j) {
                        BoundingBox box;
                        if (matrix[i2][j] != 0) continue;
                        boolean isValidCell = true;
                        for (int k = i2 + 1; k < row2; ++k) {
                            if (matrix[k][j] == 0) continue;
                            isValidCell = false;
                            break;
                        }
                        if (!isValidCell || !this.validWidth(box = this.getFreeArea(matrix, i2, j, block, cellWidth, cellHeight, limitRow, limitCol, gutterX, gutterY), block, cellWidth, gutterX, gutterY) || !this.validHeight(box, block, cellHeight, gutterX, gutterY)) continue;
                        matrix = this.fillMatrix(matrix, b + 1, box.getMinX(), box.getMinY(), box.getWidth(), box.getHeight());
                        boxes.add(box);
                        break;
                    }
                    if (boxes.size() != old) continue block0;
                    if (i2 != row2 - 1) continue;
                    boxes.add(null);
                }
            }
            return boxes;
        }
    }

    public static abstract class LayoutMode {
        public static final MasonryLayout MASONRY = new MasonryLayout();
        public static final BinPackingLayout BIN_PACKING = new BinPackingLayout();

        protected abstract List<BoundingBox> fillGrid(int[][] var1, List<Region> var2, double var3, double var5, int var7, int var8, double var9, double var11);

        protected BoundingBox getFreeArea(int[][] matrix, int x, int y, Region block, double cellWidth, double cellHeight, int limitRow, int limitCol, double gutterX, double gutterY) {
            int j;
            int i2;
            double blockHeight = this.getBLockHeight(block);
            double blockWidth = this.getBLockWidth(block);
            int rowsNeeded = (int)Math.ceil(blockHeight / (cellHeight + gutterY));
            if (cellHeight * (double)rowsNeeded + (double)((rowsNeeded - 1) * 2) * gutterY < blockHeight) {
                ++rowsNeeded;
            }
            int maxRow = Math.min(x + rowsNeeded, limitRow);
            int colsNeeded = (int)Math.ceil(blockWidth / (cellWidth + gutterX));
            if (cellWidth * (double)colsNeeded + (double)((colsNeeded - 1) * 2) * gutterX < blockWidth) {
                ++colsNeeded;
            }
            int maxCol = Math.min(y + colsNeeded, limitCol);
            int minRow = maxRow;
            int minCol = maxCol;
            for (i2 = x; i2 < minRow; ++i2) {
                for (j = y; j < maxCol; ++j) {
                    if (matrix[i2][j] == 0 || y >= j || j >= minCol) continue;
                    minCol = j;
                }
            }
            for (i2 = x; i2 < maxRow; ++i2) {
                for (j = y; j < minCol; ++j) {
                    if (matrix[i2][j] == 0 || x >= i2 || i2 >= minRow) continue;
                    minRow = i2;
                }
            }
            return new BoundingBox((double)x, (double)y, (double)(minCol - y), (double)(minRow - x));
        }

        protected double getBLockWidth(Region region2) {
            if (region2.getMinWidth() != -1.0) {
                return region2.getMinWidth();
            }
            if (region2.getPrefWidth() != -1.0) {
                return region2.getPrefWidth();
            }
            return region2.prefWidth(-1.0);
        }

        protected double getBLockHeight(Region region2) {
            if (region2.getMinHeight() != -1.0) {
                return region2.getMinHeight();
            }
            if (region2.getPrefHeight() != -1.0) {
                return region2.getPrefHeight();
            }
            return region2.prefHeight(this.getBLockWidth(region2));
        }

        protected boolean validWidth(BoundingBox box, Region region2, double cellW, double gutterX, double gutterY) {
            boolean valid2 = false;
            if (region2.getMinWidth() != -1.0 && box.getWidth() * cellW + (box.getWidth() - 1.0) * 2.0 * gutterX < region2.getMinWidth()) {
                return false;
            }
            if (region2.getPrefWidth() == -1.0 && box.getWidth() * cellW + (box.getWidth() - 1.0) * 2.0 * gutterX >= region2.prefWidth(-1.0)) {
                valid2 = true;
            }
            if (region2.getPrefWidth() != -1.0 && box.getWidth() * cellW + (box.getWidth() - 1.0) * 2.0 * gutterX >= region2.getPrefWidth()) {
                valid2 = true;
            }
            return valid2;
        }

        protected boolean validHeight(BoundingBox box, Region region2, double cellH, double gutterX, double gutterY) {
            boolean valid2 = false;
            if (region2.getMinHeight() != -1.0 && box.getHeight() * cellH + (box.getHeight() - 1.0) * 2.0 * gutterY < region2.getMinHeight()) {
                return false;
            }
            if (region2.getPrefHeight() == -1.0 && box.getHeight() * cellH + (box.getHeight() - 1.0) * 2.0 * gutterY >= region2.prefHeight(region2.prefWidth(-1.0))) {
                valid2 = true;
            }
            if (region2.getPrefHeight() != -1.0 && box.getHeight() * cellH + (box.getHeight() - 1.0) * 2.0 * gutterY >= region2.getPrefHeight()) {
                valid2 = true;
            }
            return valid2;
        }

        protected int[][] fillMatrix(int[][] matrix, int id, double row2, double col, double width, double height) {
            int x = (int)row2;
            while ((double)x < row2 + height) {
                int y = (int)col;
                while ((double)y < col + width) {
                    matrix[x][y] = id;
                    ++y;
                }
                ++x;
            }
            return matrix;
        }
    }
}

