/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXNodesList$$Lambda$1;
import com.jfoenix.controls.JFXNodesList$$Lambda$2;
import com.jfoenix.controls.JFXNodesList$$Lambda$3;
import com.jfoenix.controls.JFXNodesList$$Lambda$4;
import com.jfoenix.controls.JFXNodesList$$Lambda$5;
import com.jfoenix.controls.JFXNodesList$$Lambda$6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.BiFunction;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class JFXNodesList
extends VBox {
    private static final String ALIGN_NODE_CONSTRAINT = "align-node";
    private final HashMap<Node, BiFunction<Boolean, Duration, Collection<KeyFrame>>> animationsMap = new HashMap();
    private boolean expanded = false;
    private final Timeline animateTimeline = new Timeline();
    private boolean performingLayout = false;

    private static void setConstraint(Node node2, Object key2, Object value) {
        if (value == null) {
            node2.getProperties().remove(key2);
        } else {
            node2.getProperties().put(key2, value);
        }
        if (node2.getParent() != null) {
            node2.getParent().requestLayout();
        }
    }

    private static Object getConstraint(Node node2, Object key2) {
        Object value;
        if (node2.hasProperties() && (value = node2.getProperties().get(key2)) != null) {
            return value;
        }
        return null;
    }

    public static void alignNodeToChild(Node node2, Node child) {
        JFXNodesList.setConstraint(node2, ALIGN_NODE_CONSTRAINT, child);
    }

    public static Node getAlignNodeToChild(Node node2) {
        return (Node)JFXNodesList.getConstraint(node2, ALIGN_NODE_CONSTRAINT);
    }

    public JFXNodesList() {
        this.setPickOnBounds(false);
        this.getStyleClass().add((Object)"jfx-nodes-list");
        this.setAlignment(Pos.TOP_CENTER);
    }

    public void addAnimatedNode(Region node2) {
        this.addAnimatedNode(node2, null, true);
    }

    public void addAnimatedNode(Region node2, boolean addTriggerListener) {
        this.addAnimatedNode(node2, null, addTriggerListener);
    }

    public void addAnimatedNode(Region node2, BiFunction<Boolean, Duration, Collection<KeyFrame>> animationFramesFunction) {
        this.addAnimatedNode(node2, animationFramesFunction, true);
    }

    public void addAnimatedNode(Region node2, BiFunction<Boolean, Duration, Collection<KeyFrame>> animationFramesFunction, boolean addTriggerListener) {
        if (node2 instanceof JFXNodesList) {
            StackPane container = new StackPane(new Node[]{node2});
            container.setPickOnBounds(false);
            this.addAnimatedNode((Region)container, animationFramesFunction, addTriggerListener);
            return;
        }
        this.initChild((Node)node2, this.getChildren().size(), animationFramesFunction, addTriggerListener);
        this.getChildren().add((Object)node2);
    }

    private void initChild(Node node2, int index, BiFunction<Boolean, Duration, Collection<KeyFrame>> animationFramesFunction, boolean addTriggerListener) {
        if (index > 0) {
            this.initNode(node2);
            node2.setVisible(false);
        } else {
            if (addTriggerListener) {
                if (node2 instanceof Button) {
                    node2.addEventHandler(ActionEvent.ACTION, JFXNodesList$$Lambda$1.lambdaFactory$(this));
                } else {
                    node2.addEventHandler(MouseEvent.MOUSE_CLICKED, JFXNodesList$$Lambda$2.lambdaFactory$(this));
                }
            }
            node2.getStyleClass().add((Object)"trigger-node");
            node2.setVisible(true);
        }
        if (animationFramesFunction == null && index != 0) {
            animationFramesFunction = this.initDefaultAnimation(node2);
        } else if (animationFramesFunction == null && index == 0) {
            animationFramesFunction = JFXNodesList$$Lambda$3.lambdaFactory$();
        }
        this.animationsMap.put(node2, animationFramesFunction);
    }

    protected double computePrefWidth(double height) {
        if (!this.getChildren().isEmpty()) {
            return ((Node)this.getChildren().get(0)).prefWidth(height);
        }
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        if (!this.getChildren().isEmpty()) {
            return ((Node)this.getChildren().get(0)).prefHeight(width);
        }
        return super.computePrefHeight(width);
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMinWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return this.computePrefWidth(height);
    }

    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        super.requestLayout();
    }

    protected void layoutChildren() {
        this.performingLayout = true;
        ObservableList children = this.getChildren();
        Insets insets = this.getInsets();
        double width = this.getWidth();
        double rotate2 = this.getRotate();
        double height = this.getHeight();
        double left2 = this.snapSpace(insets.getLeft());
        double right2 = this.snapSpace(insets.getRight());
        double space = this.snapSpace(this.getSpacing());
        boolean isFillWidth = this.isFillWidth();
        double contentWidth = width - left2 - right2;
        Pos alignment = this.getAlignment();
        alignment = alignment == null ? Pos.TOP_CENTER : alignment;
        HPos hpos = alignment.getHpos();
        VPos vpos = alignment.getVpos();
        double y = 0.0;
        int size = children.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Node child = (Node)children.get(i2);
            child.autosize();
            child.setRotate(rotate2 % 180.0 == 0.0 ? rotate2 : -rotate2);
            if (!this.animationsMap.containsKey(child)) {
                if (child instanceof JFXNodesList) {
                    StackPane container = new StackPane(new Node[]{child});
                    container.setPickOnBounds(false);
                    this.getChildren().set(i2, (Object)container);
                }
                this.initChild(child, i2, null, true);
            }
            double x = 0.0;
            double childWidth = child.getLayoutBounds().getWidth();
            double childHeight = child.getLayoutBounds().getHeight();
            if (childWidth > width) {
                switch (hpos) {
                    case CENTER: {
                        x = this.snapPosition(contentWidth - childWidth) / 2.0;
                    }
                }
                Node alignToChild = JFXNodesList.getAlignNodeToChild(child);
                if (alignToChild != null && child instanceof Parent) {
                    ((Parent)child).layout();
                    double alignedWidth = alignToChild.getLayoutBounds().getWidth();
                    double alignedX = alignToChild.getLayoutX();
                    alignedWidth = childWidth / 2.0 > alignedX + alignedWidth ? -(childWidth / 2.0 - (alignedWidth / 2.0 + alignedX)) : alignedWidth / 2.0 + alignedX - childWidth / 2.0;
                    child.setTranslateX(-alignedWidth * Math.cos(Math.toRadians(rotate2)));
                    child.setTranslateY(alignedWidth * Math.cos(Math.toRadians(90.0 - rotate2)));
                }
            } else {
                childWidth = contentWidth;
            }
            Insets margin = JFXNodesList.getMargin((Node)child);
            if (margin != null) {
                childWidth += margin.getLeft() + margin.getRight();
                childHeight += margin.getTop() + margin.getRight();
            }
            this.layoutInArea(child, x, y, childWidth, childHeight, 0.0, margin, isFillWidth, true, hpos, vpos);
            y += child.getLayoutBounds().getHeight() + space;
            if (margin != null) {
                y += margin.getTop() + margin.getBottom();
            }
            y = this.snapPosition(y);
        }
        this.performingLayout = false;
    }

    public void animateList() {
        boolean bl = this.expanded = !this.expanded;
        if (this.animateTimeline.getStatus() == Animation.Status.RUNNING) {
            this.animateTimeline.stop();
        }
        this.animateTimeline.getKeyFrames().clear();
        this.createAnimation(this.expanded, this.animateTimeline);
        this.animateTimeline.play();
    }

    public void animateList(boolean expand) {
        if (this.expanded && !expand || !this.expanded && expand) {
            this.animateList();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public Animation getListAnimation(boolean expanded) {
        Timeline animation = new Timeline();
        this.createAnimation(expanded, animation);
        return animation;
    }

    private void createAnimation(boolean expanded, Timeline animation) {
        ObservableList children = this.getChildren();
        double duration = 160.0 / (double)children.size();
        if (expanded) {
            for (Node child : children) {
                child.setVisible(true);
            }
        }
        for (int i2 = 1; i2 < children.size(); ++i2) {
            Node child;
            child = (Node)children.get(i2);
            Collection<KeyFrame> frames = this.animationsMap.get(child).apply(expanded, Duration.millis((double)((double)i2 * duration)));
            animation.getKeyFrames().addAll(frames);
        }
        Collection<KeyFrame> frames = this.animationsMap.get(children.get(0)).apply(expanded, Duration.millis((double)160.0));
        animation.getKeyFrames().addAll(frames);
        if (!expanded) {
            animation.setOnFinished(JFXNodesList$$Lambda$4.lambdaFactory$(children));
        } else {
            animation.setOnFinished(null);
        }
    }

    private BiFunction<Boolean, Duration, Collection<KeyFrame>> initDefaultAnimation(Node child) {
        return JFXNodesList$$Lambda$5.lambdaFactory$(child);
    }

    protected void initNode(Node node2) {
        node2.setScaleX(0.0);
        node2.setScaleY(0.0);
        node2.getStyleClass().add((Object)"sub-node");
    }

    static /* synthetic */ Collection lambda$initDefaultAnimation$5(Node child, Boolean expanded, Duration duration) {
        ArrayList<KeyFrame> frames = new ArrayList<KeyFrame>();
        frames.add(new KeyFrame(duration, JFXNodesList$$Lambda$6.lambdaFactory$(child, expanded), new KeyValue[]{new KeyValue((WritableValue)child.scaleXProperty(), (Object)(expanded != false ? 1 : 0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)child.scaleYProperty(), (Object)(expanded != false ? 1 : 0), Interpolator.EASE_BOTH)}));
        return frames;
    }

    static /* synthetic */ void lambda$null$4(Node child, Boolean expanded, ActionEvent event) {
        child.setScaleX(expanded != false ? 1.0 : 0.0);
        child.setScaleY(expanded != false ? 1.0 : 0.0);
    }

    static /* synthetic */ void lambda$createAnimation$3(ObservableList children, ActionEvent finish) {
        for (int i2 = 1; i2 < children.size(); ++i2) {
            ((Node)children.get(i2)).setVisible(false);
        }
    }

    static /* synthetic */ Collection lambda$initChild$2(Boolean aBoolean, Duration duration) {
        return new ArrayList();
    }

    static /* synthetic */ void lambda$initChild$1(JFXNodesList this_, MouseEvent event) {
        this_.animateList();
    }

    static /* synthetic */ void lambda$initChild$0(JFXNodesList this_, ActionEvent event) {
        this_.animateList();
    }
}

