/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.RecursiveTreeItem$$Lambda$1;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$2;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$3;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$4;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$5;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$6;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$7;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$8;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$9;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.utils.JFXUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class RecursiveTreeItem<T extends RecursiveTreeObject<T>>
extends TreeItem<T> {
    private Callback<RecursiveTreeObject<T>, ObservableList<T>> childrenFactory;
    private ObjectProperty<Predicate<TreeItem<T>>> predicate;
    private HashMap<T, TreeItem<T>> itemsMap;
    ObservableList<TreeItem<T>> originalItems;
    FilteredList<TreeItem<T>> filteredItems;

    public RecursiveTreeItem(Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(null, null, func);
    }

    public RecursiveTreeItem(T value, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(value, null, func);
    }

    public RecursiveTreeItem(T value, Node graphic, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        super(value, graphic);
        this.predicate = new SimpleObjectProperty((Object)RecursiveTreeItem$$Lambda$1.lambdaFactory$());
        this.childrenFactory = func;
        this.init((RecursiveTreeObject<T>)value);
    }

    public RecursiveTreeItem(ObservableList<T> dataList, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this.predicate = new SimpleObjectProperty((Object)RecursiveTreeItem$$Lambda$2.lambdaFactory$());
        RecursiveTreeObject<T> root2 = new RecursiveTreeObject<T>();
        root2.setChildren(dataList);
        this.childrenFactory = func;
        this.init(root2);
    }

    private void init(RecursiveTreeObject<T> value) {
        this.addChildrenListener(value);
        this.valueProperty().addListener(RecursiveTreeItem$$Lambda$3.lambdaFactory$(this));
        this.predicate.addListener(RecursiveTreeItem$$Lambda$4.lambdaFactory$(this));
        this.filteredItems.predicateProperty().addListener(RecursiveTreeItem$$Lambda$5.lambdaFactory$(this));
    }

    private void addChildrenListener(RecursiveTreeObject<T> value) {
        ObservableList children = (ObservableList)this.childrenFactory.call(value);
        this.originalItems = FXCollections.observableArrayList();
        this.itemsMap = new HashMap();
        for (RecursiveTreeObject child : children) {
            RecursiveTreeItem<RecursiveTreeObject> treeItem = new RecursiveTreeItem<RecursiveTreeObject>(child, this.getGraphic(), this.childrenFactory);
            this.originalItems.add(treeItem);
            this.itemsMap.put(child, treeItem);
        }
        this.filteredItems = new FilteredList(this.originalItems, RecursiveTreeItem$$Lambda$6.lambdaFactory$());
        this.getChildren().addAll(this.originalItems);
        children.addListener(RecursiveTreeItem$$Lambda$7.lambdaFactory$(this));
    }

    public final ObjectProperty<Predicate<TreeItem<T>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<T>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<T>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public TreeItem<T> getTreeItem(T value) {
        return this.itemsMap.get(value);
    }

    static /* synthetic */ void lambda$addChildrenListener$7(RecursiveTreeItem this_, ListChangeListener.Change change) {
        while (change.next()) {
            if (change.wasRemoved()) {
                ArrayList removedItems = new ArrayList();
                for (RecursiveTreeObject t : change.getRemoved()) {
                    TreeItem treeItem = this_.itemsMap.remove(t);
                    if (treeItem == null) continue;
                    removedItems.add(treeItem);
                }
                if (this_.originalItems.size() == removedItems.size()) {
                    this_.originalItems.clear();
                    this_.getChildren().clear();
                } else {
                    this_.getChildren().removeAll(removedItems);
                    this_.originalItems.removeAll(removedItems);
                }
            }
            if (!change.wasAdded()) continue;
            ArrayList<RecursiveTreeItem<RecursiveTreeObject>> addedItems = new ArrayList<RecursiveTreeItem<RecursiveTreeObject>>();
            for (RecursiveTreeObject newChild : change.getAddedSubList()) {
                RecursiveTreeItem<RecursiveTreeObject> newTreeItem = new RecursiveTreeItem<RecursiveTreeObject>(newChild, this_.getGraphic(), this_.childrenFactory);
                addedItems.add(newTreeItem);
                this_.itemsMap.put(newChild, newTreeItem);
            }
            this_.getChildren().addAll(addedItems);
            this_.originalItems.addAll(addedItems);
        }
    }

    static /* synthetic */ boolean lambda$addChildrenListener$6(TreeItem t) {
        return true;
    }

    static /* synthetic */ void lambda$init$5(RecursiveTreeItem this_, Observable observable2) {
        JFXUtilities.runInFXAndWait(RecursiveTreeItem$$Lambda$8.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$null$4(RecursiveTreeItem this_) {
        this_.getChildren().clear();
        this_.getChildren().setAll(this_.filteredItems);
    }

    static /* synthetic */ void lambda$init$3(RecursiveTreeItem this_, Observable observable2) {
        this_.filteredItems.setPredicate(RecursiveTreeItem$$Lambda$9.lambdaFactory$(this_));
    }

    static /* synthetic */ boolean lambda$null$2(RecursiveTreeItem this_, TreeItem child) {
        if (child instanceof RecursiveTreeItem && !((RecursiveTreeItem)child).originalItems.isEmpty()) {
            RecursiveTreeItem filterableChild = (RecursiveTreeItem)child;
            filterableChild.setPredicate((Predicate)this_.predicate.get());
        }
        if (this_.predicate.get() == null) {
            return true;
        }
        if (child.getChildren().size() > 0) {
            return true;
        }
        if (child.getValue() instanceof RecursiveTreeObject && ((RecursiveTreeObject)child.getValue()).getClass() == RecursiveTreeObject.class) {
            return child.getChildren().size() != 0;
        }
        return ((Predicate)this_.predicate.get()).test(child);
    }

    static /* synthetic */ void lambda$init$1(RecursiveTreeItem this_, Observable observable2) {
        if (this_.getValue() != null) {
            this_.addChildrenListener((RecursiveTreeObject)this_.getValue());
        }
    }

    static /* synthetic */ boolean lambda$new$0(TreeItem t) {
        return true;
    }
}

