/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.JFXChip;
import com.jfoenix.controls.JFXChipView;
import com.jfoenix.controls.JFXDefaultChip;
import com.jfoenix.controls.events.JFXAutoCompleteEvent;
import com.jfoenix.skins.JFXAutoCompletePopupSkin;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$1;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$2;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$3;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$4;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$5;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$6;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$7;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$8;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$9;
import com.jfoenix.skins.JFXChipViewSkin$CustomFlowPane$$Lambda$1;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.traversal.Direction;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class JFXChipViewSkin<T>
extends BehaviorSkinBase<JFXChipView<T>, ChipViewBehaviorBase<T>> {
    private static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private CustomFlowPane root;
    private JFXChipView<T> control;
    private FakeFocusTextArea editor;
    private ChipsAutoComplete<T> autoCompletePopup;
    private boolean moveToNewLine = false;
    private boolean editorOnNewLine = true;
    private double availableWidth;
    private double requiredWidth;
    private final ListChangeListener<T> chipsChangeListeners = JFXChipViewSkin$$Lambda$1.lambdaFactory$(this);
    private final ScrollPane scrollPane;

    public JFXChipViewSkin(JFXChipView<T> control) {
        super(control, new ChipViewBehaviorBase<T>(control, null));
        this.control = control;
        this.root = new CustomFlowPane();
        this.root.getStyleClass().add((Object)"chips-pane");
        this.setupEditor();
        this.scrollPane = new ScrollPane((Node)this.root){

            public void requestFocus() {
                if (JFXChipViewSkin.this.getSkinnable() != null) {
                    ((JFXChipView)JFXChipViewSkin.this.getSkinnable()).requestFocus();
                }
            }
        };
        this.scrollPane.setFitToWidth(true);
        this.getChildren().add((Object)this.scrollPane);
        this.autoCompletePopup = (ChipsAutoComplete)((JFXChipView)this.getSkinnable()).getAutoCompletePopup();
        this.autoCompletePopup.setSelectionHandler(JFXChipViewSkin$$Lambda$2.lambdaFactory$(this));
        this.autoCompletePopup.setShift(this.root.getVgap() * 2.0);
        this.root.vgapProperty().addListener(JFXChipViewSkin$$Lambda$3.lambdaFactory$(this));
        for (Object item2 : control.getChips()) {
            this.createChip(item2);
        }
        control.getChips().addListener((ListChangeListener)new WeakListChangeListener(this.chipsChangeListeners));
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.scrollPane.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
    }

    private void setupEditor() {
        this.editor = new FakeFocusTextArea();
        this.editor.setManaged(false);
        this.editor.getStyleClass().add((Object)"editor");
        this.editor.setWrapText(true);
        this.editor.addEventFilter(KeyEvent.KEY_RELEASED, JFXChipViewSkin$$Lambda$4.lambdaFactory$(this));
        this.editor.addEventFilter(KeyEvent.KEY_PRESSED, JFXChipViewSkin$$Lambda$5.lambdaFactory$(this));
        this.editor.textProperty().addListener(JFXChipViewSkin$$Lambda$6.lambdaFactory$(this));
        this.root.getChildren().add((Object)this.editor);
        this.control.focusedProperty().addListener(JFXChipViewSkin$$Lambda$7.lambdaFactory$(this));
        this.control.addEventFilter(KeyEvent.ANY, JFXChipViewSkin$$Lambda$8.lambdaFactory$(this));
    }

    private void createChip(T item2) {
        JFXChip chip = null;
        try {
            chip = ((JFXChipView)this.getSkinnable()).getChipFactory() != null ? ((JFXChipView)this.getSkinnable()).getChipFactory().apply((JFXChipView<Control>)this.getSkinnable(), (Control)item2) : new JFXDefaultChip<T>((JFXChipView)this.getSkinnable(), item2);
        }
        catch (Exception e) {
            throw new RuntimeException("can't create chip for item '" + item2 + "' make sure to override the string converter and return null if text input is not valid.", e);
        }
        int size = this.root.getChildren().size();
        this.root.getChildren().add(size - 1, chip);
    }

    private double computeTextContentWidth(TextInputControl editor) {
        Text text2 = new Text(editor.getText());
        text2.setFont(editor.getFont());
        text2.applyCss();
        return text2.getLayoutBounds().getWidth();
    }

    static /* synthetic */ void lambda$setupEditor$8(JFXChipViewSkin this_, KeyEvent ke) {
        if (this_.editor != null) {
            if (ke.getTarget().equals((Object)this_.editor)) {
                return;
            }
            if (ke.getTarget().equals((Object)this_.control)) {
                switch (ke.getCode()) {
                    case ESCAPE: 
                    case F10: {
                        break;
                    }
                    default: {
                        this_.editor.fireEvent((Event)ke.copyFor((Object)this_.editor, (EventTarget)this_.editor));
                        ke.consume();
                    }
                }
            }
        }
    }

    static /* synthetic */ void lambda$setupEditor$7(JFXChipViewSkin this_, ObservableValue obj, Boolean oldVal, Boolean newVal) {
        if (this_.editor != null) {
            this_.editor.setFakeFocus(newVal);
        }
    }

    static /* synthetic */ void lambda$setupEditor$6(JFXChipViewSkin this_, Observable observable2) {
        this_.requiredWidth = this_.editor.snappedLeftInset() + this_.computeTextContentWidth((TextInputControl)this_.editor) + this_.editor.snappedRightInset() + 13.0;
        if (this_.availableWidth < this_.requiredWidth && !this_.editorOnNewLine && !this_.moveToNewLine) {
            this_.moveToNewLine = true;
            this_.root.requestLayout();
        } else if (this_.availableWidth > this_.requiredWidth && this_.editorOnNewLine && this_.moveToNewLine) {
            this_.moveToNewLine = false;
            this_.root.requestLayout();
        }
        this_.autoCompletePopup.filter(JFXChipViewSkin$$Lambda$9.lambdaFactory$(this_));
        if (this_.autoCompletePopup.getFilteredSuggestions().isEmpty()) {
            this_.autoCompletePopup.hide();
        } else {
            this_.autoCompletePopup.show((Node)this_.editor);
        }
    }

    static /* synthetic */ boolean lambda$null$5(JFXChipViewSkin this_, Object item2) {
        return ((JFXChipView)this_.getSkinnable()).getPredicate().test(item2, this_.editor.getText());
    }

    static /* synthetic */ void lambda$setupEditor$4(JFXChipViewSkin this_, KeyEvent event) {
        switch (event.getCode()) {
            case ENTER: {
                if (!this_.editor.getText().trim().isEmpty()) {
                    try {
                        StringConverter sc = this_.control.getConverter();
                        Object item2 = sc.fromString(this_.editor.getText());
                        if (item2 != null) {
                            ((JFXChipView)this_.getSkinnable()).getChips().add(item2);
                        }
                        this_.editor.clear();
                        this_.autoCompletePopup.hide();
                    }
                    catch (Exception ex) {
                        ((JFXChipView)this_.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
                    }
                }
                event.consume();
                break;
            }
            case TAB: {
                if (this_.editor.getText().trim().isEmpty()) {
                    if (event.isShiftDown()) {
                        ((ChipViewBehaviorBase)this_.getBehavior()).traverse((Node)this_.getSkinnable(), Direction.PREVIOUS);
                    } else {
                        ((ChipViewBehaviorBase)this_.getBehavior()).traverse((Node)this_.editor, Direction.NEXT);
                    }
                }
                event.consume();
                break;
            }
            case BACK_SPACE: {
                ObservableList chips = ((JFXChipView)this_.getSkinnable()).getChips();
                int size = chips.size();
                if (size <= 0 || !this_.editor.getText().isEmpty()) break;
                chips.remove(size - 1);
                if (!this_.autoCompletePopup.isShowing()) break;
                this_.autoCompletePopup.hide();
                break;
            }
            case SPACE: {
                if (!event.isControlDown() || this_.autoCompletePopup.getFilteredSuggestions().isEmpty()) break;
                this_.autoCompletePopup.show((Node)this_.editor);
            }
        }
    }

    static /* synthetic */ void lambda$setupEditor$3(JFXChipViewSkin this_, KeyEvent event) {
        if (event.getCode() != KeyCode.ENTER) {
            ((JFXChipView)this_.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
        }
    }

    static /* synthetic */ void lambda$new$2(JFXChipViewSkin this_, Observable observable2) {
        this_.autoCompletePopup.setShift(this_.root.getVgap() * 2.0);
    }

    static /* synthetic */ void lambda$new$1(JFXChipViewSkin this_, JFXAutoCompleteEvent event) {
        Object selectedItem = event.getObject();
        if (((JFXChipView)this_.getSkinnable()).getSelectionHandler() != null) {
            selectedItem = ((JFXChipView)this_.getSkinnable()).getSelectionHandler().apply(selectedItem);
        }
        ((JFXChipView)this_.getSkinnable()).getChips().add(selectedItem);
        this_.editor.clear();
    }

    static /* synthetic */ void lambda$new$0(JFXChipViewSkin this_, ListChangeListener.Change change) {
        while (change.next()) {
            block1: for (Object item2 : change.getRemoved()) {
                for (int i2 = this_.root.getChildren().size() - 2; i2 >= 0; --i2) {
                    Node child = (Node)this_.root.getChildren().get(i2);
                    if (!(child instanceof JFXChip) || ((JFXChip)child).getItem() != item2) continue;
                    this_.root.getChildren().remove(i2);
                    continue block1;
                }
            }
            for (Object item2 : change.getAddedSubList()) {
                this_.createChip(item2);
            }
        }
    }

    static final class ChipViewBehaviorBase<T>
    extends BehaviorBase<JFXChipView<T>> {
        public ChipViewBehaviorBase(JFXChipView<T> control, List<KeyBinding> keyBindings) {
            super(control, keyBindings);
        }

        public void traverse(Node node2, Direction dir) {
            super.traverse(node2, dir);
        }
    }

    final class FakeFocusTextArea
    extends TextArea {
        FakeFocusTextArea() {
        }

        public void requestFocus() {
            if (JFXChipViewSkin.this.getSkinnable() != null) {
                ((JFXChipView)JFXChipViewSkin.this.getSkinnable()).requestFocus();
            }
        }

        public void setFakeFocus(boolean b) {
            this.setFocused(b);
        }

        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters2) {
            switch (attribute) {
                case FOCUS_ITEM: {
                    return JFXChipViewSkin.this.getSkinnable();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters2);
        }
    }

    public static class ChipsAutoComplete<T>
    extends JFXAutoCompletePopup<T> {
        private double shift = 0.0;
        private Text text;

        public ChipsAutoComplete() {
            this.getStyleClass().add((Object)"jfx-chips-popup");
        }

        void setShift(double shift) {
            this.shift = shift;
        }

        @Override
        public void show(Node node2) {
            if (this.text == null) {
                this.text = (Text)node2.lookup(".text");
            }
            node2 = this.text;
            if (!this.isShowing()) {
                if (node2.getScene() == null || node2.getScene().getWindow() == null) {
                    throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
                }
                Window parent = node2.getScene().getWindow();
                this.show(parent, parent.getX() + node2.localToScene(0.0, 0.0).getX() + node2.getScene().getX(), parent.getY() + node2.localToScene(0.0, 0.0).getY() + node2.getScene().getY() + node2.getLayoutBounds().getHeight() + this.shift);
                ((JFXAutoCompletePopupSkin)this.getSkin()).animate();
            } else {
                Window parent = node2.getScene().getWindow();
                this.show(parent, parent.getX() + node2.localToScene(0.0, 0.0).getX() + node2.getScene().getX(), parent.getY() + node2.localToScene(0.0, 0.0).getY() + node2.getScene().getY() + node2.getLayoutBounds().getHeight() + this.shift);
            }
        }
    }

    private class CustomFlowPane
    extends FlowPane {
        double initOffset = 8.0;

        private CustomFlowPane() {
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, JFXChipViewSkin$CustomFlowPane$$Lambda$1.lambdaFactory$(this));
        }

        private void ensureVisible(Node node2) {
            double height = JFXChipViewSkin.this.scrollPane.getContent().getBoundsInLocal().getHeight();
            double y = node2.getBoundsInParent().getMaxY();
            JFXChipViewSkin.this.scrollPane.setVvalue(y / height);
            node2.requestFocus();
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.updateEditorPosition();
        }

        protected double computePrefHeight(double forWidth) {
            JFXChipViewSkin.this.editor.setManaged(true);
            double height = super.computePrefHeight(forWidth);
            JFXChipViewSkin.this.editor.setManaged(false);
            return height;
        }

        private VPos getRowVAlignmentInternal() {
            VPos localPos = this.getRowValignment();
            return localPos == null ? VPos.CENTER : localPos;
        }

        private HPos getColumnHAlignmentInternal() {
            HPos localPos = this.getColumnHalignment();
            return localPos == null ? HPos.LEFT : localPos;
        }

        public void updateEditorPosition() {
            Insets insets = this.getInsets();
            double width = this.getWidth();
            double height = this.getHeight();
            double top2 = insets.getTop();
            double left2 = insets.getLeft();
            double bottom2 = insets.getBottom();
            double right2 = insets.getRight();
            double insideWidth = width - left2 - right2;
            double insideHeight = height - top2 - bottom2;
            double newLineEditorX = right2 + this.initOffset;
            double editorVInsets = JFXChipViewSkin.this.editor.snappedTopInset() + JFXChipViewSkin.this.editor.snappedBottomInset();
            List managedChildren = this.getManagedChildren();
            int mangedChildrenSize = managedChildren.size();
            if (mangedChildrenSize > 0) {
                Region lastChild = (Region)managedChildren.get(mangedChildrenSize - 1);
                double contentHeight = lastChild.getHeight() + lastChild.getLayoutY();
                JFXChipViewSkin.this.availableWidth = insideWidth - lastChild.getBoundsInParent().getMaxX();
                double minWidth = JFXChipViewSkin.this.editor.getMinWidth();
                minWidth = minWidth < 0.0 ? 100.0 : minWidth;
                minWidth = Math.max(minWidth, JFXChipViewSkin.this.requiredWidth);
                if (JFXChipViewSkin.this.availableWidth > JFXChipViewSkin.this.requiredWidth) {
                    JFXChipViewSkin.this.moveToNewLine = false;
                }
                if (JFXChipViewSkin.this.availableWidth < minWidth || JFXChipViewSkin.this.moveToNewLine) {
                    this.layoutInArea((Node)JFXChipViewSkin.this.editor, newLineEditorX, contentHeight + JFXChipViewSkin.this.root.getVgap(), insideWidth - this.initOffset, JFXChipViewSkin.this.editor.prefHeight(-1.0), 0.0, this.getColumnHAlignmentInternal(), VPos.TOP);
                    JFXChipViewSkin.this.editorOnNewLine = true;
                    this.ensureVisible((Node)JFXChipViewSkin.this.editor);
                } else {
                    this.layoutInArea((Node)JFXChipViewSkin.this.editor, lastChild.getBoundsInParent().getMaxX() + JFXChipViewSkin.this.root.getHgap(), lastChild.getLayoutY(), JFXChipViewSkin.this.availableWidth - JFXChipViewSkin.this.root.getHgap(), lastChild.getHeight() + editorVInsets, 0.0, this.getColumnHAlignmentInternal(), this.getRowVAlignmentInternal());
                    JFXChipViewSkin.this.editorOnNewLine = false;
                }
            } else {
                this.layoutInArea((Node)JFXChipViewSkin.this.editor, newLineEditorX, top2, insideWidth - this.initOffset, JFXChipViewSkin.this.editor.prefHeight(-1.0), 0.0, this.getColumnHAlignmentInternal(), VPos.TOP);
                JFXChipViewSkin.this.editorOnNewLine = true;
                this.ensureVisible((Node)JFXChipViewSkin.this.editor);
            }
        }

        static /* synthetic */ void lambda$new$0(CustomFlowPane this_, MouseEvent event) {
            this_.ensureVisible((Node)this_.JFXChipViewSkin.this.editor);
        }
    }
}

