/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.skins.JFXProgressBarSkin$$Lambda$1;
import com.jfoenix.skins.JFXProgressBarSkin$$Lambda$2;
import com.jfoenix.utils.JFXNodeUtils;
import com.sun.javafx.scene.control.skin.ProgressIndicatorSkin;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXProgressBarSkin
extends ProgressIndicatorSkin {
    private StackPane track;
    private StackPane secondaryBar;
    private StackPane bar;
    private double barWidth = 0.0;
    private double secondaryBarWidth = 0.0;
    private Region clip;
    boolean wasIndeterminate = false;

    public JFXProgressBarSkin(JFXProgressBar bar) {
        super((ProgressIndicator)bar);
        bar.widthProperty().addListener(JFXProgressBarSkin$$Lambda$1.lambdaFactory$(this));
        this.registerChangeListener((ObservableValue)bar.secondaryProgressProperty(), "SECONDARY_PROGRESS");
        this.registerChangeListener((ObservableValue)bar.visibleProperty(), "VISIBLE");
        this.registerChangeListener((ObservableValue)bar.parentProperty(), "PARENT");
        this.registerChangeListener((ObservableValue)bar.sceneProperty(), "SCENE");
        ((ProgressIndicator)this.getSkinnable()).requestLayout();
    }

    public void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.bar = new StackPane();
        this.bar.getStyleClass().setAll((Object[])new String[]{"bar"});
        this.secondaryBar = new StackPane();
        this.secondaryBar.getStyleClass().setAll((Object[])new String[]{"secondary-bar"});
        this.clip = new Region();
        this.clip.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.bar.backgroundProperty().addListener(JFXProgressBarSkin$$Lambda$2.lambdaFactory$(this));
        this.getChildren().setAll((Object[])new Node[]{this.track, this.secondaryBar, this.bar});
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("SECONDARY_PROGRESS".equals(p)) {
            this.updateSecondaryProgress();
        } else if ("VISIBLE".equals(p)) {
            this.updateAnimation();
        } else if ("PARENT".equals(p)) {
            this.updateAnimation();
        } else if ("SCENE".equals(p)) {
            this.updateAnimation();
        }
    }

    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.NEGATIVE_INFINITY;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(100.0, leftInset + this.bar.prefWidth(((ProgressIndicator)this.getSkinnable()).getWidth()) + rightInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.bar.prefHeight(width) + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ProgressIndicator)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ProgressIndicator)this.getSkinnable()).prefHeight(width);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.track.resizeRelocate(x, y, w, h);
        this.secondaryBar.resizeRelocate(x, y, this.secondaryBarWidth, h);
        this.bar.resizeRelocate(x, y, ((ProgressIndicator)this.getSkinnable()).isIndeterminate() ? w : this.barWidth, h);
        this.clip.resizeRelocate(0.0, 0.0, w, h);
        if (((ProgressIndicator)this.getSkinnable()).isIndeterminate()) {
            this.createIndeterminateTimeline();
            if (((ProgressIndicator)this.getSkinnable()).impl_isTreeVisible()) {
                this.indeterminateTransition.play();
            }
            this.bar.setClip((Node)this.clip);
        } else if (this.indeterminateTransition != null) {
            this.clearAnimation();
            this.bar.setClip(null);
        }
    }

    protected void updateSecondaryProgress() {
        JFXProgressBar control = (JFXProgressBar)this.getSkinnable();
        this.secondaryBarWidth = (double)((int)(control.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, control.getSecondaryProgress())) / 2.0;
        control.requestLayout();
    }

    protected void pauseTimeline(boolean pause2) {
        if (((ProgressIndicator)this.getSkinnable()).isIndeterminate()) {
            if (this.indeterminateTransition == null) {
                this.createIndeterminateTimeline();
            }
            if (pause2) {
                this.indeterminateTransition.pause();
            } else {
                this.indeterminateTransition.play();
            }
        }
    }

    protected void updateAnimation() {
        boolean isTreeVisible;
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        boolean bl = isTreeVisible = control.isVisible() && control.getParent() != null && control.getScene() != null;
        if (this.indeterminateTransition != null) {
            this.pauseTimeline(!isTreeVisible);
        } else if (isTreeVisible) {
            this.createIndeterminateTimeline();
        }
    }

    protected void updateProgress() {
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        boolean isIndeterminate = control.isIndeterminate();
        if (!isIndeterminate || !this.wasIndeterminate) {
            this.barWidth = (double)((int)(control.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, control.getProgress())) / 2.0;
            control.requestLayout();
        }
        this.wasIndeterminate = isIndeterminate;
    }

    protected void createIndeterminateTimeline() {
        if (this.indeterminateTransition != null) {
            this.clearAnimation();
        }
        double dur = 1.0;
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        this.indeterminateTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.clip.scaleXProperty(), (Object)0.0, Interpolator.EASE_IN), new KeyValue((WritableValue)this.clip.translateXProperty(), (Object)(-w / 2.0), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(0.5 * dur)), new KeyValue[]{new KeyValue((WritableValue)this.clip.scaleXProperty(), (Object)0.4, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(0.9 * dur)), new KeyValue[]{new KeyValue((WritableValue)this.clip.translateXProperty(), (Object)(w / 2.0), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(1.0 * dur)), new KeyValue[]{new KeyValue((WritableValue)this.clip.scaleXProperty(), (Object)0.0, Interpolator.EASE_OUT)})});
        this.indeterminateTransition.setCycleCount(-1);
    }

    private void clearAnimation() {
        this.indeterminateTransition.stop();
        ((Timeline)this.indeterminateTransition).getKeyFrames().clear();
        this.indeterminateTransition = null;
    }

    public void dispose() {
        super.dispose();
        if (this.indeterminateTransition != null) {
            this.clearAnimation();
        }
    }

    static /* synthetic */ void lambda$initialize$1(JFXProgressBarSkin this_, Observable observable2) {
        JFXNodeUtils.updateBackground(this_.bar.getBackground(), this_.clip);
    }

    static /* synthetic */ void lambda$new$0(JFXProgressBarSkin this_, Observable observable2) {
        this_.updateProgress();
        this_.updateSecondaryProgress();
    }
}

