/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$1;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$10;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$11;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$12;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$13;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$14;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$15;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$16;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$2;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$3;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$4;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$5;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$6;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$7;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$8;
import com.jfoenix.skins.PromptLinesWrapper$$Lambda$9;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class PromptLinesWrapper<T extends Control> {
    private final Supplier<Text> promptTextSupplier;
    private T control;
    public StackPane line = new StackPane();
    public StackPane focusedLine = new StackPane();
    public StackPane promptContainer = new StackPane();
    private JFXAnimationTimer focusTimer;
    private JFXAnimationTimer unfocusTimer;
    private double initScale = 0.05;
    public final Scale promptTextScale = new Scale(1.0, 1.0, 0.0, 0.0);
    private final Scale scale = new Scale(this.initScale, 1.0);
    public final Rectangle clip = new Rectangle();
    public ObjectProperty<Paint> animatedPromptTextFill;
    public BooleanBinding usePromptText;
    ObjectProperty<Paint> promptTextFill;
    ObservableValue<?> valueProperty;
    ObservableValue<String> promptTextProperty;
    private boolean animating = false;
    private double contentHeight = 0.0;

    public PromptLinesWrapper(T control, ObjectProperty<Paint> promptTextFill, ObservableValue<?> valueProperty, ObservableValue<String> promptTextProperty, Supplier<Text> promptTextSupplier) {
        this.control = control;
        this.promptTextSupplier = promptTextSupplier;
        this.promptTextFill = promptTextFill;
        this.valueProperty = valueProperty;
        this.promptTextProperty = promptTextProperty;
    }

    public void init(Runnable createPromptNodeRunnable, Node ... cachedNodes) {
        this.animatedPromptTextFill = new SimpleObjectProperty(this.promptTextFill.get());
        this.usePromptText = Bindings.createBooleanBinding((Callable)PromptLinesWrapper$$Lambda$1.lambdaFactory$(this), (Observable[])new Observable[]{this.valueProperty, this.promptTextProperty, ((IFXLabelFloatControl)this.control).labelFloatProperty(), this.promptTextFill});
        this.line.setManaged(false);
        this.line.getStyleClass().add((Object)"input-line");
        this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((IFXLabelFloatControl)this.control).getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.focusedLine.setManaged(false);
        this.focusedLine.getStyleClass().add((Object)"input-focused-line");
        this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((IFXLabelFloatControl)this.control).getFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.focusedLine.setOpacity(0.0);
        this.focusedLine.getTransforms().add((Object)this.scale);
        if (this.usePromptText.get()) {
            createPromptNodeRunnable.run();
        }
        this.usePromptText.addListener(PromptLinesWrapper$$Lambda$2.lambdaFactory$(this, createPromptNodeRunnable));
        this.focusTimer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)1.0), JFXKeyValue.builder().setTarget(this.focusedLine.opacityProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(PromptLinesWrapper$$Lambda$3.lambdaFactory$(this)).build()), new JFXKeyFrame(Duration.millis((double)160.0), JFXKeyValue.builder().setTarget(this.scale.xProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(PromptLinesWrapper$$Lambda$4.lambdaFactory$(this)).build(), JFXKeyValue.builder().setTarget(this.animatedPromptTextFill).setEndValueSupplier(PromptLinesWrapper$$Lambda$5.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(PromptLinesWrapper$$Lambda$6.lambdaFactory$(this)).build(), JFXKeyValue.builder().setTargetSupplier(PromptLinesWrapper$$Lambda$7.lambdaFactory$(this)).setEndValueSupplier(PromptLinesWrapper$$Lambda$8.lambdaFactory$(this)).setAnimateCondition(PromptLinesWrapper$$Lambda$9.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.xProperty()).setEndValue(0.85).setAnimateCondition(PromptLinesWrapper$$Lambda$10.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.yProperty()).setEndValue(0.85).setAnimateCondition(PromptLinesWrapper$$Lambda$11.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.unfocusTimer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)160.0), JFXKeyValue.builder().setTargetSupplier(PromptLinesWrapper$$Lambda$12.lambdaFactory$(this)).setEndValue(0).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.xProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.yProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.promptContainer.setManaged(false);
        this.promptContainer.setMouseTransparent(true);
        this.clip.setSmooth(false);
        this.clip.setX(0.0);
        this.clip.widthProperty().bind((ObservableValue)this.promptContainer.widthProperty());
        this.promptContainer.setClip((Node)this.clip);
        this.focusTimer.setOnFinished(PromptLinesWrapper$$Lambda$13.lambdaFactory$(this));
        this.unfocusTimer.setOnFinished(PromptLinesWrapper$$Lambda$14.lambdaFactory$(this));
        this.focusTimer.setCacheNodes(cachedNodes);
        this.unfocusTimer.setCacheNodes(cachedNodes);
        this.control.focusedProperty().addListener(PromptLinesWrapper$$Lambda$15.lambdaFactory$(this));
        this.promptTextFill.addListener(PromptLinesWrapper$$Lambda$16.lambdaFactory$(this));
        this.updateDisabled();
    }

    private void focus() {
        this.unfocusTimer.stop();
        this.animating = true;
        this.runTimer(this.focusTimer, true);
    }

    private void unFocus() {
        this.focusTimer.stop();
        this.scale.setX(this.initScale);
        this.focusedLine.setOpacity(0.0);
        if (((IFXLabelFloatControl)this.control).isLabelFloat()) {
            this.animatedPromptTextFill.set(this.promptTextFill.get());
            Object text2 = this.valueProperty.getValue();
            text2 = this.validateComboBox(text2);
            if (text2 == null || text2.toString().isEmpty()) {
                this.animating = true;
                this.runTimer(this.unfocusTimer, true);
            }
        }
    }

    public void updateFocusColor() {
        Paint paint = ((IFXLabelFloatControl)this.control).getFocusColor();
        this.focusedLine.setBackground(paint == null ? Background.EMPTY : new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    public void updateUnfocusColor() {
        Paint paint = ((IFXLabelFloatControl)this.control).getUnFocusColor();
        this.line.setBackground(paint == null ? Background.EMPTY : new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    private void updateLabelFloat(boolean animation) {
        if (((IFXLabelFloatControl)this.control).isLabelFloat()) {
            if (this.control.isFocused()) {
                this.animateFloatingLabel(true, animation);
            } else {
                Object text2 = this.valueProperty.getValue();
                this.animateFloatingLabel((text2 = this.validateComboBox(text2)) != null && !text2.toString().isEmpty(), animation);
            }
        }
    }

    private Object validateComboBox(Object text2) {
        if (this.control instanceof ComboBox && ((ComboBox)this.control).isEditable()) {
            String editorText = ((ComboBox)this.control).getEditor().getText();
            text2 = editorText == null || editorText.isEmpty() ? null : text2;
        }
        return text2;
    }

    private void animateFloatingLabel(boolean up, boolean animation) {
        if (this.promptTextSupplier.get() == null) {
            return;
        }
        if (up) {
            if (this.promptTextSupplier.get().getTranslateY() != -this.contentHeight) {
                this.unfocusTimer.stop();
                this.runTimer(this.focusTimer, animation);
            }
        } else if (this.promptTextSupplier.get().getTranslateY() != 0.0) {
            this.focusTimer.stop();
            this.runTimer(this.unfocusTimer, animation);
        }
    }

    private void runTimer(JFXAnimationTimer timer, boolean animation) {
        if (animation) {
            if (!timer.isRunning()) {
                timer.start();
            }
        } else {
            timer.applyEndValues();
        }
    }

    private boolean usePromptText() {
        Object txt = this.valueProperty.getValue();
        txt = this.validateComboBox(txt);
        String promptTxt = (String)this.promptTextProperty.getValue();
        boolean isLabelFloat = ((IFXLabelFloatControl)this.control).isLabelFloat();
        return isLabelFloat || promptTxt != null && (txt == null || txt.toString().isEmpty()) && !promptTxt.isEmpty() && !((Paint)this.promptTextFill.get()).equals(Color.TRANSPARENT);
    }

    public void layoutLines(double x, double y, double w, double h, double controlHeight, double translateY) {
        this.contentHeight = translateY;
        this.clip.setY(-this.contentHeight);
        this.clip.setHeight(controlHeight + this.contentHeight);
        this.focusedLine.resizeRelocate(x, controlHeight, w, this.focusedLine.prefHeight(-1.0));
        this.line.resizeRelocate(x, controlHeight, w, this.line.prefHeight(-1.0));
        this.promptContainer.resizeRelocate(x, y, w, h);
        this.scale.setPivotX(w / 2.0);
    }

    public void updateLabelFloatLayout() {
        if (!this.animating) {
            this.updateLabelFloat(false);
        }
    }

    public void invalid() {
        if (this.control.isFocused()) {
            this.focus();
        }
    }

    public void updateDisabled() {
        boolean disabled = this.control.isDisable();
        this.line.setBorder(!disabled ? Border.EMPTY : new Border(new BorderStroke[]{new BorderStroke(((IFXLabelFloatControl)this.control).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(1.0))}));
        this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(disabled ? Color.TRANSPARENT : ((IFXLabelFloatControl)this.control).getUnFocusColor()), CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    static /* synthetic */ void lambda$init$14(PromptLinesWrapper this_, Observable observable2) {
        if (!((IFXLabelFloatControl)this_.control).isLabelFloat() || ((IFXLabelFloatControl)this_.control).isLabelFloat() && !this_.control.isFocused()) {
            this_.animatedPromptTextFill.set(this_.promptTextFill.get());
        }
    }

    static /* synthetic */ void lambda$init$13(PromptLinesWrapper this_, Observable observable2) {
        if (this_.control.isFocused()) {
            this_.focus();
        } else {
            this_.unFocus();
        }
    }

    static /* synthetic */ void lambda$init$12(PromptLinesWrapper this_) {
        this_.animating = false;
    }

    static /* synthetic */ void lambda$init$11(PromptLinesWrapper this_) {
        this_.animating = false;
    }

    static /* synthetic */ WritableValue lambda$init$10(PromptLinesWrapper this_) {
        return this_.promptTextSupplier.get() == null ? null : this_.promptTextSupplier.get().translateYProperty();
    }

    static /* synthetic */ Boolean lambda$init$9(PromptLinesWrapper this_) {
        return ((IFXLabelFloatControl)this_.control).isLabelFloat();
    }

    static /* synthetic */ Boolean lambda$init$8(PromptLinesWrapper this_) {
        return ((IFXLabelFloatControl)this_.control).isLabelFloat();
    }

    static /* synthetic */ Boolean lambda$init$7(PromptLinesWrapper this_) {
        return ((IFXLabelFloatControl)this_.control).isLabelFloat();
    }

    static /* synthetic */ Number lambda$init$6(PromptLinesWrapper this_) {
        return -this_.contentHeight;
    }

    static /* synthetic */ WritableValue lambda$init$5(PromptLinesWrapper this_) {
        return this_.promptTextSupplier.get() == null ? null : this_.promptTextSupplier.get().translateYProperty();
    }

    static /* synthetic */ Boolean lambda$init$4(PromptLinesWrapper this_) {
        return this_.control.isFocused() && ((IFXLabelFloatControl)this_.control).isLabelFloat();
    }

    static /* synthetic */ Paint lambda$init$3(PromptLinesWrapper this_) {
        return ((IFXLabelFloatControl)this_.control).getFocusColor();
    }

    static /* synthetic */ Boolean lambda$init$2(PromptLinesWrapper this_) {
        return this_.control.isFocused();
    }

    static /* synthetic */ Boolean lambda$init$1(PromptLinesWrapper this_) {
        return this_.control.isFocused();
    }

    static /* synthetic */ void lambda$init$0(PromptLinesWrapper this_, Runnable createPromptNodeRunnable, Observable observable2) {
        createPromptNodeRunnable.run();
        this_.control.requestLayout();
    }

    static /* synthetic */ boolean access$lambda$0(PromptLinesWrapper promptLinesWrapper) {
        return promptLinesWrapper.usePromptText();
    }
}

