/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import com.jfoenix.utils.JFXHighlighter$$Lambda$1;
import com.jfoenix.utils.JFXHighlighter$$Lambda$2;
import com.jfoenix.utils.JFXHighlighter$HighLightRectangle$$Lambda$1;
import com.jfoenix.utils.JFXHighlighter$HighLightRectangle$$Lambda$2;
import com.jfoenix.utils.JFXUtilities;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class JFXHighlighter {
    private Parent parent;
    private HashMap<Node, List<Rectangle>> boxes = new HashMap();
    private ObjectProperty<Paint> paint = new SimpleObjectProperty((Object)Color.rgb((int)255, (int)0, (int)0, (double)0.4));
    private Method textLayoutMethod;
    private Field parentChildrenField;

    public JFXHighlighter() {
        try {
            this.textLayoutMethod = Text.class.getDeclaredMethod("getTextLayout", new Class[0]);
            this.textLayoutMethod.setAccessible(true);
            this.parentChildrenField = Parent.class.getDeclaredField("children");
            this.parentChildrenField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void highlight(Parent pane2, String query) {
        if (this.parent != null && !this.boxes.isEmpty()) {
            this.clear();
        }
        if (query == null || query.isEmpty()) {
            return;
        }
        this.parent = pane2;
        Set<Node> nodes = this.getTextNodes(pane2);
        ArrayList<HighLightRectangle> allRectangles = new ArrayList<HighLightRectangle>();
        for (Node node2 : nodes) {
            Text text2 = (Text)node2;
            int beginIndex = text2.getText().toLowerCase().indexOf(query.toLowerCase());
            if (beginIndex <= -1 || !node2.isVisible()) continue;
            ArrayList<Bounds> boundingBoxes = this.getMatchingBounds(query, text2);
            ArrayList<HighLightRectangle> rectangles = new ArrayList<HighLightRectangle>();
            for (Bounds boundingBox : boundingBoxes) {
                HighLightRectangle rect = new HighLightRectangle(text2);
                rect.setCacheHint(CacheHint.SPEED);
                rect.setCache(true);
                rect.setMouseTransparent(true);
                rect.setBlendMode(BlendMode.MULTIPLY);
                rect.fillProperty().bind(this.paintProperty());
                rect.setManaged(false);
                rect.setX(boundingBox.getMinX());
                rect.setY(boundingBox.getMinY());
                rect.setWidth(boundingBox.getWidth());
                rect.setHeight(boundingBox.getHeight());
                rectangles.add(rect);
                allRectangles.add(rect);
            }
            this.boxes.put(node2, rectangles);
        }
        Platform.runLater((Runnable)JFXHighlighter$$Lambda$1.lambdaFactory$(this, pane2, allRectangles));
    }

    private Set<Node> getTextNodes(Parent pane2) {
        Set labeledTextNodes = pane2.lookupAll("LabeledText");
        Set textNodes = pane2.lookupAll("Text");
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.addAll(labeledTextNodes);
        nodes.addAll(textNodes);
        return nodes;
    }

    private ObservableList<Node> getParentChildren(Parent parent) {
        try {
            return (ObservableList)this.parentChildrenField.get(parent);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArrayList<Bounds> getMatchingBounds(String query, Text text2) {
        Bounds textBounds = this.parent.sceneToLocal(text2.localToScene(text2.getBoundsInLocal()));
        ArrayList<Bounds> rectBounds = new ArrayList<Bounds>();
        TextLayout textLayout = null;
        try {
            textLayout = (TextLayout)this.textLayoutMethod.invoke((Object)text2, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        int queryLength = query.length();
        TextLine[] lines = textLayout.getLines();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            String queryLow;
            TextLine line2 = lines[i2];
            String lineText = text2.getText().substring(line2.getStart(), line2.getStart() + line2.getLength());
            String lineTextLow = lineText.toLowerCase();
            int beginIndex = lineTextLow.indexOf(queryLow = query.toLowerCase());
            if (beginIndex == -1) continue;
            RectBounds lineBounds = line2.getBounds();
            double height = Math.round(lineBounds.getMaxY()) - Math.round(lineBounds.getMinY());
            double startY = height * (double)i2;
            while (beginIndex != -1) {
                Text temp = new Text(lineText.substring(beginIndex, beginIndex + queryLength));
                temp.setFont(text2.getFont());
                temp.applyCss();
                double width = temp.getLayoutBounds().getWidth();
                temp.setText(lineText.substring(0, beginIndex + queryLength));
                temp.applyCss();
                double maxX = temp.getLayoutBounds().getMaxX();
                double startX = maxX - width;
                rectBounds.add((Bounds)new BoundingBox(textBounds.getMinX() + startX, textBounds.getMinY() + startY, width, temp.getLayoutBounds().getHeight()));
                beginIndex = lineTextLow.indexOf(queryLow, beginIndex + queryLength);
            }
        }
        return rectBounds;
    }

    public synchronized void clear() {
        ArrayList<Rectangle> flatBoxes = new ArrayList<Rectangle>();
        Collection<List<Rectangle>> boxesCollection = this.boxes.values();
        for (List<Rectangle> box : boxesCollection) {
            flatBoxes.addAll(box);
        }
        this.boxes.clear();
        if (this.parent != null) {
            JFXUtilities.runInFX(JFXHighlighter$$Lambda$2.lambdaFactory$(this, flatBoxes));
        }
    }

    public Paint getPaint() {
        return (Paint)this.paint.get();
    }

    public ObjectProperty<Paint> paintProperty() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint.set((Object)paint);
    }

    static /* synthetic */ void lambda$clear$1(JFXHighlighter this_, List flatBoxes) {
        this_.getParentChildren(this_.parent).removeAll((Collection)flatBoxes);
    }

    static /* synthetic */ void lambda$highlight$0(JFXHighlighter this_, Parent pane2, ArrayList allRectangles) {
        this_.getParentChildren(pane2).addAll((Collection)allRectangles);
    }

    private class HighLightRectangle
    extends Rectangle {
        private InvalidationListener listener;

        public HighLightRectangle(Text text2) {
            this.listener = JFXHighlighter$HighLightRectangle$$Lambda$1.lambdaFactory$(this, text2);
            text2.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
            text2.localToSceneTransformProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        }

        private void clear(Text text2) {
            List rectangles = (List)JFXHighlighter.this.boxes.get(text2);
            if (rectangles != null && !rectangles.isEmpty()) {
                Platform.runLater((Runnable)JFXHighlighter$HighLightRectangle$$Lambda$2.lambdaFactory$(this, rectangles));
            }
        }

        static /* synthetic */ void lambda$clear$1(HighLightRectangle this_, List rectangles) {
            this_.JFXHighlighter.this.getParentChildren(this_.JFXHighlighter.this.parent).removeAll((Collection)rectangles);
        }

        static /* synthetic */ void lambda$new$0(HighLightRectangle this_, Text text2, Observable observable2) {
            this_.clear(text2);
        }
    }
}

