/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation;

import com.jfoenix.validation.base.ValidatorBase;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javafx.beans.DefaultProperty;
import javafx.scene.control.TextInputControl;
import javafx.util.converter.NumberStringConverter;

@DefaultProperty(value="icon")
public class NumberValidator
extends ValidatorBase {
    private NumberStringConverter numberStringConverter = new NumberStringConverter(){

        public Number fromString(String string2) {
            try {
                if (string2 == null) {
                    return null;
                }
                if ((string2 = string2.trim()).length() < 1) {
                    return null;
                }
                NumberFormat parser = this.getNumberFormat();
                ParsePosition parsePosition = new ParsePosition(0);
                Number result2 = parser.parse(string2, parsePosition);
                int index = parsePosition.getIndex();
                if (index == 0 || index < string2.length()) {
                    throw new ParseException("Unparseable number: \"" + string2 + "\"", parsePosition.getErrorIndex());
                }
                return result2;
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
    };

    public NumberValidator() {
    }

    public NumberValidator(String message2) {
        super(message2);
    }

    public NumberValidator(NumberStringConverter numberStringConverter) {
        this.numberStringConverter = numberStringConverter;
    }

    public NumberValidator(String message2, NumberStringConverter numberStringConverter) {
        super(message2);
        this.numberStringConverter = numberStringConverter;
    }

    @Override
    protected void eval() {
        if (this.srcControl.get() instanceof TextInputControl) {
            this.evalTextInputField();
        }
    }

    private void evalTextInputField() {
        TextInputControl textField = (TextInputControl)this.srcControl.get();
        String text2 = textField.getText();
        try {
            this.hasErrors.set(false);
            if (!text2.isEmpty()) {
                this.numberStringConverter.fromString(text2);
            }
        }
        catch (Exception e) {
            this.hasErrors.set(true);
        }
    }

    public NumberStringConverter getNumberStringConverter() {
        return this.numberStringConverter;
    }

    public void setNumberStringConverter(NumberStringConverter numberStringConverter) {
        this.numberStringConverter = numberStringConverter;
    }
}

