/*
 * Decompiled with CFR 0.152.
 */
package com.starsone.controls.common;

import com.starsone.controls.common.GlobalClipBoardListener;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/starsone/controls/common/SystemClipboardMonitor;", "Ljava/awt/datatransfer/ClipboardOwner;", "()V", "clipboard", "Ljava/awt/datatransfer/Clipboard;", "kotlin.jvm.PlatformType", "isOpenListener", "", "listener", "Lcom/starsone/controls/common/GlobalClipBoardListener;", "getListener", "()Lcom/starsone/controls/common/GlobalClipBoardListener;", "setListener", "(Lcom/starsone/controls/common/GlobalClipBoardListener;)V", "addClipboardListener", "", "lostOwnership", "contents", "Ljava/awt/datatransfer/Transferable;", "startListen", "stopListen", "common-controls"})
public final class SystemClipboardMonitor
implements ClipboardOwner {
    private final Clipboard clipboard;
    private boolean isOpenListener;
    @Nullable
    private GlobalClipBoardListener listener;

    @Nullable
    public final GlobalClipBoardListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable GlobalClipBoardListener globalClipBoardListener) {
        this.listener = globalClipBoardListener;
    }

    @Override
    public void lostOwnership(@Nullable Clipboard clipboard2, @Nullable Transferable contents) {
        try {
            Thread.sleep(10L);
            String text2 = "";
            Clipboard clipboard3 = clipboard2;
            if (clipboard3 != null) {
                if (clipboard3.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    text2 = clipboard2.getData(DataFlavor.stringFlavor).toString();
                }
            }
            Clipboard clipboard4 = clipboard2;
            if (clipboard4 != null) {
                clipboard4.setContents(clipboard2.getContents(null), this);
            }
            if (this.isOpenListener) {
                GlobalClipBoardListener globalClipBoardListener = this.listener;
                if (globalClipBoardListener != null) {
                    globalClipBoardListener.onCopy(text2, clipboard2, contents);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public final void stopListen() {
        this.isOpenListener = false;
    }

    public final void startListen() {
        this.isOpenListener = true;
    }

    public final void addClipboardListener(@NotNull GlobalClipBoardListener listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, "listener");
        this.listener = listener2;
    }

    public SystemClipboardMonitor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Intrinsics.checkExpressionValueIsNotNull(toolkit, "Toolkit.getDefaultToolkit()");
        this.clipboard = toolkit.getSystemClipboard();
        this.isOpenListener = true;
        this.clipboard.setContents(this.clipboard.getContents(null), this);
    }
}

