/*
 * Decompiled with CFR 0.152.
 */
package com.starsone.controls.download;

import com.starsone.controls.utils.TornadoFxUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/starsone/controls/download/HttpDownloader;", "", "url", "", "file", "(Ljava/lang/String;Ljava/lang/String;)V", "lastDownload", "", "sizeRead", "speedByte", "timer", "Ljava/util/Timer;", "speedToString", "bytes", "startCalculateSpeed", "", "startDownload", "onDownloading", "Lcom/starsone/controls/download/HttpDownloader$OnDownloading;", "OnDownloading", "common-controls"})
public final class HttpDownloader {
    private final Timer timer;
    private int lastDownload;
    private int sizeRead;
    private int speedByte;
    private final String url;
    private final String file;

    private final void startCalculateSpeed() {
        this.timer.schedule(new TimerTask(this){
            final /* synthetic */ HttpDownloader this$0;

            public void run() {
                HttpDownloader.access$setSpeedByte$p(this.this$0, HttpDownloader.access$getSizeRead$p(this.this$0) - HttpDownloader.access$getLastDownload$p(this.this$0));
                HttpDownloader.access$setLastDownload$p(this.this$0, HttpDownloader.access$getSizeRead$p(this.this$0));
            }
            {
                this.this$0 = $outer;
            }
        }, 0L, 1000L);
    }

    public final void startDownload(@NotNull OnDownloading onDownloading) {
        Intrinsics.checkParameterIsNotNull(onDownloading, "onDownloading");
        try {
            File file;
            String defaultFileName = StringsKt.substringAfterLast$default(this.url, "/", null, 2, null);
            URL url = new URL(this.url);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection httpConnection = (HttpURLConnection)uRLConnection;
            httpConnection.addRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36");
            CharSequence charSequence = this.file;
            if (charSequence.length() == 0) {
                if (httpConnection.getHeaderFields().containsKey("Content-Disposition")) {
                    String fileName = StringsKt.replace$default(StringsKt.replace$default(StringsKt.substringAfter$default(String.valueOf(httpConnection.getHeaderFields().get("Content-Disposition")), "filename=", null, 2, null), "filename=", "", false, 4, null), "]", "", false, 4, null);
                    String string2 = URLDecoder.decode(fileName, "utf-8");
                    Intrinsics.checkExpressionValueIsNotNull(string2, "URLDecoder.decode(fileName, \"utf-8\")");
                    fileName = string2;
                    file = new File(fileName);
                } else {
                    file = new File(defaultFileName);
                }
            } else {
                file = new File(TornadoFxUtil.Companion.getCurrentJarDirPath(), this.file);
            }
            File file2 = file;
            InputStream inputStream2 = httpConnection.getInputStream();
            int completeFileSize = httpConnection.getContentLength();
            byte[] bufferArray = new byte[10240];
            File file3 = file2;
            FileOutputStream fos = new FileOutputStream(file3);
            int length = 0;
            ThreadsKt.thread$default(false, false, null, null, 0, new Function0<Unit>(this){
                final /* synthetic */ HttpDownloader this$0;

                public final void invoke() {
                    HttpDownloader.access$startCalculateSpeed(this.this$0);
                }
                {
                    this.this$0 = httpDownloader;
                    super(0);
                }
            }, 31, null);
            while (true) {
                length = inputStream2.read(bufferArray);
                this.sizeRead += length;
                if (length == -1) break;
                onDownloading.onProgress((double)this.sizeRead * 100.0 / (double)completeFileSize, this.sizeRead * 100 / completeFileSize, this.speedToString(this.speedByte));
                int n = this.sizeRead * 100 / completeFileSize;
                System.out.println(n);
                fos.write(bufferArray, 0, length);
            }
            fos.flush();
            fos.close();
            onDownloading.onFinish();
            this.timer.cancel();
        }
        catch (IOException e) {
            this.timer.cancel();
            onDownloading.onError(e);
        }
    }

    private final String speedToString(int bytes) {
        DecimalFormat df = new DecimalFormat("#.00");
        return bytes < 1024 ? df.format((double)bytes) + "B/s" : (bytes < 0x100000 ? df.format((double)bytes / (double)1024) + "K/s" : (bytes < 0x40000000 ? df.format((double)bytes / (double)0x100000) + "M/s" : df.format((double)bytes / (double)0x40000000) + "G/s"));
    }

    public HttpDownloader(@NotNull String url, @NotNull String file) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Intrinsics.checkParameterIsNotNull(file, "file");
        this.url = url;
        this.file = file;
        this.timer = new Timer();
    }

    public static final /* synthetic */ int access$getSpeedByte$p(HttpDownloader $this) {
        return $this.speedByte;
    }

    public static final /* synthetic */ void access$setSpeedByte$p(HttpDownloader $this, int n) {
        $this.speedByte = n;
    }

    public static final /* synthetic */ int access$getSizeRead$p(HttpDownloader $this) {
        return $this.sizeRead;
    }

    public static final /* synthetic */ void access$setSizeRead$p(HttpDownloader $this, int n) {
        $this.sizeRead = n;
    }

    public static final /* synthetic */ int access$getLastDownload$p(HttpDownloader $this) {
        return $this.lastDownload;
    }

    public static final /* synthetic */ void access$setLastDownload$p(HttpDownloader $this, int n) {
        $this.lastDownload = n;
    }

    public static final /* synthetic */ void access$startCalculateSpeed(HttpDownloader $this) {
        $this.startCalculateSpeed();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J \u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lcom/starsone/controls/download/HttpDownloader$OnDownloading;", "", "onError", "", "e", "Ljava/io/IOException;", "onFinish", "onProgress", "progress", "", "percent", "", "speed", "", "common-controls"})
    public static interface OnDownloading {
        public void onProgress(double var1, int var3, @NotNull String var4);

        public void onFinish();

        public void onError(@NotNull IOException var1);
    }
}

