/*
 * Decompiled with CFR 0.152.
 */
package com.starsone.controls.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.font.FontDesignMetrics;
import tornadofx.ResourceLookup;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0012\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J$\u0010\u0012\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\u0012\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J(\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0006J.\u0010\u0019\u001a\u00020\n2\b\b\u0002\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/starsone/controls/utils/QRCodeUtil;", "", "()V", "BOTTOM_TEXT_SIZE", "", "FORMAT_TYPE", "", "LOGO_SIZE", "QRCODE_SIZE", "addFontImage", "", "source", "Ljava/awt/image/BufferedImage;", "declareText", "getQRCodeByte", "", "dataStr", "bottomText", "getQRCodeSwingImg", "url", "Ljava/net/URL;", "getQRcodeFxImg", "Ljavafx/scene/image/WritableImage;", "data", "logoPath", "initConfig", "qrcodeSize", "logoSize", "bottomTextSize", "qrcodeType", "insertLogoImage", "common-controls"})
public final class QRCodeUtil {
    private static int QRCODE_SIZE;
    private static int LOGO_SIZE;
    private static int BOTTOM_TEXT_SIZE;
    private static String FORMAT_TYPE;
    public static final QRCodeUtil INSTANCE;

    public final void initConfig(int qrcodeSize, int logoSize, int bottomTextSize, @NotNull String qrcodeType) {
        Intrinsics.checkParameterIsNotNull(qrcodeType, "qrcodeType");
        QRCODE_SIZE = qrcodeSize;
        LOGO_SIZE = logoSize;
        BOTTOM_TEXT_SIZE = bottomTextSize;
        FORMAT_TYPE = qrcodeType;
    }

    public static /* synthetic */ void initConfig$default(QRCodeUtil qRCodeUtil, int n, int n2, int n3, String string2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 320;
        }
        if ((n4 & 2) != 0) {
            n2 = 80;
        }
        if ((n4 & 4) != 0) {
            n3 = 20;
        }
        if ((n4 & 8) != 0) {
            string2 = "PNG";
        }
        qRCodeUtil.initConfig(n, n2, n3, string2);
    }

    @NotNull
    public final WritableImage getQRcodeFxImg(@Nullable String data2, @Nullable String logoPath, @Nullable String bottomText) {
        ResourceLookup resources2 = new ResourceLookup(this);
        URL url = logoPath == null ? null : resources2.url(logoPath);
        BufferedImage swingImg = this.getQRCodeSwingImg(data2, url, bottomText);
        WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)swingImg, null);
        Intrinsics.checkExpressionValueIsNotNull(writableImage, "SwingFXUtils.toFXImage(swingImg,null)");
        return writableImage;
    }

    @NotNull
    public static /* synthetic */ WritableImage getQRcodeFxImg$default(QRCodeUtil qRCodeUtil, String string2, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            string4 = null;
        }
        return qRCodeUtil.getQRcodeFxImg(string2, string3, string4);
    }

    @NotNull
    public final BufferedImage getQRCodeSwingImg(@Nullable String dataStr) throws Exception {
        return this.getQRCodeSwingImg(dataStr, null, null);
    }

    @NotNull
    public final byte[] getQRCodeByte(@Nullable String dataStr) throws Exception {
        BufferedImage bufferedImage = this.getQRCodeSwingImg(dataStr, null, null);
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, FORMAT_TYPE, outputStream2);
        byte[] byArray = outputStream2.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "outputStream.toByteArray()");
        return byArray;
    }

    @NotNull
    public final BufferedImage getQRCodeSwingImg(@Nullable String dataStr, @Nullable String bottomText) throws Exception {
        return this.getQRCodeSwingImg(dataStr, null, bottomText);
    }

    @NotNull
    public final byte[] getQRCodeByte(@Nullable String dataStr, @Nullable String bottomText) throws Exception {
        BufferedImage bufferedImage = this.getQRCodeSwingImg(dataStr, null, bottomText);
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, FORMAT_TYPE, outputStream2);
        byte[] byArray = outputStream2.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "outputStream.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BufferedImage getQRCodeSwingImg(@Nullable String dataStr, @Nullable URL url, @Nullable String bottomText) throws Exception {
        int height;
        BitMatrix bitMatrix;
        if (dataStr == null) {
            throw (Throwable)new RuntimeException("\u672a\u5305\u542b\u4efb\u4f55\u4fe1\u606f");
        }
        HashMap hints = new HashMap();
        Map map2 = hints;
        EncodeHintType encodeHintType = EncodeHintType.CHARACTER_SET;
        Object object = "utf-8";
        map2.put(encodeHintType, object);
        map2 = hints;
        encodeHintType = EncodeHintType.ERROR_CORRECTION;
        object = ErrorCorrectionLevel.L;
        map2.put(encodeHintType, object);
        map2 = hints;
        encodeHintType = EncodeHintType.MARGIN;
        object = 1;
        map2.put(encodeHintType, object);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix2 = bitMatrix = qrCodeWriter.encode(dataStr, BarcodeFormat.QR_CODE, QRCODE_SIZE, QRCODE_SIZE, hints);
        Intrinsics.checkExpressionValueIsNotNull(bitMatrix2, "bitMatrix");
        int width = bitMatrix2.getWidth();
        int tempHeight = height = bitMatrix.getHeight();
        if (StringUtils.isNotBlank(bottomText)) {
            tempHeight += 12;
        }
        BufferedImage image = new BufferedImage(width, tempHeight, 1);
        int n = 0;
        int n2 = width;
        while (n < n2) {
            void x;
            int n3 = 0;
            int n4 = height;
            while (n3 < n4) {
                void y;
                image.setRGB((int)x, (int)y, bitMatrix.get((int)x, (int)y) ? -16777216 : -1);
                ++y;
            }
            ++x;
        }
        if (url != null) {
            this.insertLogoImage(image, url);
        }
        if (StringUtils.isNotBlank(bottomText)) {
            this.addFontImage(image, bottomText);
        }
        return image;
    }

    private final void insertLogoImage(BufferedImage source2, URL url) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(url);
        Intrinsics.checkExpressionValueIsNotNull(bufferedImage, "ImageIO.read(url)");
        Image src = bufferedImage;
        int width = LOGO_SIZE;
        int height = LOGO_SIZE;
        Image image = src.getScaledInstance(width, height, 4);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        Image image2 = image;
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        src = image2;
        Graphics2D graph = source2.createGraphics();
        int x = (QRCODE_SIZE - width) / 2;
        int y = (QRCODE_SIZE - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        Shape shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        Graphics2D graphics2D = graph;
        Intrinsics.checkExpressionValueIsNotNull(graphics2D, "graph");
        graphics2D.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    private final void addFontImage(BufferedImage source2, String declareText) {
        int defineWidth = QRCODE_SIZE;
        int defineHeight = 20;
        BufferedImage textImage = new BufferedImage(defineWidth, defineHeight, 1);
        Graphics graphics = textImage.getGraphics();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, defineWidth, defineHeight);
        g2.setPaint(Color.BLACK);
        FontRenderContext context = g2.getFontRenderContext();
        Font font = new Font("\u5b8b\u4f53", 1, BOTTOM_TEXT_SIZE);
        g2.setFont(font);
        LineMetrics lineMetrics = font.getLineMetrics(declareText, context);
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(font);
        Intrinsics.checkExpressionValueIsNotNull(fontDesignMetrics, "FontDesignMetrics.getMetrics(font)");
        FontMetrics fontMetrics = fontDesignMetrics;
        float offset = (defineWidth - fontMetrics.stringWidth(declareText)) / 2;
        float f = defineHeight;
        LineMetrics lineMetrics2 = lineMetrics;
        Intrinsics.checkExpressionValueIsNotNull(lineMetrics2, "lineMetrics");
        float y = (f + lineMetrics2.getAscent() - lineMetrics.getDescent() - lineMetrics.getLeading()) / (float)2;
        g2.drawString(declareText, (int)offset, (int)y);
        Graphics2D graph = source2.createGraphics();
        graph.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int width = textImage.getWidth(null);
        int height = textImage.getHeight(null);
        Image src = textImage;
        graph.drawImage(src, 0, QRCODE_SIZE - 8, width, height, Color.WHITE, null);
        graph.dispose();
    }

    private QRCodeUtil() {
    }

    static {
        QRCodeUtil qRCodeUtil;
        INSTANCE = qRCodeUtil = new QRCodeUtil();
        QRCODE_SIZE = 320;
        LOGO_SIZE = 80;
        BOTTOM_TEXT_SIZE = 20;
        FORMAT_TYPE = "PNG";
    }
}

