/*
 * Decompiled with CFR 0.152.
 */
package com.starsone.controls.utils;

import java.io.File;
import java.nio.charset.Charset;
import javax.swing.filechooser.FileSystemView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/starsone/controls/utils/ShortCutUtils;", "", "()V", "desktop", "", "getDesktop", "()Ljava/lang/String;", "fileAttributes", "", "fixedValueOne", "fixedValueTwo", "headFile", "startup", "getStartup", "createShortCut", "", "lnkFile", "Ljava/io/File;", "targetFile", "lnkFilePath", "targetFilePath", "setAppStartup", "common-controls"})
public final class ShortCutUtils {
    @NotNull
    private static final String startup;
    @NotNull
    private static final String desktop;
    private static final byte[] headFile;
    private static final byte[] fileAttributes;
    private static final byte[] fixedValueOne;
    private static final byte[] fixedValueTwo;
    public static final ShortCutUtils INSTANCE;

    public final void createShortCut(@NotNull File lnkFile, @NotNull File targetFile) {
        String string2;
        Intrinsics.checkParameterIsNotNull(lnkFile, "lnkFile");
        Intrinsics.checkParameterIsNotNull(targetFile, "targetFile");
        String string3 = System.getProperties().getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull(string3, "System.getProperties().getProperty(\"os.name\")");
        String string4 = string2 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).toUpperCase()");
        if (!StringsKt.contains$default((CharSequence)string5, "WINDOWS", false, 2, null)) {
            string2 = "\u5f53\u524d\u7cfb\u7edf\u4e0d\u662fwindow\u7cfb\u7edf,\u65e0\u6cd5\u521b\u5efa\u5feb\u6377\u65b9\u5f0f!!";
            System.out.println((Object)string2);
            return;
        }
        String targetPath = targetFile.getPath();
        if (!lnkFile.getParentFile().exists()) {
            lnkFile.mkdirs();
        }
        if (lnkFile.exists()) {
            lnkFile.delete();
        }
        FilesKt.appendBytes(lnkFile, headFile);
        FilesKt.appendBytes(lnkFile, fileAttributes);
        FilesKt.appendBytes(lnkFile, fixedValueOne);
        String string6 = targetPath;
        Intrinsics.checkExpressionValueIsNotNull(string6, "targetPath");
        Object object = string6;
        File file = lnkFile;
        String string7 = object;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string7.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull(cArray, "(this as java.lang.String).toCharArray()");
        Object object2 = cArray;
        object = String.valueOf(object2[0]);
        Charset charset = Charsets.UTF_8;
        String string8 = object;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string8.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
        object2 = byArray;
        FilesKt.appendBytes(file, (byte[])object2);
        FilesKt.appendBytes(lnkFile, fixedValueTwo);
        object = targetPath;
        int n = 3;
        file = lnkFile;
        String string9 = ((String)object).substring(n);
        Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).substring(startIndex)");
        object2 = string9;
        object = object2;
        Object object3 = "gbk";
        Charset charset2 = Charset.forName((String)object3);
        Intrinsics.checkExpressionValueIsNotNull(charset2, "Charset.forName(charsetName)");
        object2 = charset2;
        object3 = object2;
        Object object4 = object;
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = ((String)object4).getBytes((Charset)object3);
        Intrinsics.checkExpressionValueIsNotNull(byArray2, "(this as java.lang.String).getBytes(charset)");
        object2 = byArray2;
        FilesKt.appendBytes(file, (byte[])object2);
    }

    public final void setAppStartup(@NotNull File targetFile) {
        Intrinsics.checkParameterIsNotNull(targetFile, "targetFile");
        File lnkFile = new File(targetFile.getParentFile(), "temp.lnk");
        this.createShortCut(lnkFile, targetFile);
        File startUpFile = new File(startup, FilesKt.getNameWithoutExtension(targetFile) + ".lnk");
        FilesKt.copyTo$default(lnkFile, startUpFile, true, 0, 4, null);
        lnkFile.delete();
    }

    public final void setAppStartup(@NotNull String targetFilePath) {
        Intrinsics.checkParameterIsNotNull(targetFilePath, "targetFilePath");
        this.setAppStartup(new File(targetFilePath));
    }

    public final void createShortCut(@NotNull String lnkFilePath, @NotNull String targetFilePath) {
        Intrinsics.checkParameterIsNotNull(lnkFilePath, "lnkFilePath");
        Intrinsics.checkParameterIsNotNull(targetFilePath, "targetFilePath");
        this.createShortCut(new File(lnkFilePath), new File(targetFilePath));
    }

    @NotNull
    public final String getStartup() {
        return startup;
    }

    @NotNull
    public final String getDesktop() {
        return desktop;
    }

    private ShortCutUtils() {
    }

    static {
        ShortCutUtils shortCutUtils;
        INSTANCE = shortCutUtils = new ShortCutUtils();
        startup = System.getProperty("user.home") + "\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\";
        StringBuilder stringBuilder = new StringBuilder();
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        Intrinsics.checkExpressionValueIsNotNull(fileSystemView, "FileSystemView.getFileSystemView()");
        File file = fileSystemView.getHomeDirectory();
        Intrinsics.checkExpressionValueIsNotNull(file, "FileSystemView.getFileSystemView().homeDirectory");
        desktop = stringBuilder.append(file.getAbsolutePath()).append("\\").toString();
        headFile = new byte[]{76, 0, 0, 0, 1, 20, 2, 0, 0, 0, 0, 0, (byte)192, 0, 0, 0, 0, 0, 0, 70};
        fileAttributes = new byte[]{(byte)147, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        fixedValueOne = new byte[]{(byte)131, 0, 20, 0, 31, 80, (byte)224, 79, (byte)208, 32, (byte)234, 58, 105, 16, (byte)162, (byte)216, 8, 0, 43, 48, 48, (byte)157, 25, 0, 47};
        fixedValueTwo = new byte[]{58, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 0, 50, 0, 4, 0, 0, 0, 103, 80, (byte)145, 60, 32, 0};
    }
}

