/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class MutablePair<L, R>
extends Pair<L, R> {
    public static final MutablePair<?, ?>[] EMPTY_ARRAY = new MutablePair[0];
    private static final long serialVersionUID = 4954918890077093841L;
    public L left;
    public R right;

    public static <L, R> MutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> MutablePair<L, R> of(L left2, R right2) {
        return new MutablePair<L, R>(left2, right2);
    }

    public static <L, R> MutablePair<L, R> of(Map.Entry<L, R> pair) {
        R right2;
        L left2;
        if (pair != null) {
            left2 = pair.getKey();
            right2 = pair.getValue();
        } else {
            left2 = null;
            right2 = null;
        }
        return new MutablePair<Object, Object>(left2, right2);
    }

    public MutablePair() {
    }

    public MutablePair(L left2, R right2) {
        this.left = left2;
        this.right = right2;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    public void setLeft(L left2) {
        this.left = left2;
    }

    public void setRight(R right2) {
        this.right = right2;
    }

    @Override
    public R setValue(R value) {
        R result2 = this.getRight();
        this.setRight(value);
        return result2;
    }
}

