/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.text.lookup.StringLookup;

@Deprecated
public abstract class StrLookup<V>
implements StringLookup {
    private static final StrLookup<String> NONE_LOOKUP = new MapStrLookup<String>(null);
    private static final StrLookup<String> SYSTEM_PROPERTIES_LOOKUP = new SystemPropertiesStrLookup();

    public static StrLookup<?> noneLookup() {
        return NONE_LOOKUP;
    }

    public static StrLookup<String> systemPropertiesLookup() {
        return SYSTEM_PROPERTIES_LOOKUP;
    }

    public static <V> StrLookup<V> mapLookup(Map<String, V> map2) {
        return new MapStrLookup<V>(map2);
    }

    public static StrLookup<String> resourceBundleLookup(ResourceBundle resourceBundle) {
        return new ResourceBundleLookup(resourceBundle);
    }

    protected StrLookup() {
    }

    private static final class SystemPropertiesStrLookup
    extends StrLookup<String> {
        private SystemPropertiesStrLookup() {
        }

        @Override
        public String lookup(String key2) {
            if (key2.length() > 0) {
                try {
                    return System.getProperty(key2);
                }
                catch (SecurityException scex) {
                    return null;
                }
            }
            return null;
        }
    }

    private static final class ResourceBundleLookup
    extends StrLookup<String> {
        private final ResourceBundle resourceBundle;

        private ResourceBundleLookup(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        @Override
        public String lookup(String key2) {
            if (this.resourceBundle == null || key2 == null || !this.resourceBundle.containsKey(key2)) {
                return null;
            }
            return this.resourceBundle.getString(key2);
        }

        public String toString() {
            return super.toString() + " [resourceBundle=" + this.resourceBundle + "]";
        }
    }

    static class MapStrLookup<V>
    extends StrLookup<V> {
        private final Map<String, V> map;

        MapStrLookup(Map<String, V> map2) {
            this.map = map2;
        }

        @Override
        public String lookup(String key2) {
            if (this.map == null) {
                return null;
            }
            V obj = this.map.get(key2);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }

        public String toString() {
            return super.toString() + " [map=" + this.map + "]";
        }
    }
}

