/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.lookup.AbstractStringLookup;

final class FunctionStringLookup<V>
extends AbstractStringLookup {
    private final Function<String, V> function;

    static <R> FunctionStringLookup<R> on(Function<String, R> function) {
        return new FunctionStringLookup<R>(function);
    }

    static <V> FunctionStringLookup<V> on(Map<String, V> map2) {
        return FunctionStringLookup.on(map2::get);
    }

    private FunctionStringLookup(Function<String, V> function) {
        this.function = function;
    }

    @Override
    public String lookup(String key2) {
        V obj;
        if (this.function == null) {
            return null;
        }
        try {
            obj = this.function.apply(key2);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e) {
            return null;
        }
        return Objects.toString(obj, null);
    }

    public String toString() {
        return super.toString() + " [function=" + this.function + "]";
    }
}

