/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;

final class PropertiesStringLookup
extends AbstractStringLookup {
    static final PropertiesStringLookup INSTANCE = new PropertiesStringLookup();
    static final String SEPARATOR = "::";

    static String toPropertyKey(String file, String key2) {
        return AbstractStringLookup.toLookupKey(file, SEPARATOR, key2);
    }

    private PropertiesStringLookup() {
    }

    @Override
    public String lookup(String key2) {
        if (key2 == null) {
            return null;
        }
        String[] keys2 = key2.split(SEPARATOR);
        int keyLen = keys2.length;
        if (keyLen < 2) {
            throw IllegalArgumentExceptions.format("Bad properties key format [%s]; expected format is %s.", key2, PropertiesStringLookup.toPropertyKey("DocumentPath", "Key"));
        }
        String documentPath = keys2[0];
        String propertyKey = StringUtils.substringAfter(key2, SEPARATOR);
        try {
            Properties properties2 = new Properties();
            try (InputStream inputStream2 = Files.newInputStream(Paths.get(documentPath, new String[0]), new OpenOption[0]);){
                properties2.load(inputStream2);
            }
            return properties2.getProperty(propertyKey);
        }
        catch (Exception e) {
            throw IllegalArgumentExceptions.format(e, "Error looking up properties [%s] and key [%s].", documentPath, propertyKey);
        }
    }
}

