/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.text.similarity.IntersectionResult;
import org.apache.commons.text.similarity.SimilarityScore;

public class IntersectionSimilarity<T>
implements SimilarityScore<IntersectionResult> {
    private final Function<CharSequence, Collection<T>> converter;

    public IntersectionSimilarity(Function<CharSequence, Collection<T>> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Converter must not be null");
        }
        this.converter = converter;
    }

    @Override
    public IntersectionResult apply(CharSequence left2, CharSequence right2) {
        int intersection;
        int sizeB;
        if (left2 == null || right2 == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        Collection<T> objectsA = this.converter.apply(left2);
        Collection<T> objectsB = this.converter.apply(right2);
        int sizeA = objectsA.size();
        if (Math.min(sizeA, sizeB = objectsB.size()) == 0) {
            return new IntersectionResult(sizeA, sizeB, 0);
        }
        if (objectsA instanceof Set && objectsB instanceof Set) {
            intersection = sizeA < sizeB ? IntersectionSimilarity.getIntersection((Set)objectsA, (Set)objectsB) : IntersectionSimilarity.getIntersection((Set)objectsB, (Set)objectsA);
        } else {
            TinyBag bagA = this.toBag(objectsA);
            TinyBag bagB = this.toBag(objectsB);
            intersection = bagA.uniqueElementSize() < bagB.uniqueElementSize() ? this.getIntersection(bagA, bagB) : this.getIntersection(bagB, bagA);
        }
        return new IntersectionResult(sizeA, sizeB, intersection);
    }

    private TinyBag toBag(Collection<T> objects) {
        TinyBag bag = new TinyBag(objects.size());
        for (T t : objects) {
            bag.add(t);
        }
        return bag;
    }

    private static <T> int getIntersection(Set<T> setA, Set<T> setB) {
        int intersection = 0;
        for (T element : setA) {
            if (!setB.contains(element)) continue;
            ++intersection;
        }
        return intersection;
    }

    private int getIntersection(TinyBag bagA, TinyBag bagB) {
        int intersection = 0;
        for (Map.Entry entry : bagA.entrySet()) {
            Object element = entry.getKey();
            int count = entry.getValue().count;
            intersection += Math.min(count, bagB.getCount(element));
        }
        return intersection;
    }

    private class TinyBag {
        private final Map<T, BagCount> map;

        TinyBag(int initialCapacity) {
            this.map = new HashMap(initialCapacity);
        }

        void add(T object) {
            BagCount mut = this.map.get(object);
            if (mut == null) {
                this.map.put(object, new BagCount());
            } else {
                ++mut.count;
            }
        }

        int getCount(Object object) {
            BagCount count = this.map.get(object);
            if (count != null) {
                return count.count;
            }
            return 0;
        }

        Set<Map.Entry<T, BagCount>> entrySet() {
            return this.map.entrySet();
        }

        int uniqueElementSize() {
            return this.map.size();
        }
    }

    private static class BagCount {
        int count = 1;

        private BagCount() {
        }
    }
}

