/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance DEFAULT_INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left2, CharSequence right2) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(left2, right2, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(left2, right2);
    }

    public static LevenshteinDistance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    private static int limitedCompare(CharSequence left2, CharSequence right2, int threshold) {
        if (left2 == null || right2 == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n = left2.length();
        int m = right2.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n > m) {
            CharSequence tmp = left2;
            left2 = right2;
            right2 = tmp;
            n = m;
            m = right2.length();
        }
        if (m - n > threshold) {
            return -1;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i2 = 0; i2 < boundary; ++i2) {
            p[i2] = i2;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max;
            char rightJ = right2.charAt(j - 1);
            d[0] = j;
            int min = Math.max(1, j - threshold);
            int n2 = max = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            for (int i3 = min; i3 <= max; ++i3) {
                d[i3] = left2.charAt(i3 - 1) == rightJ ? p[i3 - 1] : 1 + Math.min(Math.min(d[i3 - 1], p[i3]), p[i3 - 1]);
            }
            int[] tempD = p;
            p = d;
            d = tempD;
        }
        if (p[n] <= threshold) {
            return p[n];
        }
        return -1;
    }

    private static int unlimitedCompare(CharSequence left2, CharSequence right2) {
        int i2;
        if (left2 == null || right2 == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n = left2.length();
        int m = right2.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = left2;
            left2 = right2;
            right2 = tmp;
            n = m;
            m = right2.length();
        }
        int[] p = new int[n + 1];
        for (i2 = 0; i2 <= n; ++i2) {
            p[i2] = i2;
        }
        for (int j = 1; j <= m; ++j) {
            int upperLeft = p[0];
            char rightJ = right2.charAt(j - 1);
            p[0] = j;
            for (i2 = 1; i2 <= n; ++i2) {
                int upper = p[i2];
                int cost = left2.charAt(i2 - 1) == rightJ ? 0 : 1;
                p[i2] = Math.min(Math.min(p[i2 - 1] + 1, p[i2] + 1), upperLeft + cost);
                upperLeft = upper;
            }
        }
        return p[n];
    }
}

