/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.bnf.context.DbSchema;
import org.h2.jdbc.JdbcConnection;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbContents {
    private DbSchema[] schemas;
    private DbSchema defaultSchema;
    private boolean isOracle;
    private boolean isH2;
    private boolean isPostgreSQL;
    private boolean isDerby;
    private boolean isSQLite;
    private boolean isMySQL;
    private boolean isFirebird;
    private boolean isMSSQLServer;
    private boolean isDB2;
    private boolean databaseToUpper;
    private boolean databaseToLower;

    public DbSchema getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public boolean isFirebird() {
        return this.isFirebird;
    }

    public boolean isH2() {
        return this.isH2;
    }

    public boolean isMSSQLServer() {
        return this.isMSSQLServer;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    public boolean isSQLite() {
        return this.isSQLite;
    }

    public boolean isDB2() {
        return this.isDB2;
    }

    public DbSchema[] getSchemas() {
        return this.schemas;
    }

    public synchronized void readContents(String string2, Connection connection) throws SQLException {
        Object object;
        this.isH2 = string2.startsWith("jdbc:h2:");
        this.isDB2 = string2.startsWith("jdbc:db2:");
        this.isSQLite = string2.startsWith("jdbc:sqlite:");
        this.isOracle = string2.startsWith("jdbc:oracle:");
        this.isPostgreSQL = string2.startsWith("jdbc:postgresql:") || string2.startsWith("jdbc:vertica:");
        this.isMySQL = string2.startsWith("jdbc:mysql:");
        this.isDerby = string2.startsWith("jdbc:derby:");
        this.isFirebird = string2.startsWith("jdbc:firebirdsql:");
        this.isMSSQLServer = string2.startsWith("jdbc:sqlserver:");
        if (this.isH2) {
            object = ((JdbcConnection)connection).getSettings();
            this.databaseToUpper = ((JdbcConnection.Settings)object).databaseToUpper;
            this.databaseToLower = ((JdbcConnection.Settings)object).databaseToLower;
        } else if (this.isMySQL || this.isPostgreSQL) {
            this.databaseToUpper = false;
            this.databaseToLower = true;
        } else {
            this.databaseToUpper = true;
            this.databaseToLower = false;
        }
        object = connection.getMetaData();
        String string3 = this.getDefaultSchemaName((DatabaseMetaData)object);
        String[] stringArray = this.getSchemaNames((DatabaseMetaData)object);
        this.schemas = new DbSchema[stringArray.length];
        for (int j = 0; j < stringArray.length; ++j) {
            DbSchema[] dbSchemaArray = stringArray[j];
            int n = string3 == null || string3.equals(dbSchemaArray) ? 1 : 0;
            DbSchema dbSchema = new DbSchema(this, (String)dbSchemaArray, n != 0);
            if (n != 0) {
                this.defaultSchema = dbSchema;
            }
            this.schemas[j] = dbSchema;
            String[] stringArray2 = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM", "EXTERNAL"};
            dbSchema.readTables((DatabaseMetaData)object, stringArray2);
            if (this.isPostgreSQL || this.isDB2) continue;
            dbSchema.readProcedures((DatabaseMetaData)object);
        }
        if (this.defaultSchema == null) {
            String string4 = null;
            for (DbSchema dbSchema : this.schemas) {
                if ("dbo".equals(dbSchema.name)) {
                    this.defaultSchema = dbSchema;
                    break;
                }
                if (this.defaultSchema != null && string4 != null && dbSchema.name.length() >= string4.length()) continue;
                string4 = dbSchema.name;
                this.defaultSchema = dbSchema;
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        if (this.isMySQL || this.isSQLite) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        ArrayList<String> arrayList = Utils.newSmallArrayList();
        while (resultSet.next()) {
            String string2 = resultSet.getString("TABLE_SCHEM");
            String[] stringArray = null;
            if (this.isOracle) {
                stringArray = new String[]{"CTXSYS", "DIP", "DBSNMP", "DMSYS", "EXFSYS", "FLOWS_020100", "FLOWS_FILES", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORDSYS", "ORDPLUGINS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WMSYS", "XDB"};
            } else if (this.isMSSQLServer) {
                stringArray = new String[]{"sys", "db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin"};
            } else if (this.isDB2) {
                stringArray = new String[]{"NULLID", "SYSFUN", "SYSIBMINTERNAL", "SYSIBMTS", "SYSPROC", "SYSPUBLIC", "SYSCAT", "SYSIBM", "SYSIBMADM", "SYSSTAT", "SYSTOOLS"};
            }
            if (stringArray != null) {
                for (void var9_9 : stringArray) {
                    if (!var9_9.equals(string2)) continue;
                    string2 = null;
                    break;
                }
            }
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        resultSet.close();
        return arrayList.toArray(new String[0]);
    }

    private String getDefaultSchemaName(DatabaseMetaData databaseMetaData) {
        String string2 = "";
        try {
            if (this.isOracle) {
                return databaseMetaData.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(databaseMetaData.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            int n = resultSet.findColumn("IS_DEFAULT");
            while (resultSet.next()) {
                if (!resultSet.getBoolean(n)) continue;
                string2 = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string2;
    }

    public String quoteIdentifier(String string2) {
        if (string2 == null) {
            return null;
        }
        if (ParserUtil.isSimpleIdentifier(string2, this.databaseToUpper, this.databaseToLower)) {
            return string2;
        }
        return StringUtils.quoteIdentifier(string2);
    }
}

