/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbSettings;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    static void clearCTE(Session session, Prepared prepared) {
        List<TableView> list2 = prepared.getCteCleanups();
        if (list2 != null) {
            CommandContainer.clearCTE(session, list2);
        }
    }

    static void clearCTE(Session session, List<TableView> list2) {
        for (TableView tableView : list2) {
            if (tableView.getName() == null) continue;
            session.removeLocalTempTable(tableView);
        }
    }

    CommandContainer(Session session, String string2, Prepared prepared) {
        super(session, string2);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    @Override
    public void prepareJoinBatch() {
        if (this.session.isJoinBatchEnabled()) {
            CommandContainer.prepareJoinBatch(this.prepared);
        }
    }

    private static void prepareJoinBatch(Prepared prepared) {
        if (prepared.isQuery()) {
            int n = prepared.getType();
            if (n == 66) {
                ((Query)prepared).prepareJoinBatch();
            } else if (n == 60 || n == 86) {
                CommandContainer.prepareJoinBatch(((Explain)prepared).getCommand());
            }
        }
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string2 = this.prepared.getSQL();
            ArrayList<Parameter> arrayList = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(string2);
            long l = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> arrayList2 = this.prepared.getParameters();
            int n = arrayList2.size();
            for (int j = 0; j < n; ++j) {
                Parameter parameter = arrayList.get(j);
                if (!parameter.isValueSet()) continue;
                Value value = parameter.getValue(this.session);
                Parameter parameter2 = arrayList2.get(j);
                parameter2.setValue(value);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l);
            this.prepareJoinBatch();
        }
    }

    @Override
    public ResultWithGeneratedKeys update(Object object) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.session.setLastScopeIdentity(ValueNull.INSTANCE);
        this.prepared.checkParameters();
        ResultWithGeneratedKeys resultWithGeneratedKeys = object != null && !Boolean.FALSE.equals(object) ? (this.prepared instanceof DataChangeStatement && this.prepared.getType() != 58 ? this.executeUpdateWithGeneratedKeys((DataChangeStatement)((Object)this.prepared), object) : new ResultWithGeneratedKeys.WithKeys(this.prepared.update(), this.session.getDatabase().getResultFactory().create())) : ResultWithGeneratedKeys.of(this.prepared.update());
        this.prepared.trace(this.startTimeNanos, resultWithGeneratedKeys.getUpdateCount());
        this.setProgress(6);
        return resultWithGeneratedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ResultWithGeneratedKeys executeUpdateWithGeneratedKeys(DataChangeStatement dataChangeStatement, Object object) {
        int n;
        void var9_18;
        int n2;
        Object[] objectArray;
        Object[] objectArray2;
        ArrayList<Object> arrayList;
        Database database = this.session.getDatabase();
        Table table = dataChangeStatement.getTable();
        if (Boolean.TRUE.equals(object)) {
            arrayList = Utils.newSmallArrayList();
            objectArray2 = table.getColumns();
            objectArray = table.findPrimaryKey();
            for (Column column2 : objectArray2) {
                Expression expression = column2.getDefaultExpression();
                if ((expression == null || expression.isConstant()) && (objectArray == null || objectArray.getColumnIndex(column2) < 0)) continue;
                arrayList.add(new ExpressionColumn(database, column2));
            }
        } else if (object instanceof int[]) {
            objectArray2 = (int[])object;
            objectArray = table.getColumns();
            int n3 = objectArray.length;
            arrayList = new ArrayList(objectArray2.length);
            for (Column column3 : objectArray2) {
                if (column3 < true || column3 > n3) {
                    throw DbException.get(42122, "Index: " + (int)column3);
                }
                arrayList.add(new ExpressionColumn(database, (Column)objectArray[column3 - true]));
            }
        } else if (object instanceof String[]) {
            void var9_16;
            objectArray2 = (String[])object;
            arrayList = new ArrayList(objectArray2.length);
            objectArray = objectArray2;
            int n3 = objectArray.length;
            boolean localResult = false;
            while (var9_16 < n3) {
                Column column4;
                block21: {
                    Column column5 = objectArray[var9_16];
                    column4 = table.findColumn((String)((Object)column5));
                    if (column4 == null) {
                        DbSettings dbSettings = database.getSettings();
                        if (dbSettings.databaseToUpper) {
                            column4 = table.findColumn(StringUtils.toUpperEnglish((String)((Object)column5)));
                        } else if (dbSettings.databaseToLower) {
                            column4 = table.findColumn(StringUtils.toLowerEnglish((String)((Object)column5)));
                        }
                        if (column4 == null) {
                            for (Column column6 : table.getColumns()) {
                                if (!column6.getName().equalsIgnoreCase((String)((Object)column5))) continue;
                                column4 = column6;
                                break block21;
                            }
                            throw DbException.get(42122, (String)((Object)column5));
                        }
                    }
                }
                arrayList.add(new ExpressionColumn(database, column4));
                ++var9_16;
            }
        } else {
            throw DbException.throwInternalError();
        }
        if ((n2 = arrayList.size()) == 0) {
            return new ResultWithGeneratedKeys.WithKeys(dataChangeStatement.update(), database.getResultFactory().create());
        }
        objectArray = new int[n2];
        Expression[] expressionArray = arrayList.toArray(new ExpressionColumn[0]);
        boolean bl = false;
        while (var9_18 < n2) {
            objectArray[var9_18] = expressionArray[var9_18].getColumn().getColumnId();
            ++var9_18;
        }
        LocalResult localResult = database.getResultFactory().create(this.session, expressionArray, n2, n2);
        GeneratedKeysCollector generatedKeysCollector = new GeneratedKeysCollector((int[])objectArray, localResult);
        try {
            dataChangeStatement.setDeltaChangeCollector(generatedKeysCollector, DataChangeDeltaTable.ResultOption.FINAL);
            n = dataChangeStatement.update();
        }
        finally {
            dataChangeStatement.setDeltaChangeCollector(null, null);
        }
        return new ResultWithGeneratedKeys.WithKeys(n, localResult);
    }

    @Override
    public ResultInterface query(int n) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface resultInterface = this.prepared.query(n);
        this.prepared.trace(this.startTimeNanos, resultInterface.isLazy() ? 0 : resultInterface.getRowCount());
        this.setProgress(6);
        return resultInterface;
    }

    @Override
    public void stop() {
        super.stop();
        CommandContainer.clearCTE(this.session, this.prepared);
    }

    @Override
    public boolean canReuse() {
        return super.canReuse() && this.prepared.getCteCleanups() == null;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }

    void clearCTE() {
        CommandContainer.clearCTE(this.session, this.prepared);
    }

    @Override
    public Set<DbObject> getDependencies() {
        HashSet<DbObject> hashSet = new HashSet<DbObject>();
        this.prepared.collectDependencies(hashSet);
        return hashSet;
    }

    private static final class GeneratedKeysCollector
    implements ResultTarget {
        private final int[] indexes;
        private final LocalResult result;

        GeneratedKeysCollector(int[] nArray, LocalResult localResult) {
            this.indexes = nArray;
            this.result = localResult;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public void addRow(Value ... valueArray) {
            int n = this.indexes.length;
            Value[] valueArray2 = new Value[n];
            for (int j = 0; j < n; ++j) {
                valueArray2[j] = valueArray[this.indexes[j]];
            }
            this.result.addRow(valueArray2);
        }
    }
}

