/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private boolean ifExists;
    private Table table;
    private String sequenceName;
    private Sequence sequence;
    private SequenceOptions options;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setSequenceName(String string2) {
        this.sequenceName = string2;
    }

    public void setOptions(SequenceOptions sequenceOptions) {
        this.options = sequenceOptions;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column2) {
        this.table = column2.getTable();
        this.sequence = column2.getSequence();
        if (this.sequence == null && !this.ifExists) {
            throw DbException.get(90036, column2.getSQL(false));
        }
    }

    @Override
    public int update() {
        Long l;
        Boolean bl;
        if (this.sequence == null) {
            this.sequence = this.getSchema().findSequence(this.sequenceName);
            if (this.sequence == null) {
                if (!this.ifExists) {
                    throw DbException.get(90036, this.sequenceName);
                }
                return 0;
            }
        }
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if ((bl = this.options.getCycle()) != null) {
            this.sequence.setCycle(bl);
        }
        if ((l = this.options.getCacheSize(this.session)) != null) {
            this.sequence.setCacheSize(l);
        }
        if (this.options.isRangeSet()) {
            this.sequence.modify(this.options.getStartValue(this.session), this.options.getMinValue(this.sequence, this.session), this.options.getMaxValue(this.sequence, this.session), this.options.getIncrement(this.session));
        }
        this.sequence.flush(this.session);
        return 0;
    }

    @Override
    public int getType() {
        return 54;
    }
}

