/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.Database;
import org.h2.engine.Domain;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.Table;

public class DropDomain
extends DefineCommand {
    private String typeName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropDomain(Session session) {
        super(session);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Domain domain = database.findDomain(this.typeName);
        if (domain == null) {
            if (!this.ifExists) {
                throw DbException.get(90120, this.typeName);
            }
        } else {
            for (Table table : database.getAllTablesAndViews(false)) {
                boolean bl = false;
                for (Column column2 : table.getColumns()) {
                    Domain domain2 = column2.getDomain();
                    if (domain2 == null || !domain2.getName().equals(this.typeName)) continue;
                    if (this.dropAction == ConstraintActionType.RESTRICT) {
                        throw DbException.get(90107, this.typeName, table.getCreateSQL());
                    }
                    column2.setOriginalSQL(domain.getColumn().getOriginalSQL());
                    column2.setDomain(null);
                    bl = true;
                }
                if (!bl) continue;
                database.updateMeta(this.session, table);
            }
            database.removeDatabaseObject(this.session, domain);
        }
        return 0;
    }

    public void setTypeName(String string2) {
        this.typeName = string2;
    }

    @Override
    public int getType() {
        return 47;
    }
}

