/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.dml.Select;
import org.h2.engine.Database;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.ColumnNamer;
import org.h2.value.Value;

public class SelectListColumnResolver
implements ColumnResolver {
    private final Select select;
    private final Expression[] expressions;
    private final Column[] columns;

    SelectListColumnResolver(Select select2) {
        this.select = select2;
        int n = select2.getColumnCount();
        this.columns = new Column[n];
        this.expressions = new Expression[n];
        ArrayList<Expression> arrayList = select2.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(select2.getSession());
        for (int j = 0; j < n; ++j) {
            Expression expression = arrayList.get(j);
            String string2 = columnNamer.getColumnName(expression, j, expression.getAlias());
            Column column2 = new Column(string2, 0);
            column2.setTable(null, j);
            this.columns[j] = column2;
            this.expressions[j] = expression.getNonAliasExpression();
        }
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public Column findColumn(String string2) {
        Database database = this.select.getSession().getDatabase();
        for (Column column2 : this.columns) {
            if (!database.equalsIdentifiers(column2.getName(), string2)) continue;
            return column2;
        }
        return null;
    }

    @Override
    public String getColumnName(Column column2) {
        return column2.getName();
    }

    @Override
    public boolean hasDerivedColumnList() {
        return false;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public Select getSelect() {
        return this.select;
    }

    @Override
    public Column[] getSystemColumns() {
        return null;
    }

    @Override
    public Column getRowIdColumn() {
        return null;
    }

    @Override
    public String getTableAlias() {
        return null;
    }

    @Override
    public TableFilter getTableFilter() {
        return null;
    }

    @Override
    public Value getValue(Column column2) {
        return null;
    }

    @Override
    public Expression optimize(ExpressionColumn expressionColumn, Column column2) {
        return this.expressions[column2.getColumnId()];
    }
}

