/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.api.DatabaseEventListener;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.CommandInterface;
import org.h2.command.CommandRemote;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.IsolationLevel;
import org.h2.engine.SessionFactory;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionWithState;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcException;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.ResultInterface;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.LobStorageFrontend;
import org.h2.store.LobStorageInterface;
import org.h2.store.fs.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class SessionRemote
extends SessionWithState
implements DataHandler {
    public static final int SESSION_PREPARE = 0;
    public static final int SESSION_CLOSE = 1;
    public static final int COMMAND_EXECUTE_QUERY = 2;
    public static final int COMMAND_EXECUTE_UPDATE = 3;
    public static final int COMMAND_CLOSE = 4;
    public static final int RESULT_FETCH_ROWS = 5;
    public static final int RESULT_RESET = 6;
    public static final int RESULT_CLOSE = 7;
    public static final int COMMAND_COMMIT = 8;
    public static final int CHANGE_ID = 9;
    public static final int COMMAND_GET_META_DATA = 10;
    public static final int SESSION_PREPARE_READ_PARAMS = 11;
    public static final int SESSION_SET_ID = 12;
    public static final int SESSION_CANCEL_STATEMENT = 13;
    public static final int SESSION_CHECK_KEY = 14;
    public static final int SESSION_SET_AUTOCOMMIT = 15;
    public static final int SESSION_HAS_PENDING_TRANSACTION = 16;
    public static final int LOB_READ = 17;
    public static final int SESSION_PREPARE_READ_PARAMS2 = 18;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLOSED = 2;
    public static final int STATUS_OK_STATE_CHANGED = 3;
    private static SessionFactory sessionFactory;
    private TraceSystem traceSystem;
    private Trace trace;
    private ArrayList<Transfer> transferList = Utils.newSmallArrayList();
    private int nextId;
    private boolean autoCommit = true;
    private ConnectionInfo connectionInfo;
    private String databaseName;
    private String cipher;
    private byte[] fileEncryptionKey;
    private final Object lobSyncObject = new Object();
    private String sessionId;
    private int clientVersion;
    private boolean autoReconnect;
    private int lastReconnect;
    private SessionInterface embedded;
    private DatabaseEventListener eventListener;
    private LobStorageFrontend lobStorage;
    private boolean cluster;
    private TempFileDeleter tempFileDeleter;
    private JavaObjectSerializer javaObjectSerializer;
    private volatile boolean javaObjectSerializerInitialized;
    private final CompareMode compareMode = CompareMode.getInstance(null, 0);
    private String currentSchemaName;

    public SessionRemote(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    @Override
    public ArrayList<String> getClusterServers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Transfer transfer : this.transferList) {
            arrayList.add(transfer.getSocket().getInetAddress().getHostAddress() + ":" + transfer.getSocket().getPort());
        }
        return arrayList;
    }

    private Transfer initTransfer(ConnectionInfo connectionInfo, String string2, String string3) throws IOException {
        Socket socket = NetUtils.createSocket(string3, 9092, connectionInfo.isSSL());
        Transfer transfer = new Transfer(this, socket);
        transfer.setSSL(connectionInfo.isSSL());
        transfer.init();
        transfer.writeInt(9);
        transfer.writeInt(19);
        transfer.writeString(string2);
        transfer.writeString(connectionInfo.getOriginalURL());
        transfer.writeString(connectionInfo.getUserName());
        transfer.writeBytes(connectionInfo.getUserPasswordHash());
        transfer.writeBytes(connectionInfo.getFilePasswordHash());
        String[] stringArray = connectionInfo.getKeys();
        transfer.writeInt(stringArray.length);
        for (String string4 : stringArray) {
            transfer.writeString(string4).writeString(connectionInfo.getProperty(string4));
        }
        try {
            this.done(transfer);
            this.clientVersion = transfer.readInt();
            transfer.setVersion(this.clientVersion);
            if (this.clientVersion >= 14 && connectionInfo.getFileEncryptionKey() != null) {
                transfer.writeBytes(connectionInfo.getFileEncryptionKey());
            }
            transfer.writeInt(12);
            transfer.writeString(this.sessionId);
            this.done(transfer);
            this.autoCommit = this.clientVersion >= 15 ? transfer.readBoolean() : true;
            return transfer;
        }
        catch (DbException dbException) {
            transfer.close();
            throw dbException;
        }
    }

    @Override
    public boolean hasPendingTransaction() {
        if (this.clientVersion < 10) {
            return true;
        }
        int n = 0;
        for (int j = 0; j < this.transferList.size(); ++j) {
            Transfer transfer = this.transferList.get(j);
            try {
                this.traceOperation("SESSION_HAS_PENDING_TRANSACTION", 0);
                transfer.writeInt(16);
                this.done(transfer);
                return transfer.readInt() != 0;
            }
            catch (IOException iOException) {
                this.removeServer(iOException, j--, ++n);
                continue;
            }
        }
        return true;
    }

    @Override
    public void cancel() {
    }

    public void cancelStatement(int n) {
        for (Transfer transfer : this.transferList) {
            try {
                Transfer transfer2 = transfer.openNewConnection();
                transfer2.init();
                transfer2.writeInt(this.clientVersion);
                transfer2.writeInt(this.clientVersion);
                transfer2.writeString(null);
                transfer2.writeString(null);
                transfer2.writeString(this.sessionId);
                transfer2.writeInt(13);
                transfer2.writeInt(n);
                transfer2.close();
            }
            catch (IOException iOException) {
                this.trace.debug(iOException, "could not cancel statement");
            }
        }
    }

    private void checkClusterDisableAutoCommit(String string2) {
        if (this.autoCommit && this.transferList.size() > 1) {
            this.setAutoCommitSend(false);
            CommandInterface commandInterface = this.prepareCommand("SET CLUSTER " + string2, Integer.MAX_VALUE);
            commandInterface.executeUpdate(null);
            this.autoCommit = true;
            this.cluster = true;
        }
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean bl) {
        if (!this.cluster) {
            this.setAutoCommitSend(bl);
        }
        this.autoCommit = bl;
    }

    public void setAutoCommitFromServer(boolean bl) {
        if (this.cluster) {
            if (bl) {
                this.setAutoCommitSend(false);
                this.autoCommit = true;
            }
        } else {
            this.autoCommit = bl;
        }
    }

    private synchronized void setAutoCommitSend(boolean bl) {
        int n = 0;
        for (int j = 0; j < this.transferList.size(); ++j) {
            Transfer transfer = this.transferList.get(j);
            try {
                this.traceOperation("SESSION_SET_AUTOCOMMIT", bl ? 1 : 0);
                transfer.writeInt(15).writeBoolean(bl);
                this.done(transfer);
                continue;
            }
            catch (IOException iOException) {
                this.removeServer(iOException, j--, ++n);
            }
        }
    }

    public void autoCommitIfCluster() {
        if (this.autoCommit && this.cluster) {
            int n = 0;
            for (int j = 0; j < this.transferList.size(); ++j) {
                Transfer transfer = this.transferList.get(j);
                try {
                    this.traceOperation("COMMAND_COMMIT", 0);
                    transfer.writeInt(8);
                    this.done(transfer);
                    continue;
                }
                catch (IOException iOException) {
                    this.removeServer(iOException, j--, ++n);
                }
            }
        }
    }

    private String getFilePrefix(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append('/');
        for (int j = 0; j < this.databaseName.length(); ++j) {
            char c = this.databaseName.charAt(j);
            if (Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    @Override
    public int getPowerOffCount() {
        return 0;
    }

    @Override
    public void setPowerOffCount(int n) {
        throw DbException.getUnsupportedException("remote");
    }

    public SessionInterface connectEmbeddedOrServer(boolean bl) {
        ConnectionInfo connectionInfo = this.connectionInfo;
        if (connectionInfo.isRemote()) {
            this.connectServer(connectionInfo);
            return this;
        }
        boolean bl2 = connectionInfo.getProperty("AUTO_SERVER", false);
        ConnectionInfo connectionInfo2 = null;
        try {
            if (bl2) {
                connectionInfo2 = connectionInfo.clone();
                this.connectionInfo = connectionInfo.clone();
            }
            if (bl) {
                connectionInfo.setProperty("OPEN_NEW", "true");
            }
            if (sessionFactory == null) {
                sessionFactory = (SessionFactory)Class.forName("org.h2.engine.Engine").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            return sessionFactory.createSession(connectionInfo);
        }
        catch (Exception exception) {
            String string2;
            DbException dbException = DbException.convert(exception);
            if (dbException.getErrorCode() == 90020 && bl2 && (string2 = ((JdbcException)((Object)dbException.getSQLException())).getSQL()) != null) {
                connectionInfo2.setServerKey(string2);
                connectionInfo2.removeProperty("OPEN_NEW", null);
                this.connectServer(connectionInfo2);
                return this;
            }
            throw dbException;
        }
    }

    private void connectServer(ConnectionInfo connectionInfo) {
        String[] stringArray;
        String string2;
        int n;
        String string3 = connectionInfo.getName();
        if (string3.startsWith("//")) {
            string3 = string3.substring("//".length());
        }
        if ((n = string3.indexOf(47)) < 0) {
            throw connectionInfo.getFormatException();
        }
        this.databaseName = string3.substring(n + 1);
        String string4 = string3.substring(0, n);
        this.traceSystem = new TraceSystem(null);
        String string5 = connectionInfo.getProperty(10, null);
        if (string5 != null) {
            int n2 = Integer.parseInt(string5);
            String string6 = this.getFilePrefix(SysProperties.CLIENT_TRACE_DIRECTORY);
            try {
                this.traceSystem.setLevelFile(n2);
                if (n2 > 0 && n2 < 4) {
                    String string7 = FileUtils.createTempFile(string6, ".trace.db", false);
                    this.traceSystem.setFileName(string7);
                }
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, string6);
            }
        }
        if ((string2 = connectionInfo.getProperty(9, null)) != null) {
            int n3 = Integer.parseInt(string2);
            this.traceSystem.setLevelSystemOut(n3);
        }
        this.trace = this.traceSystem.getTrace(6);
        String string8 = null;
        if (string4.indexOf(44) >= 0) {
            string8 = StringUtils.quoteStringSQL(string4);
            connectionInfo.setProperty("CLUSTER", "TRUE");
        }
        this.autoReconnect = connectionInfo.getProperty("AUTO_RECONNECT", false);
        boolean bl = connectionInfo.getProperty("AUTO_SERVER", false);
        if (bl && string8 != null) {
            throw DbException.getUnsupportedException("autoServer && serverList != null");
        }
        this.autoReconnect |= bl;
        if (this.autoReconnect && (stringArray = connectionInfo.getProperty("DATABASE_EVENT_LISTENER")) != null) {
            stringArray = StringUtils.trim((String)stringArray, true, true, "'");
            try {
                this.eventListener = (DatabaseEventListener)JdbcUtils.loadUserClass((String)stringArray).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                throw DbException.convert(throwable);
            }
        }
        this.cipher = connectionInfo.getProperty("CIPHER");
        if (this.cipher != null) {
            this.fileEncryptionKey = MathUtils.secureRandomBytes(32);
        }
        stringArray = StringUtils.arraySplit(string4, ',', true);
        int n4 = stringArray.length;
        this.transferList.clear();
        this.sessionId = StringUtils.convertBytesToHex(MathUtils.secureRandomBytes(32));
        boolean bl2 = false;
        try {
            for (String string9 : stringArray) {
                try {
                    Transfer transfer = this.initTransfer(connectionInfo, this.databaseName, string9);
                    this.transferList.add(transfer);
                }
                catch (IOException iOException) {
                    if (n4 == 1) {
                        throw DbException.get(90067, iOException, iOException + ": " + string9);
                    }
                    bl2 = true;
                }
            }
            this.checkClosed();
            if (bl2) {
                this.switchOffCluster();
            }
            this.checkClusterDisableAutoCommit(string8);
        }
        catch (DbException dbException) {
            this.traceSystem.close();
            throw dbException;
        }
    }

    private void switchOffCluster() {
        CommandInterface commandInterface = this.prepareCommand("SET CLUSTER ''", Integer.MAX_VALUE);
        commandInterface.executeUpdate(null);
    }

    public void removeServer(IOException iOException, int n, int n2) {
        this.trace.debug(iOException, "removing server because of exception");
        this.transferList.remove(n);
        if (this.transferList.isEmpty() && this.autoReconnect(n2)) {
            return;
        }
        this.checkClosed();
        this.switchOffCluster();
    }

    @Override
    public synchronized CommandInterface prepareCommand(String string2, int n) {
        this.checkClosed();
        return new CommandRemote(this, this.transferList, string2, n);
    }

    private boolean autoReconnect(int n) {
        if (!this.isClosed()) {
            return false;
        }
        if (!this.autoReconnect) {
            return false;
        }
        if (!this.cluster && !this.autoCommit) {
            return false;
        }
        if (n > SysProperties.MAX_RECONNECT) {
            return false;
        }
        ++this.lastReconnect;
        while (true) {
            try {
                this.embedded = this.connectEmbeddedOrServer(false);
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 90135) {
                    throw dbException;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        if (this.embedded == this) {
            this.embedded = null;
        } else {
            this.connectEmbeddedOrServer(true);
        }
        this.recreateSessionState();
        if (this.eventListener != null) {
            this.eventListener.setProgress(4, this.databaseName, n, SysProperties.MAX_RECONNECT);
        }
        return true;
    }

    public void checkClosed() {
        if (this.isClosed()) {
            throw DbException.get(90067, "session closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RuntimeException runtimeException = null;
        if (this.transferList != null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                for (Transfer transfer : this.transferList) {
                    try {
                        this.traceOperation("SESSION_CLOSE", 0);
                        transfer.writeInt(1);
                        this.done(transfer);
                        transfer.close();
                    }
                    catch (RuntimeException runtimeException2) {
                        this.trace.error(runtimeException2, "close");
                        runtimeException = runtimeException2;
                    }
                    catch (Exception exception) {
                        this.trace.error(exception, "close");
                    }
                }
            }
            this.transferList = null;
        }
        this.traceSystem.close();
        if (this.embedded != null) {
            this.embedded.close();
            this.embedded = null;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    @Override
    public Trace getTrace() {
        return this.traceSystem.getTrace(6);
    }

    public int getNextId() {
        return this.nextId++;
    }

    public int getCurrentId() {
        return this.nextId;
    }

    public void done(Transfer transfer) throws IOException {
        transfer.flush();
        int n = transfer.readInt();
        if (n == 0) {
            String string2 = transfer.readString();
            String string3 = transfer.readString();
            String string4 = transfer.readString();
            int n2 = transfer.readInt();
            String string5 = transfer.readString();
            SQLException sQLException = DbException.getJdbcSQLException(string3, string4, string2, n2, null, string5);
            if (n2 == 90067) {
                throw new IOException(sQLException.toString(), sQLException);
            }
            throw DbException.convert(sQLException);
        }
        if (n == 2) {
            this.transferList = null;
        } else if (n == 3) {
            this.sessionStateChanged = true;
            this.currentSchemaName = null;
        } else if (n != 1) {
            throw DbException.get(90067, "unexpected status " + n);
        }
    }

    public boolean isClustered() {
        return this.cluster;
    }

    @Override
    public boolean isClosed() {
        return this.transferList == null || this.transferList.isEmpty();
    }

    public void traceOperation(String string2, int n) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} {1}", string2, n);
        }
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public String getDatabasePath() {
        return "";
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return SysProperties.LOB_CLIENT_MAX_SIZE_MEMORY;
    }

    @Override
    public FileStore openFile(String string2, String string3, boolean bl) {
        if (bl && !FileUtils.exists(string2)) {
            throw DbException.get(90124, string2);
        }
        FileStore fileStore = this.cipher == null ? FileStore.open(this, string2, string3) : FileStore.open(this, string2, string3, this.cipher, this.fileEncryptionKey, 0);
        fileStore.setCheckedWriting(false);
        try {
            fileStore.init();
        }
        catch (DbException dbException) {
            fileStore.closeSilently();
            throw dbException;
        }
        return fileStore;
    }

    @Override
    public DataHandler getDataHandler() {
        return this;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    public int getLastReconnect() {
        return this.lastReconnect;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        if (this.tempFileDeleter == null) {
            this.tempFileDeleter = TempFileDeleter.getInstance();
        }
        return this.tempFileDeleter;
    }

    @Override
    public LobStorageInterface getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = new LobStorageFrontend(this);
        }
        return this.lobStorage;
    }

    @Override
    public synchronized int readLob(long l, byte[] byArray, long l2, byte[] byArray2, int n, int n2) {
        this.checkClosed();
        int n3 = 0;
        for (int j = 0; j < this.transferList.size(); ++j) {
            Transfer transfer = this.transferList.get(j);
            try {
                this.traceOperation("LOB_READ", (int)l);
                transfer.writeInt(17);
                transfer.writeLong(l);
                if (this.clientVersion >= 12) {
                    transfer.writeBytes(byArray);
                }
                transfer.writeLong(l2);
                transfer.writeInt(n2);
                this.done(transfer);
                n2 = transfer.readInt();
                if (n2 <= 0) {
                    return n2;
                }
                transfer.readBytes(byArray2, n, n2);
                return n2;
            }
            catch (IOException iOException) {
                this.removeServer(iOException, j--, ++n3);
                continue;
            }
        }
        return 1;
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        this.initJavaObjectSerializer();
        return this.javaObjectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJavaObjectSerializer() {
        if (this.javaObjectSerializerInitialized) {
            return;
        }
        SessionRemote sessionRemote = this;
        synchronized (sessionRemote) {
            if (this.javaObjectSerializerInitialized) {
                return;
            }
            String string2 = this.readSerializationSettings();
            if (string2 != null && !(string2 = string2.trim()).isEmpty() && !string2.equals("null")) {
                try {
                    this.javaObjectSerializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            this.javaObjectSerializerInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSerializationSettings() {
        String string2 = null;
        try (CommandInterface commandInterface = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS  WHERE NAME='JAVA_OBJECT_SERIALIZER'", Integer.MAX_VALUE);){
            ResultInterface resultInterface = commandInterface.executeQuery(0, false);
            if (resultInterface.next()) {
                Value[] valueArray = resultInterface.currentRow();
                string2 = valueArray[0].getString();
            }
        }
        return string2;
    }

    @Override
    public void addTemporaryLob(Value value) {
    }

    @Override
    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchemaName() {
        String string2 = this.currentSchemaName;
        if (string2 == null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                try (CommandInterface commandInterface = this.prepareCommand("CALL SCHEMA()", 1);
                     ResultInterface resultInterface = commandInterface.executeQuery(1, false);){
                    resultInterface.next();
                    this.currentSchemaName = string2 = resultInterface.currentRow()[0].getString();
                }
            }
        }
        return string2;
    }

    @Override
    public synchronized void setCurrentSchemaName(String string2) {
        this.currentSchemaName = null;
        try (CommandInterface commandInterface = this.prepareCommand(StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), string2).toString(), 0);){
            commandInterface.executeUpdate(null);
            this.currentSchemaName = string2;
        }
    }

    @Override
    public boolean isSupportsGeneratedKeys() {
        return this.getClientVersion() >= 17;
    }

    @Override
    public void setNetworkConnectionInfo(NetworkConnectionInfo networkConnectionInfo) {
    }

    /*
     * Exception decompiling
     */
    @Override
    public IsolationLevel getIsolationLevel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setIsolationLevel(IsolationLevel isolationLevel) {
        if (this.getClientVersion() >= 19) {
            try (CommandInterface commandInterface = this.prepareCommand("SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevel.getSQL(), 0);){
                commandInterface.executeUpdate(null);
            }
        }
        try (CommandInterface commandInterface = this.prepareCommand("SET LOCK_MODE ?", 0);){
            commandInterface.getParameters().get(0).setValue(ValueInt.get(isolationLevel.getLockMode()), false);
            commandInterface.executeUpdate(null);
        }
    }
}

