/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UndoLog;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.FileStore;
import org.h2.table.Table;
import org.h2.value.Value;

public class UndoLogRecord {
    public static final short INSERT = 0;
    public static final short DELETE = 1;
    private static final int IN_MEMORY = 0;
    private static final int STORED = 1;
    private static final int IN_MEMORY_INVALID = 2;
    private Table table;
    private Row row;
    private short operation;
    private short state;
    private int filePos;

    UndoLogRecord(Table table, short s, Row row2) {
        this.table = table;
        this.row = row2;
        this.operation = s;
        this.state = 0;
    }

    boolean isStored() {
        return this.state == 1;
    }

    boolean canStore() {
        return this.table.getUniqueIndex() != null;
    }

    void undo(Session session) {
        Database database = session.getDatabase();
        switch (this.operation) {
            case 0: {
                if (this.state == 2) {
                    this.state = 0;
                }
                if (database.getLockMode() == 0 && this.row.isDeleted()) {
                    return;
                }
                try {
                    this.row.setDeleted(false);
                    this.table.removeRow(session, this.row);
                    this.table.fireAfterRow(session, this.row, null, true);
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getErrorCode() == 90112) break;
                    throw dbException;
                }
            }
            case 1: {
                try {
                    this.table.addRow(session, this.row);
                    this.table.fireAfterRow(session, null, this.row, true);
                    break;
                }
                catch (DbException dbException) {
                    if (session.getDatabase().getLockMode() == 0 && dbException.getSQLException().getErrorCode() == 23505) break;
                    throw dbException;
                }
            }
            default: {
                DbException.throwInternalError("op=" + this.operation);
            }
        }
    }

    void append(Data data2, UndoLog undoLog) {
        int n = data2.length();
        data2.writeInt(0);
        data2.writeInt(this.operation);
        data2.writeByte(this.row.isDeleted() ? (byte)1 : 0);
        data2.writeInt(undoLog.getTableId(this.table));
        data2.writeLong(this.row.getKey());
        int n2 = this.row.getColumnCount();
        data2.writeInt(n2);
        for (int j = 0; j < n2; ++j) {
            Value value = this.row.getValue(j);
            data2.checkCapacity(data2.getValueLen(value));
            data2.writeValue(value);
        }
        data2.fillAligned();
        data2.setInt(n, (data2.length() - n) / 16);
    }

    void save(Data data2, FileStore fileStore, UndoLog undoLog) {
        data2.reset();
        this.append(data2, undoLog);
        this.filePos = (int)(fileStore.getFilePointer() / 16L);
        fileStore.write(data2.getBytes(), 0, data2.length());
        this.row = null;
        this.state = 1;
    }

    static UndoLogRecord loadFromBuffer(Data data2, UndoLog undoLog) {
        UndoLogRecord undoLogRecord = new UndoLogRecord(null, 0, null);
        int n = data2.length();
        int n2 = data2.readInt() * 16;
        undoLogRecord.load(data2, undoLog);
        data2.setPos(n + n2);
        return undoLogRecord;
    }

    void load(Data data2, FileStore fileStore, UndoLog undoLog) {
        int n = 16;
        undoLog.seek(this.filePos);
        data2.reset();
        fileStore.readFully(data2.getBytes(), 0, n);
        int n2 = data2.readInt() * 16;
        data2.checkCapacity(n2);
        if (n2 - n > 0) {
            fileStore.readFully(data2.getBytes(), n, n2 - n);
        }
        short s = this.operation;
        this.load(data2, undoLog);
        if (this.operation != s) {
            DbException.throwInternalError("operation=" + this.operation + " op=" + s);
        }
    }

    private void load(Data data2, UndoLog undoLog) {
        this.operation = (short)data2.readInt();
        boolean bl = data2.readByte() == 1;
        this.table = undoLog.getTable(data2.readInt());
        long l = data2.readLong();
        int n = data2.readInt();
        Value[] valueArray = new Value[n];
        for (int j = 0; j < n; ++j) {
            valueArray[j] = data2.readValue();
        }
        this.row = this.getTable().getDatabase().createRow(valueArray, -1);
        this.row.setKey(l);
        this.row.setDeleted(bl);
        this.state = (short)2;
    }

    public Table getTable() {
        return this.table;
    }

    public long getFilePos() {
        return this.filePos;
    }

    public Row getRow() {
        return this.row;
    }

    void invalidatePos() {
        if (this.state == 0) {
            this.state = (short)2;
        }
    }
}

