/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2.api.Aggregate;
import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.table.Table;
import org.h2.util.JdbcUtils;
import org.h2.value.DataType;

public class UserAggregate
extends DbObjectBase {
    private String className;
    private Class<?> javaClass;

    public UserAggregate(Database database, int n, String string2, String string3, boolean bl) {
        super(database, n, string2, 3);
        this.className = string3;
        if (!bl) {
            this.getInstance();
        }
    }

    public Aggregate getInstance() {
        if (this.javaClass == null) {
            this.javaClass = JdbcUtils.loadUserClass(this.className);
        }
        try {
            Object obj = this.javaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Aggregate aggregate = obj instanceof Aggregate ? (Aggregate)obj : new AggregateWrapper((AggregateFunction)obj);
            return aggregate;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string2) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public String getDropSQL() {
        StringBuilder stringBuilder = new StringBuilder("DROP AGGREGATE IF EXISTS ");
        return this.getSQL(stringBuilder, true).toString();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE AGGREGATE ");
        this.getSQL(stringBuilder, true).append(" FOR ");
        Parser.quoteIdentifier(stringBuilder, this.className, true);
        return stringBuilder.toString();
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public synchronized void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.javaClass = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("AGGREGATE");
    }

    public String getJavaClassName() {
        return this.className;
    }

    private static class AggregateWrapper
    implements Aggregate {
        private final AggregateFunction aggregateFunction;

        AggregateWrapper(AggregateFunction aggregateFunction) {
            this.aggregateFunction = aggregateFunction;
        }

        @Override
        public void init(Connection connection) throws SQLException {
            this.aggregateFunction.init(connection);
        }

        @Override
        public int getInternalType(int[] nArray) throws SQLException {
            int[] nArray2 = new int[nArray.length];
            for (int j = 0; j < nArray.length; ++j) {
                nArray2[j] = DataType.convertTypeToSQLType(nArray[j]);
            }
            return DataType.convertSQLTypeToValueType(this.aggregateFunction.getType(nArray2));
        }

        @Override
        public void add(Object object) throws SQLException {
            this.aggregateFunction.add(object);
        }

        @Override
        public Object getResult() throws SQLException {
            return this.aggregateFunction.getResult();
        }
    }
}

