/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBytes;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class ConcatenationOperation
extends Expression {
    private Expression left;
    private Expression right;
    private TypeInfo type;

    public ConcatenationOperation(Expression expression, Expression expression2) {
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" || ");
        return this.right.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session).convertTo(this.type, session, false, null);
        Value value2 = this.right.getValue(session).convertTo(this.type, session, false, null);
        switch (this.type.getValueType()) {
            case 17: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                Value[] valueArray = ((ValueArray)value).getList();
                Value[] valueArray2 = ((ValueArray)value2).getList();
                int n = valueArray.length;
                int n2 = valueArray2.length;
                Value[] valueArray3 = Arrays.copyOf(valueArray, n + n2);
                System.arraycopy(valueArray2, 0, valueArray3, n, n2);
                return ValueArray.get(valueArray3);
            }
            case 12: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                byte[] byArray = value.getBytesNoCopy();
                byte[] byArray2 = value2.getBytesNoCopy();
                int n = byArray.length;
                int n3 = byArray2.length;
                byte[] byArray3 = Arrays.copyOf(byArray, n + n3);
                System.arraycopy(byArray2, 0, byArray3, n, n3);
                return ValueBytes.getNoCopy(byArray3);
            }
        }
        if (value == ValueNull.INSTANCE) {
            if (session.getDatabase().getMode().nullConcatIsNull) {
                return ValueNull.INSTANCE;
            }
            return value2;
        }
        if (value2 == ValueNull.INSTANCE) {
            if (session.getDatabase().getMode().nullConcatIsNull) {
                return ValueNull.INSTANCE;
            }
            return value;
        }
        String string2 = value.getString();
        String string3 = value2.getString();
        StringBuilder stringBuilder = new StringBuilder(string2.length() + string3.length());
        stringBuilder.append(string2).append(string3);
        return ValueString.get(stringBuilder.toString());
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        TypeInfo typeInfo = this.left.getType();
        TypeInfo typeInfo2 = this.right.getType();
        int n = typeInfo.getValueType();
        int n2 = typeInfo2.getValueType();
        this.type = n == 17 || n2 == 17 ? TypeInfo.TYPE_ARRAY : (DataType.isBinaryStringType(n) && DataType.isBinaryStringType(n2) ? TypeInfo.getTypeInfo(12, DataType.addPrecision(typeInfo.getPrecision(), typeInfo2.getPrecision()), 0, null) : (DataType.isCharacterStringType(n) && DataType.isCharacterStringType(n2) ? TypeInfo.getTypeInfo(13, DataType.addPrecision(typeInfo.getPrecision(), typeInfo2.getPrecision()), 0, null) : TypeInfo.TYPE_STRING));
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

