/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.Arrays;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.condition.SimplePredicate;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class TypePredicate
extends SimplePredicate {
    private final TypeInfo[] typeList;
    private int[] valueTypes;

    public TypePredicate(Expression expression, boolean bl, TypeInfo[] typeInfoArray) {
        super(expression, bl);
        this.typeList = typeInfoArray;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" IS");
        if (this.not) {
            stringBuilder.append(" NOT");
        }
        stringBuilder.append(" OF (");
        for (int j = 0; j < this.typeList.length; ++j) {
            if (j > 0) {
                stringBuilder.append(", ");
            }
            this.typeList[j].getSQL(stringBuilder);
        }
        return stringBuilder.append(')');
    }

    @Override
    public Expression optimize(Session session) {
        int n = this.typeList.length;
        this.valueTypes = new int[n];
        for (int j = 0; j < n; ++j) {
            this.valueTypes[j] = this.typeList[j].getValueType();
        }
        Arrays.sort(this.valueTypes);
        return super.optimize(session);
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(Arrays.binarySearch(this.valueTypes, value.getValueType()) >= 0 ^ this.not);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new TypePredicate(this.left, !this.not, this.typeList);
    }
}

