/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.api.IntervalQualifier;
import org.h2.engine.Mode;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueInterval;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public final class DateTimeFunctions {
    private static final BigDecimal BD_SECONDS_PER_DAY = new BigDecimal(86400L);
    private static final BigInteger BI_SECONDS_PER_DAY = BigInteger.valueOf(86400L);
    private static final BigDecimal BD_NANOS_PER_SECOND = new BigDecimal(1000000000L);
    private static final HashMap<String, Integer> DATE_PART = new HashMap(128);
    private static volatile String[][] MONTHS_AND_WEEKS;

    public static Value dateadd(String string2, long l, Value value) {
        int n = DateTimeFunctions.getDatePart(string2);
        if (n != 126 && n != 128 && n != 129 && (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE)) {
            throw DbException.getInvalidValueException("DATEADD count", l);
        }
        boolean bl = !(value instanceof ValueTime) && !(value instanceof ValueTimeTimeZone);
        boolean bl2 = !(value instanceof ValueDate);
        boolean bl3 = false;
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l2 = lArray[0];
        long l3 = lArray[1];
        switch (n) {
            case 115: {
                l *= 3L;
            }
            case 113: 
            case 118: {
                if (!bl) {
                    throw DbException.getInvalidValueException("DATEADD time part", string2);
                }
                long l4 = DateTimeUtils.yearFromDateValue(l2);
                long l5 = DateTimeUtils.monthFromDateValue(l2);
                int n2 = DateTimeUtils.dayFromDateValue(l2);
                if (n == 118) {
                    l4 += l;
                } else {
                    l5 += l;
                }
                l2 = DateTimeUtils.dateValueFromDenormalizedDate(l4, l5, n2);
                return DateTimeUtils.dateTimeToValue(value, l2, l3, bl3);
            }
            case 117: 
            case 123: {
                l *= 7L;
            }
            case 108: 
            case 109: 
            case 110: 
            case 124: 
            case 136: {
                if (!bl) {
                    throw DbException.getInvalidValueException("DATEADD time part", string2);
                }
                l2 = DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(l2) + l);
                return DateTimeUtils.dateTimeToValue(value, l2, l3, bl3);
            }
            case 111: {
                l *= 3600000000000L;
                break;
            }
            case 112: {
                l *= 60000000000L;
                break;
            }
            case 116: 
            case 127: {
                l *= 1000000000L;
                break;
            }
            case 126: {
                l *= 1000000L;
                break;
            }
            case 128: {
                l *= 1000L;
                break;
            }
            case 129: {
                break;
            }
            case 130: {
                l *= 60L;
            }
            case 131: {
                l *= 60L;
            }
            case 132: {
                if (value instanceof ValueTimestampTimeZone) {
                    return ValueTimestampTimeZone.fromDateValueAndNanos(l2, l3, (int)(l += (long)((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds()));
                }
                if (value instanceof ValueTimeTimeZone) {
                    return ValueTimeTimeZone.fromNanos(l3, (int)(l += (long)((ValueTimeTimeZone)value).getTimeZoneOffsetSeconds()));
                }
                throw DbException.getUnsupportedException("DATEADD " + string2);
            }
            default: {
                throw DbException.getUnsupportedException("DATEADD " + string2);
            }
        }
        if (!bl2) {
            bl3 = true;
        }
        if ((l3 += l) >= 86400000000000L || l3 < 0L) {
            long l6 = l3 >= 86400000000000L ? l3 / 86400000000000L : (l3 - 86400000000000L + 1L) / 86400000000000L;
            return DateTimeUtils.dateTimeToValue(value, DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(l2) + l6), l3 -= l6 * 86400000000000L, bl3);
        }
        return DateTimeUtils.dateTimeToValue(value, l2, l3, bl3);
    }

    public static long datediff(String string2, Value value, Value value2) {
        int n = DateTimeFunctions.getDatePart(string2);
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l = lArray[0];
        long l2 = DateTimeUtils.absoluteDayFromDateValue(l);
        long[] lArray2 = DateTimeUtils.dateAndTimeFromValue(value2);
        long l3 = lArray2[0];
        long l4 = DateTimeUtils.absoluteDayFromDateValue(l3);
        switch (n) {
            case 111: 
            case 112: 
            case 116: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                long l5 = lArray[1];
                long l6 = lArray2[1];
                switch (n) {
                    case 129: {
                        return (l4 - l2) * 86400000000000L + (l6 - l5);
                    }
                    case 128: {
                        return (l4 - l2) * 86400000000L + (l6 / 1000L - l5 / 1000L);
                    }
                    case 126: {
                        return (l4 - l2) * 86400000L + (l6 / 1000000L - l5 / 1000000L);
                    }
                    case 116: 
                    case 127: {
                        return (l4 - l2) * 86400L + (l6 / 1000000000L - l5 / 1000000000L);
                    }
                    case 112: {
                        return (l4 - l2) * 1440L + (l6 / 60000000000L - l5 / 60000000000L);
                    }
                    case 111: {
                        return (l4 - l2) * 24L + (l6 / 3600000000000L - l5 / 3600000000000L);
                    }
                }
            }
            case 108: 
            case 109: 
            case 110: 
            case 124: 
            case 136: {
                return l4 - l2;
            }
            case 117: {
                return DateTimeFunctions.weekdiff(l2, l4, 0);
            }
            case 123: {
                return DateTimeFunctions.weekdiff(l2, l4, 1);
            }
            case 113: {
                return (DateTimeUtils.yearFromDateValue(l3) - DateTimeUtils.yearFromDateValue(l)) * 12 + DateTimeUtils.monthFromDateValue(l3) - DateTimeUtils.monthFromDateValue(l);
            }
            case 115: {
                return (DateTimeUtils.yearFromDateValue(l3) - DateTimeUtils.yearFromDateValue(l)) * 4 + (DateTimeUtils.monthFromDateValue(l3) - 1) / 3 - (DateTimeUtils.monthFromDateValue(l) - 1) / 3;
            }
            case 118: {
                return DateTimeUtils.yearFromDateValue(l3) - DateTimeUtils.yearFromDateValue(l);
            }
            case 130: 
            case 131: 
            case 132: {
                int n2 = value instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds() : (value instanceof ValueTimeTimeZone ? ((ValueTimeTimeZone)value).getTimeZoneOffsetSeconds() : DateTimeUtils.getTimeZoneOffset(l, lArray[1]));
                int n3 = value2 instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)value2).getTimeZoneOffsetSeconds() : (value2 instanceof ValueTimeTimeZone ? ((ValueTimeTimeZone)value2).getTimeZoneOffsetSeconds() : DateTimeUtils.getTimeZoneOffset(l3, lArray2[1]));
                if (n == 130) {
                    return n3 / 3600 - n2 / 3600;
                }
                if (n == 131) {
                    return n3 / 60 - n2 / 60;
                }
                return n3 - n2;
            }
        }
        throw DbException.getUnsupportedException("DATEDIFF " + string2);
    }

    public static Value extract(String string2, Value value, Mode mode) {
        Value value2;
        int n = DateTimeFunctions.getDatePart(string2);
        if (n != 127) {
            value2 = ValueInt.get(DateTimeFunctions.getIntDatePart(value, n, mode));
        } else {
            if (value instanceof ValueInterval) {
                ValueInterval valueInterval = (ValueInterval)value;
                if (valueInterval.getQualifier().isYearMonth()) {
                    valueInterval = (ValueInterval)valueInterval.convertTo(32);
                    long l = valueInterval.getLeading();
                    long l2 = valueInterval.getRemaining();
                    BigInteger bigInteger = BigInteger.valueOf(l).multiply(BigInteger.valueOf(31557600L)).add(BigInteger.valueOf(l2 * 2592000L));
                    if (valueInterval.isNegative()) {
                        bigInteger = bigInteger.negate();
                    }
                    return ValueDecimal.get(bigInteger);
                }
                return ValueDecimal.get(new BigDecimal(IntervalUtils.intervalToAbsolute(valueInterval)).divide(BD_NANOS_PER_SECOND));
            }
            long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
            long l = lArray[0];
            long l3 = lArray[1];
            if (value instanceof ValueTime) {
                value2 = ValueDecimal.get(BigDecimal.valueOf(l3).divide(BD_NANOS_PER_SECOND));
            } else if (value instanceof ValueDate) {
                value2 = ValueDecimal.get(BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(l)).multiply(BI_SECONDS_PER_DAY));
            } else {
                BigDecimal bigDecimal = BigDecimal.valueOf(l3).divide(BD_NANOS_PER_SECOND).add(BigDecimal.valueOf(DateTimeUtils.absoluteDayFromDateValue(l)).multiply(BD_SECONDS_PER_DAY));
                value2 = value instanceof ValueTimestampTimeZone ? ValueDecimal.get(bigDecimal.subtract(BigDecimal.valueOf(((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds()))) : (value instanceof ValueTimeTimeZone ? ValueDecimal.get(bigDecimal.subtract(BigDecimal.valueOf(((ValueTimeTimeZone)value).getTimeZoneOffsetSeconds()))) : ValueDecimal.get(bigDecimal));
            }
        }
        return value2;
    }

    public static Value truncateDate(String string2, Value value) {
        Value value2;
        long l;
        int n = DateTimeFunctions.getDatePart(string2);
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l2 = lArray[0];
        long l3 = lArray[1];
        switch (n) {
            case 128: {
                long l4 = 1000L;
                long l5 = l3 / l4;
                l = l5 * l4;
                break;
            }
            case 126: {
                long l6 = 1000000L;
                long l7 = l3 / l6;
                l = l7 * l6;
                break;
            }
            case 116: {
                long l8 = l3 / 1000000000L;
                l = l8 * 1000000000L;
                break;
            }
            case 112: {
                long l9 = l3 / 60000000000L;
                l = l9 * 60000000000L;
                break;
            }
            case 111: {
                long l10 = l3 / 3600000000000L;
                l = l10 * 3600000000000L;
                break;
            }
            case 108: {
                l = 0L;
                break;
            }
            case 117: {
                long l11 = DateTimeUtils.absoluteDayFromDateValue(l2);
                int n2 = DateTimeUtils.getDayOfWeekFromAbsolute(l11, 1);
                if (n2 != 1) {
                    l2 = DateTimeUtils.dateValueFromAbsoluteDay(l11 - (long)n2 + 1L);
                }
                l = 0L;
                break;
            }
            case 113: {
                long l12 = DateTimeUtils.yearFromDateValue(l2);
                int n3 = DateTimeUtils.monthFromDateValue(l2);
                l2 = DateTimeUtils.dateValue(l12, n3, 1);
                l = 0L;
                break;
            }
            case 115: {
                long l13 = DateTimeUtils.yearFromDateValue(l2);
                int n4 = DateTimeUtils.monthFromDateValue(l2);
                n4 = (n4 - 1) / 3 * 3 + 1;
                l2 = DateTimeUtils.dateValue(l13, n4, 1);
                l = 0L;
                break;
            }
            case 118: {
                long l14 = DateTimeUtils.yearFromDateValue(l2);
                l2 = DateTimeUtils.dateValue(l14, 1, 1);
                l = 0L;
                break;
            }
            case 133: {
                long l15 = DateTimeUtils.yearFromDateValue(l2);
                l15 = l15 / 10L * 10L;
                l2 = DateTimeUtils.dateValue(l15, 1, 1);
                l = 0L;
                break;
            }
            case 134: {
                long l16 = DateTimeUtils.yearFromDateValue(l2);
                l16 = (l16 - 1L) / 100L * 100L + 1L;
                l2 = DateTimeUtils.dateValue(l16, 1, 1);
                l = 0L;
                break;
            }
            case 135: {
                long l17 = DateTimeUtils.yearFromDateValue(l2);
                l17 = (l17 - 1L) / 1000L * 1000L + 1L;
                l2 = DateTimeUtils.dateValue(l17, 1, 1);
                l = 0L;
                break;
            }
            default: {
                throw DbException.getUnsupportedException(string2);
            }
        }
        if (value instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
            value2 = ValueTimestampTimeZone.fromDateValueAndNanos(l2, l, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
        } else if (value instanceof ValueTimeTimeZone) {
            ValueTimeTimeZone valueTimeTimeZone = (ValueTimeTimeZone)value;
            value2 = ValueTimeTimeZone.fromNanos(l, valueTimeTimeZone.getTimeZoneOffsetSeconds());
        } else {
            value2 = ValueTimestamp.fromDateValueAndNanos(l2, l);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = DateTimeFunctions.getDateFormat(string2, string3, string4);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    private static SimpleDateFormat getDateFormat(String string2, String string3, String string4) {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string3 == null) {
                simpleDateFormat = new SimpleDateFormat(string2);
            } else {
                Locale locale = new Locale(string3);
                simpleDateFormat = new SimpleDateFormat(string2, locale);
            }
            if (string4 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string4));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string2 + "/" + string3 + "/" + string4);
        }
    }

    public static int getDatePart(String string2) {
        Integer n = DATE_PART.get(StringUtils.toUpperEnglish(string2));
        if (n == null) {
            throw DbException.getInvalidValueException("date part", string2);
        }
        return n;
    }

    public static int getIntDatePart(Value value, int n, Mode mode) {
        if (value instanceof ValueInterval) {
            long l;
            ValueInterval valueInterval = (ValueInterval)value;
            IntervalQualifier intervalQualifier = valueInterval.getQualifier();
            boolean bl = valueInterval.isNegative();
            long l2 = valueInterval.getLeading();
            long l3 = valueInterval.getRemaining();
            switch (n) {
                case 118: {
                    l = IntervalUtils.yearsFromInterval(intervalQualifier, bl, l2, l3);
                    break;
                }
                case 113: {
                    l = IntervalUtils.monthsFromInterval(intervalQualifier, bl, l2, l3);
                    break;
                }
                case 108: 
                case 110: {
                    l = IntervalUtils.daysFromInterval(intervalQualifier, bl, l2, l3);
                    break;
                }
                case 111: {
                    l = IntervalUtils.hoursFromInterval(intervalQualifier, bl, l2, l3);
                    break;
                }
                case 112: {
                    l = IntervalUtils.minutesFromInterval(intervalQualifier, bl, l2, l3);
                    break;
                }
                case 116: {
                    l = IntervalUtils.nanosFromInterval(intervalQualifier, bl, l2, l3) / 1000000000L;
                    break;
                }
                case 126: {
                    l = IntervalUtils.nanosFromInterval(intervalQualifier, bl, l2, l3) / 1000000L % 1000L;
                    break;
                }
                case 128: {
                    l = IntervalUtils.nanosFromInterval(intervalQualifier, bl, l2, l3) / 1000L % 1000000L;
                    break;
                }
                case 129: {
                    l = IntervalUtils.nanosFromInterval(intervalQualifier, bl, l2, l3) % 1000000000L;
                    break;
                }
                default: {
                    throw DbException.getUnsupportedException("getDatePart(" + value + ", " + n + ')');
                }
            }
            return (int)l;
        }
        long[] lArray = DateTimeUtils.dateAndTimeFromValue(value);
        long l = lArray[0];
        long l4 = lArray[1];
        switch (n) {
            case 118: {
                return DateTimeUtils.yearFromDateValue(l);
            }
            case 113: {
                return DateTimeUtils.monthFromDateValue(l);
            }
            case 108: {
                return DateTimeUtils.dayFromDateValue(l);
            }
            case 111: {
                return (int)(l4 / 3600000000000L % 24L);
            }
            case 112: {
                return (int)(l4 / 60000000000L % 60L);
            }
            case 116: {
                return (int)(l4 / 1000000000L % 60L);
            }
            case 126: {
                return (int)(l4 / 1000000L % 1000L);
            }
            case 128: {
                return (int)(l4 / 1000L % 1000000L);
            }
            case 129: {
                return (int)(l4 % 1000000000L);
            }
            case 110: {
                return DateTimeUtils.getDayOfYear(l);
            }
            case 109: {
                return DateTimeUtils.getSundayDayOfWeek(l);
            }
            case 136: {
                int n2 = DateTimeUtils.getSundayDayOfWeek(l);
                if (mode.getEnum() == Mode.ModeEnum.PostgreSQL) {
                    --n2;
                }
                return n2;
            }
            case 117: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                return DateTimeUtils.getWeekOfYear(l, gregorianCalendar.getFirstDayOfWeek() - 1, gregorianCalendar.getMinimalDaysInFirstWeek());
            }
            case 115: {
                return (DateTimeUtils.monthFromDateValue(l) - 1) / 3 + 1;
            }
            case 122: {
                return DateTimeUtils.getIsoWeekYear(l);
            }
            case 123: {
                return DateTimeUtils.getIsoWeekOfYear(l);
            }
            case 124: {
                return DateTimeUtils.getIsoDayOfWeek(l);
            }
            case 130: 
            case 131: 
            case 132: {
                int n3 = value instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds() : (value instanceof ValueTimeTimeZone ? ((ValueTimeTimeZone)value).getTimeZoneOffsetSeconds() : DateTimeUtils.getTimeZoneOffset(l, l4));
                if (n == 130) {
                    return n3 / 3600;
                }
                if (n == 131) {
                    return n3 % 3600 / 60;
                }
                return n3 % 60;
            }
        }
        throw DbException.getUnsupportedException("getDatePart(" + value + ", " + n + ')');
    }

    public static String[] getMonthsAndWeeks(int n) {
        String[][] stringArray = MONTHS_AND_WEEKS;
        if (stringArray == null) {
            stringArray = new String[2][];
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(Locale.ENGLISH);
            stringArray[0] = dateFormatSymbols.getMonths();
            stringArray[1] = dateFormatSymbols.getWeekdays();
            MONTHS_AND_WEEKS = stringArray;
        }
        return stringArray[n];
    }

    public static boolean isDatePart(String string2) {
        return DATE_PART.containsKey(StringUtils.toUpperEnglish(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string2, String string3, String string4, String string5) {
        SimpleDateFormat simpleDateFormat = DateTimeFunctions.getDateFormat(string3, string4, string5);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string2);
            }
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string2);
        }
    }

    private static long weekdiff(long l, long l2, int n) {
        long l3 = (l += (long)(4 - n)) / 7L;
        if (l < 0L && l3 * 7L != l) {
            --l3;
        }
        long l4 = (l2 += (long)(4 - n)) / 7L;
        if (l2 < 0L && l4 * 7L != l2) {
            --l4;
        }
        return l4 - l3;
    }

    private DateTimeFunctions() {
    }

    static {
        DATE_PART.put("SQL_TSI_YEAR", 118);
        DATE_PART.put("YEAR", 118);
        DATE_PART.put("YYYY", 118);
        DATE_PART.put("YY", 118);
        DATE_PART.put("ISO_YEAR", 122);
        DATE_PART.put("ISOYEAR", 122);
        DATE_PART.put("SQL_TSI_MONTH", 113);
        DATE_PART.put("MONTH", 113);
        DATE_PART.put("MM", 113);
        DATE_PART.put("M", 113);
        DATE_PART.put("QUARTER", 115);
        DATE_PART.put("SQL_TSI_WEEK", 117);
        DATE_PART.put("WW", 117);
        DATE_PART.put("WK", 117);
        DATE_PART.put("WEEK", 117);
        DATE_PART.put("ISO_WEEK", 123);
        DATE_PART.put("DAY", 108);
        DATE_PART.put("DD", 108);
        DATE_PART.put("D", 108);
        DATE_PART.put("SQL_TSI_DAY", 108);
        DATE_PART.put("DAY_OF_WEEK", 109);
        DATE_PART.put("DAYOFWEEK", 109);
        DATE_PART.put("DOW", 136);
        DATE_PART.put("ISO_DAY_OF_WEEK", 124);
        DATE_PART.put("ISODOW", 124);
        DATE_PART.put("DAYOFYEAR", 110);
        DATE_PART.put("DAY_OF_YEAR", 110);
        DATE_PART.put("DY", 110);
        DATE_PART.put("DOY", 110);
        DATE_PART.put("SQL_TSI_HOUR", 111);
        DATE_PART.put("HOUR", 111);
        DATE_PART.put("HH", 111);
        DATE_PART.put("SQL_TSI_MINUTE", 112);
        DATE_PART.put("MINUTE", 112);
        DATE_PART.put("MI", 112);
        DATE_PART.put("N", 112);
        DATE_PART.put("SQL_TSI_SECOND", 116);
        DATE_PART.put("SECOND", 116);
        DATE_PART.put("SS", 116);
        DATE_PART.put("S", 116);
        DATE_PART.put("MILLISECOND", 126);
        DATE_PART.put("MILLISECONDS", 126);
        DATE_PART.put("MS", 126);
        DATE_PART.put("EPOCH", 127);
        DATE_PART.put("MICROSECOND", 128);
        DATE_PART.put("MICROSECONDS", 128);
        DATE_PART.put("MCS", 128);
        DATE_PART.put("NANOSECOND", 129);
        DATE_PART.put("NS", 129);
        DATE_PART.put("TIMEZONE_HOUR", 130);
        DATE_PART.put("TIMEZONE_MINUTE", 131);
        DATE_PART.put("TIMEZONE_SECOND", 132);
        DATE_PART.put("DECADE", 133);
        DATE_PART.put("CENTURY", 134);
        DATE_PART.put("MILLENNIUM", 135);
    }
}

