/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.fulltext.FullText;
import org.h2.fulltext.IndexInfo;
import org.h2.util.SoftHashMap;

final class FullTextSettings {
    private static final Map<String, FullTextSettings> SETTINGS = new HashMap<String, FullTextSettings>();
    private boolean initialized;
    private final Set<String> ignoreList = new HashSet<String>();
    private final Map<String, Integer> words = new HashMap<String, Integer>();
    private final ConcurrentHashMap<Integer, IndexInfo> indexes = new ConcurrentHashMap();
    private final SoftHashMap<Connection, SoftHashMap<String, PreparedStatement>> cache = new SoftHashMap();
    private String whitespaceChars = " \t\n\r\f+\"*%&/()=?'!,.;:-_#@|^~`{}[]<>\\";

    private FullTextSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIgnored() {
        Set<String> set2 = this.ignoreList;
        synchronized (set2) {
            this.ignoreList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnored(Iterable<String> iterable) {
        Set<String> set2 = this.ignoreList;
        synchronized (set2) {
            for (String string2 : iterable) {
                string2 = FullTextSettings.normalizeWord(string2);
                this.ignoreList.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWordList() {
        Map<String, Integer> map2 = this.words;
        synchronized (map2) {
            this.words.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWordId(String string2) {
        Map<String, Integer> map2 = this.words;
        synchronized (map2) {
            return this.words.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWord(String string2, Integer n) {
        Map<String, Integer> map2 = this.words;
        synchronized (map2) {
            if (!this.words.containsKey(string2)) {
                this.words.put(string2, n);
            }
        }
    }

    protected IndexInfo getIndexInfo(int n) {
        return this.indexes.get(n);
    }

    protected void addIndexInfo(IndexInfo indexInfo) {
        this.indexes.put(indexInfo.id, indexInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertWord(String string2) {
        string2 = FullTextSettings.normalizeWord(string2);
        Set<String> set2 = this.ignoreList;
        synchronized (set2) {
            if (this.ignoreList.contains(string2)) {
                return null;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FullTextSettings getInstance(Connection connection) throws SQLException {
        FullTextSettings fullTextSettings;
        String string2 = FullTextSettings.getIndexPath(connection);
        Map<String, FullTextSettings> map2 = SETTINGS;
        synchronized (map2) {
            fullTextSettings = SETTINGS.get(string2);
            if (fullTextSettings == null) {
                fullTextSettings = new FullTextSettings();
                SETTINGS.put(string2, fullTextSettings);
            }
        }
        return fullTextSettings;
    }

    private static String getIndexPath(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL IFNULL(DATABASE_PATH(), 'MEM:' || DATABASE())");
        resultSet.next();
        String string2 = resultSet.getString(1);
        if ("MEM:UNNAMED".equals(string2)) {
            throw FullText.throwException("Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        resultSet.close();
        return string2;
    }

    protected synchronized PreparedStatement prepare(Connection connection, String string2) throws SQLException {
        PreparedStatement preparedStatement;
        SoftHashMap<String, PreparedStatement> softHashMap = this.cache.get(connection);
        if (softHashMap == null) {
            softHashMap = new SoftHashMap();
            this.cache.put(connection, softHashMap);
        }
        if ((preparedStatement = softHashMap.get(string2)) != null && preparedStatement.getConnection().isClosed()) {
            preparedStatement = null;
        }
        if (preparedStatement == null) {
            preparedStatement = connection.prepareStatement(string2);
            softHashMap.put(string2, preparedStatement);
        }
        return preparedStatement;
    }

    protected void removeAllIndexes() {
        this.indexes.clear();
    }

    protected void removeIndexInfo(IndexInfo indexInfo) {
        this.indexes.remove(indexInfo.id);
    }

    protected void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeAll() {
        Map<String, FullTextSettings> map2 = SETTINGS;
        synchronized (map2) {
            SETTINGS.clear();
        }
    }

    protected void setWhitespaceChars(String string2) {
        this.whitespaceChars = string2;
    }

    protected String getWhitespaceChars() {
        return this.whitespaceChars;
    }

    private static String normalizeWord(String string2) {
        return string2.toUpperCase();
    }
}

