/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.h2.Driver;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceBackwardsCompat;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXAConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

public class JdbcDataSource
extends TraceObject
implements XADataSource,
DataSource,
ConnectionPoolDataSource,
Serializable,
Referenceable,
JdbcDataSourceBackwardsCompat {
    private static final long serialVersionUID = 1288136338451857771L;
    private transient JdbcDataSourceFactory factory;
    private transient PrintWriter logWriter;
    private int loginTimeout;
    private String userName = "";
    private char[] passwordChars = new char[0];
    private String url = "";
    private String description;

    public JdbcDataSource() {
        this.initFactory();
        int n = JdbcDataSource.getNextId(12);
        this.setTrace(this.factory.getTrace(), 12, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initFactory();
        objectInputStream.defaultReadObject();
    }

    private void initFactory() {
        this.factory = new JdbcDataSourceFactory();
    }

    @Override
    public int getLoginTimeout() {
        this.debugCodeCall("getLoginTimeout");
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.debugCodeCall("setLoginTimeout", n);
        this.loginTimeout = n;
    }

    @Override
    public PrintWriter getLogWriter() {
        this.debugCodeCall("getLogWriter");
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.debugCodeCall("setLogWriter(out)");
        this.logWriter = printWriter;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        return this.getJdbcConnection(this.userName, StringUtils.cloneCharArray(this.passwordChars));
    }

    @Override
    public Connection getConnection(String string2, String string3) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getConnection(" + JdbcDataSource.quote(string2) + ", \"\");");
        }
        return this.getJdbcConnection(string2, JdbcDataSource.convertToCharArray(string3));
    }

    private JdbcConnection getJdbcConnection(String string2, char[] cArray) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getJdbcConnection(" + JdbcDataSource.quote(string2) + ", new char[0]);");
        }
        Properties properties2 = new Properties();
        properties2.setProperty("user", string2);
        properties2.put("password", cArray);
        Connection connection = Driver.load().connect(this.url, properties2);
        if (connection == null) {
            throw new SQLException("No suitable driver found for " + this.url, "08001", 8001);
        }
        if (!(connection instanceof JdbcConnection)) {
            throw new SQLException("Connecting with old version is not supported: " + this.url, "08001", 8001);
        }
        return (JdbcConnection)connection;
    }

    public String getURL() {
        this.debugCodeCall("getURL");
        return this.url;
    }

    public void setURL(String string2) {
        this.debugCodeCall("setURL", string2);
        this.url = string2;
    }

    public String getUrl() {
        this.debugCodeCall("getUrl");
        return this.url;
    }

    public void setUrl(String string2) {
        this.debugCodeCall("setUrl", string2);
        this.url = string2;
    }

    public void setPassword(String string2) {
        this.debugCodeCall("setPassword", "");
        this.passwordChars = JdbcDataSource.convertToCharArray(string2);
    }

    public void setPasswordChars(char[] cArray) {
        if (this.isDebugEnabled()) {
            this.debugCode("setPasswordChars(new char[0]);");
        }
        this.passwordChars = cArray;
    }

    private static char[] convertToCharArray(String string2) {
        return string2 == null ? null : string2.toCharArray();
    }

    private static String convertToString(char[] cArray) {
        return cArray == null ? null : new String(cArray);
    }

    public String getPassword() {
        this.debugCodeCall("getPassword");
        return JdbcDataSource.convertToString(this.passwordChars);
    }

    public String getUser() {
        this.debugCodeCall("getUser");
        return this.userName;
    }

    public void setUser(String string2) {
        this.debugCodeCall("setUser", string2);
        this.userName = string2;
    }

    public String getDescription() {
        this.debugCodeCall("getDescription");
        return this.description;
    }

    public void setDescription(String string2) {
        this.debugCodeCall("getDescription", string2);
        this.description = string2;
    }

    @Override
    public Reference getReference() {
        this.debugCodeCall("getReference");
        String string2 = JdbcDataSourceFactory.class.getName();
        Reference reference = new Reference(this.getClass().getName(), string2, null);
        reference.add(new StringRefAddr("url", this.url));
        reference.add(new StringRefAddr("user", this.userName));
        reference.add(new StringRefAddr("password", JdbcDataSource.convertToString(this.passwordChars)));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        reference.add(new StringRefAddr("description", this.description));
        return reference;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        this.debugCodeCall("getXAConnection");
        int n = JdbcDataSource.getNextId(13);
        return new JdbcXAConnection(this.factory, n, this.getJdbcConnection(this.userName, StringUtils.cloneCharArray(this.passwordChars)));
    }

    @Override
    public XAConnection getXAConnection(String string2, String string3) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getXAConnection(" + JdbcDataSource.quote(string2) + ", \"\");");
        }
        int n = JdbcDataSource.getNextId(13);
        return new JdbcXAConnection(this.factory, n, this.getJdbcConnection(string2, JdbcDataSource.convertToCharArray(string3)));
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        this.debugCodeCall("getPooledConnection");
        return this.getXAConnection();
    }

    @Override
    public PooledConnection getPooledConnection(String string2, String string3) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getPooledConnection(" + JdbcDataSource.quote(string2) + ", \"\");");
        }
        return this.getXAConnection(string2, string3);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", clazz);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.userName;
    }

    static {
        Driver.load();
    }
}

