/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.StreamStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.store.CountingReaderInputStream;
import org.h2.store.LobStorageInterface;
import org.h2.store.RangeInputStream;
import org.h2.util.IOUtils;
import org.h2.value.Value;
import org.h2.value.ValueLobDb;

public class LobStorageMap
implements LobStorageInterface {
    private static final boolean TRACE = false;
    private final Database database;
    private boolean init;
    private final Object nextLobIdSync = new Object();
    private long nextLobId;
    private MVMap<Long, Object[]> lobMap;
    private MVMap<Object[], Boolean> refMap;
    private StreamStore streamStore;

    public LobStorageMap(Database database) {
        this.database = database;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        MVTableEngine.Store store = this.database.getStore();
        MVStore mVStore = store == null ? MVStore.open(null) : store.getMvStore();
        this.lobMap = mVStore.openMap("lobMap");
        this.refMap = mVStore.openMap("lobRef");
        MVMap<Long, byte[]> mVMap = mVStore.openMap("lobData");
        this.streamStore = new StreamStore(mVMap);
        if (this.database.isReadOnly()) {
            return;
        }
        if (mVMap.isEmpty()) {
            return;
        }
        long l = -1L;
        Object object = this.lobMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<Long, Object[]> entry = object.next();
            long l2 = entry.getKey();
            Object[] objectArray = entry.getValue();
            byte[] byArray = (byte[])objectArray[0];
            long l3 = this.streamStore.getMaxBlockKey(byArray);
            if (l3 == -1L || l3 <= l) continue;
            l = l3;
        }
        while ((object = mVMap.lastKey()) != null && (Long)object > l) {
            mVMap.remove(object);
        }
        object = mVMap.lastKey();
        if (object != null) {
            this.streamStore.setNextKey((Long)object + 1L);
        }
    }

    @Override
    public Value createBlob(InputStream inputStream2, long l) {
        this.init();
        int n = 15;
        try {
            if (l != -1L && l <= (long)this.database.getMaxLengthInplaceLob()) {
                byte[] byArray = new byte[(int)l];
                int n2 = IOUtils.readFully(inputStream2, byArray, (int)l);
                if ((long)n2 > l) {
                    throw new IllegalStateException("len > blobLength, " + n2 + " > " + l);
                }
                if (n2 < byArray.length) {
                    byArray = Arrays.copyOf(byArray, n2);
                }
                return ValueLobDb.createSmallLob(n, byArray);
            }
            if (l != -1L) {
                inputStream2 = new RangeInputStream(inputStream2, 0L, l);
            }
            return this.createLob(inputStream2, n);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    @Override
    public Value createClob(Reader reader, long l) {
        this.init();
        int n = 16;
        try {
            if (l != -1L && l * 3L <= (long)this.database.getMaxLengthInplaceLob()) {
                char[] cArray = new char[(int)l];
                int n2 = IOUtils.readFully(reader, cArray, (int)l);
                if ((long)n2 > l) {
                    throw new IllegalStateException("len > blobLength, " + n2 + " > " + l);
                }
                byte[] byArray = new String(cArray, 0, n2).getBytes(StandardCharsets.UTF_8);
                if (byArray.length > this.database.getMaxLengthInplaceLob()) {
                    throw new IllegalStateException("len > maxinplace, " + byArray.length + " > " + this.database.getMaxLengthInplaceLob());
                }
                return ValueLobDb.createSmallLob(n, byArray);
            }
            if (l < 0L) {
                l = Long.MAX_VALUE;
            }
            CountingReaderInputStream countingReaderInputStream = new CountingReaderInputStream(reader, l);
            ValueLobDb valueLobDb = this.createLob(countingReaderInputStream, n);
            valueLobDb = ValueLobDb.create(n, this.database, valueLobDb.getTableId(), valueLobDb.getLobId(), null, countingReaderInputStream.getLength());
            return valueLobDb;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private ValueLobDb createLob(InputStream inputStream2, int n) throws IOException {
        byte[] byArray;
        try {
            byArray = this.streamStore.put(inputStream2);
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        long l = this.generateLobId();
        long l2 = this.streamStore.length(byArray);
        int n2 = -2;
        Object[] objectArray = new Object[]{byArray, n2, l2, 0};
        this.lobMap.put(l, objectArray);
        Object[] objectArray2 = new Object[]{byArray, l};
        this.refMap.put(objectArray2, Boolean.TRUE);
        ValueLobDb valueLobDb = ValueLobDb.create(n, this.database, n2, l, null, l2);
        return valueLobDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateLobId() {
        Object object = this.nextLobIdSync;
        synchronized (object) {
            if (this.nextLobId == 0L) {
                Long l = this.lobMap.lastKey();
                this.nextLobId = l == null ? 1L : l + 1L;
            }
            return this.nextLobId++;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb valueLobDb, int n, long l) {
        this.init();
        int n2 = valueLobDb.getValueType();
        long l2 = valueLobDb.getLobId();
        long l3 = valueLobDb.getType().getPrecision();
        if (l3 != l) {
            throw DbException.throwInternalError("Length is different");
        }
        Object[] objectArray = this.lobMap.get(l2);
        objectArray = (Object[])objectArray.clone();
        byte[] byArray = (byte[])objectArray[0];
        long l4 = this.generateLobId();
        objectArray[1] = n;
        this.lobMap.put(l4, objectArray);
        Object[] objectArray2 = new Object[]{byArray, l4};
        this.refMap.put(objectArray2, Boolean.TRUE);
        ValueLobDb valueLobDb2 = ValueLobDb.create(n2, this.database, n, l4, null, l);
        return valueLobDb2;
    }

    @Override
    public InputStream getInputStream(ValueLobDb valueLobDb, byte[] byArray, long l) throws IOException {
        this.init();
        Object[] objectArray = this.lobMap.get(valueLobDb.getLobId());
        if (objectArray == null) {
            if (valueLobDb.getTableId() == -3 || valueLobDb.getTableId() == -1) {
                throw DbException.get(90039, valueLobDb.getLobId() + "/" + valueLobDb.getTableId());
            }
            throw DbException.throwInternalError("Lob not found: " + valueLobDb.getLobId() + "/" + valueLobDb.getTableId());
        }
        byte[] byArray2 = (byte[])objectArray[0];
        return this.streamStore.get(byArray2);
    }

    @Override
    public void removeAllForTable(int n) {
        this.init();
        if (this.database.getStore().getMvStore().isClosed()) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Map.Entry<Long, Object[]> entry : this.lobMap.entrySet()) {
            Object[] objectArray = entry.getValue();
            int n2 = (Integer)objectArray[1];
            if (n2 != n) continue;
            arrayList.add(entry.getKey());
        }
        Iterator<Map.Entry<Long, Object>> iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            long l = (Long)((Object)iterator2.next());
            this.removeLob(n, l);
        }
        if (n == -1) {
            this.removeAllForTable(-2);
            this.removeAllForTable(-3);
        }
    }

    @Override
    public void removeLob(ValueLobDb valueLobDb) {
        this.init();
        int n = valueLobDb.getTableId();
        long l = valueLobDb.getLobId();
        this.removeLob(n, l);
    }

    private void removeLob(int n, long l) {
        byte[] byArray;
        Object[] objectArray = this.lobMap.remove(l);
        if (objectArray == null) {
            return;
        }
        byte[] byArray2 = (byte[])objectArray[0];
        Object[] objectArray2 = new Object[]{byArray2, l};
        this.refMap.remove(objectArray2);
        objectArray2 = new Object[]{byArray2, 0L};
        objectArray = this.refMap.ceilingKey(objectArray2);
        boolean bl = false;
        if (objectArray != null && Arrays.equals(byArray2, byArray = (byte[])objectArray[0])) {
            bl = true;
        }
        if (!bl) {
            this.streamStore.remove(byArray2);
        }
    }

    private static void trace(String string2) {
        System.out.println("[" + Thread.currentThread().getName() + "] LOB " + string2);
    }
}

