/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.rtree;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.mvstore.type.DataType;

public class SpatialDataType
implements DataType {
    private final int dimensions;

    public SpatialDataType(int n) {
        DataUtils.checkArgument(n >= 1 && n < 32, "Dimensions must be between 1 and 31, is {0}", n);
        this.dimensions = n;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        long l = ((SpatialKey)object).getId();
        long l2 = ((SpatialKey)object2).getId();
        return Long.compare(l, l2);
    }

    public boolean equals(Object object, Object object2) {
        long l;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        long l2 = ((SpatialKey)object).getId();
        return l2 == (l = ((SpatialKey)object2).getId());
    }

    @Override
    public int getMemory(Object object) {
        return 40 + this.dimensions * 4;
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
        for (int j = 0; j < n; ++j) {
            objectArray[j] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
        for (int j = 0; j < n; ++j) {
            this.write(writeBuffer, objectArray[j]);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        int n;
        SpatialKey spatialKey = (SpatialKey)object;
        if (spatialKey.isNull()) {
            writeBuffer.putVarInt(-1);
            writeBuffer.putVarLong(spatialKey.getId());
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.dimensions; ++n) {
            if (spatialKey.min(n) != spatialKey.max(n)) continue;
            n2 |= 1 << n;
        }
        writeBuffer.putVarInt(n2);
        for (n = 0; n < this.dimensions; ++n) {
            writeBuffer.putFloat(spatialKey.min(n));
            if ((n2 & 1 << n) != 0) continue;
            writeBuffer.putFloat(spatialKey.max(n));
        }
        writeBuffer.putVarLong(spatialKey.getId());
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        int n = DataUtils.readVarInt(byteBuffer);
        if (n == -1) {
            long l = DataUtils.readVarLong(byteBuffer);
            return new SpatialKey(l, new float[0]);
        }
        float[] fArray = new float[this.dimensions * 2];
        for (int j = 0; j < this.dimensions; ++j) {
            float f = byteBuffer.getFloat();
            float f2 = (n & 1 << j) != 0 ? f : byteBuffer.getFloat();
            fArray[j + j] = f;
            fArray[j + j + 1] = f2;
        }
        long l = DataUtils.readVarLong(byteBuffer);
        return new SpatialKey(l, fArray);
    }

    public boolean isOverlap(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return false;
        }
        for (int j = 0; j < this.dimensions; ++j) {
            if (!(spatialKey.max(j) < spatialKey2.min(j)) && !(spatialKey.min(j) > spatialKey2.max(j))) continue;
            return false;
        }
        return true;
    }

    public void increaseBounds(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object2;
        SpatialKey spatialKey2 = (SpatialKey)object;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return;
        }
        for (int j = 0; j < this.dimensions; ++j) {
            float f = spatialKey.min(j);
            if (f < spatialKey2.min(j)) {
                spatialKey2.setMin(j, f);
            }
            if (!((f = spatialKey.max(j)) > spatialKey2.max(j))) continue;
            spatialKey2.setMax(j, f);
        }
    }

    public float getAreaIncrease(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object2;
        SpatialKey spatialKey2 = (SpatialKey)object;
        if (spatialKey2.isNull() || spatialKey.isNull()) {
            return 0.0f;
        }
        float f = spatialKey2.min(0);
        float f2 = spatialKey2.max(0);
        float f3 = f2 - f;
        f = Math.min(f, spatialKey.min(0));
        f2 = Math.max(f2, spatialKey.max(0));
        float f4 = f2 - f;
        for (int j = 1; j < this.dimensions; ++j) {
            f = spatialKey2.min(j);
            f2 = spatialKey2.max(j);
            f3 *= f2 - f;
            f = Math.min(f, spatialKey.min(j));
            f2 = Math.max(f2, spatialKey.max(j));
            f4 *= f2 - f;
        }
        return f4 - f3;
    }

    float getCombinedArea(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull()) {
            return this.getArea(spatialKey2);
        }
        if (spatialKey2.isNull()) {
            return this.getArea(spatialKey);
        }
        float f = 1.0f;
        for (int j = 0; j < this.dimensions; ++j) {
            float f2 = Math.min(spatialKey.min(j), spatialKey2.min(j));
            float f3 = Math.max(spatialKey.max(j), spatialKey2.max(j));
            f *= f3 - f2;
        }
        return f;
    }

    private float getArea(SpatialKey spatialKey) {
        if (spatialKey.isNull()) {
            return 0.0f;
        }
        float f = 1.0f;
        for (int j = 0; j < this.dimensions; ++j) {
            f *= spatialKey.max(j) - spatialKey.min(j);
        }
        return f;
    }

    public boolean contains(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return false;
        }
        for (int j = 0; j < this.dimensions; ++j) {
            if (!(spatialKey.min(j) > spatialKey2.min(j)) && !(spatialKey.max(j) < spatialKey2.max(j))) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        if (spatialKey.isNull() || spatialKey2.isNull()) {
            return false;
        }
        for (int j = 0; j < this.dimensions; ++j) {
            if (!(spatialKey.min(j) <= spatialKey2.min(j)) && !(spatialKey.max(j) >= spatialKey2.max(j))) continue;
            return false;
        }
        return true;
    }

    Object createBoundingBox(Object object) {
        SpatialKey spatialKey = (SpatialKey)object;
        if (spatialKey.isNull()) {
            return spatialKey;
        }
        return new SpatialKey(0L, spatialKey);
    }

    public int[] getExtremes(ArrayList<Object> arrayList) {
        float f;
        if ((arrayList = SpatialDataType.getNotNull(arrayList)).isEmpty()) {
            return null;
        }
        SpatialKey spatialKey = (SpatialKey)this.createBoundingBox(arrayList.get(0));
        SpatialKey spatialKey2 = (SpatialKey)this.createBoundingBox(spatialKey);
        for (int j = 0; j < this.dimensions; ++j) {
            float f2 = spatialKey2.min(j);
            spatialKey2.setMin(j, spatialKey2.max(j));
            spatialKey2.setMax(j, f2);
        }
        for (Object object : arrayList) {
            this.increaseBounds(spatialKey, object);
            this.increaseMaxInnerBounds(spatialKey2, object);
        }
        double d = 0.0;
        int n = 0;
        for (int j = 0; j < this.dimensions; ++j) {
            float f3;
            float f4;
            f = spatialKey2.max(j) - spatialKey2.min(j);
            if (f < 0.0f || !((double)(f4 = f / (f3 = spatialKey.max(j) - spatialKey.min(j))) > d)) continue;
            d = f4;
            n = j;
        }
        if (d <= 0.0) {
            return null;
        }
        float f5 = spatialKey2.min(n);
        f = spatialKey2.max(n);
        int n2 = -1;
        int n3 = -1;
        for (int j = 0; j < arrayList.size() && (n2 < 0 || n3 < 0); ++j) {
            SpatialKey spatialKey3 = (SpatialKey)arrayList.get(j);
            if (n2 < 0 && spatialKey3.max(n) == f5) {
                n2 = j;
                continue;
            }
            if (n3 >= 0 || spatialKey3.min(n) != f) continue;
            n3 = j;
        }
        return new int[]{n2, n3};
    }

    private static ArrayList<Object> getNotNull(ArrayList<Object> arrayList) {
        boolean bl = false;
        for (Object iterator2 : arrayList) {
            Object object = (SpatialKey)iterator2;
            if (!((SpatialKey)object).isNull()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return arrayList;
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object : arrayList) {
            SpatialKey spatialKey = (SpatialKey)object;
            if (spatialKey.isNull()) continue;
            arrayList2.add(spatialKey);
        }
        return arrayList2;
    }

    private void increaseMaxInnerBounds(Object object, Object object2) {
        SpatialKey spatialKey = (SpatialKey)object;
        SpatialKey spatialKey2 = (SpatialKey)object2;
        for (int j = 0; j < this.dimensions; ++j) {
            spatialKey.setMin(j, Math.min(spatialKey.min(j), spatialKey2.max(j)));
            spatialKey.setMax(j, Math.max(spatialKey.max(j), spatialKey2.min(j)));
        }
    }
}

