/*
 * Decompiled with CFR 0.152.
 */
package org.h2.pagestore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import org.h2.compress.CompressLZF;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.pagestore.Page;
import org.h2.pagestore.PageInputStream;
import org.h2.pagestore.PageOutputStream;
import org.h2.pagestore.PageStore;
import org.h2.pagestore.PageStoreInDoubtTransaction;
import org.h2.pagestore.PageStreamData;
import org.h2.pagestore.PageStreamTrunk;
import org.h2.pagestore.SessionState;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.store.InDoubtTransaction;
import org.h2.util.IntArray;
import org.h2.util.IntIntHashMap;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class PageLog {
    public static final int NOOP = 0;
    public static final int UNDO = 1;
    public static final int COMMIT = 2;
    public static final int PREPARE_COMMIT = 3;
    public static final int ROLLBACK = 4;
    public static final int ADD = 5;
    public static final int REMOVE = 6;
    public static final int TRUNCATE = 7;
    public static final int CHECKPOINT = 8;
    public static final int FREE_LOG = 9;
    static final int RECOVERY_STAGE_UNDO = 0;
    static final int RECOVERY_STAGE_ALLOCATE = 1;
    static final int RECOVERY_STAGE_REDO = 2;
    private static final boolean COMPRESS_UNDO = true;
    private final PageStore store;
    private final Trace trace;
    private Data writeBuffer;
    private PageOutputStream pageOut;
    private int firstTrunkPage;
    private int firstDataPage;
    private final Data dataBuffer;
    private int logKey;
    private int logSectionId;
    private int logPos;
    private int firstSectionId;
    private final CompressLZF compress;
    private final byte[] compressBuffer;
    private BitSet undo = new BitSet();
    private final BitSet undoAll = new BitSet();
    private final IntIntHashMap logSectionPageMap = new IntIntHashMap();
    private HashMap<Integer, SessionState> sessionStates = new HashMap();
    private BitSet usedLogPages;
    private boolean freeing;

    PageLog(PageStore pageStore) {
        this.store = pageStore;
        this.dataBuffer = pageStore.createData();
        this.trace = pageStore.getTrace();
        this.compress = new CompressLZF();
        this.compressBuffer = new byte[pageStore.getPageSize() * 2];
    }

    void openForWriting(int n, boolean bl) {
        this.trace.debug("log openForWriting firstPage: " + n);
        this.firstTrunkPage = n;
        ++this.logKey;
        this.pageOut = new PageOutputStream(this.store, n, this.undoAll, this.logKey, bl);
        this.pageOut.reserve(1);
        this.store.setLogFirstPage(this.logKey, n, this.pageOut.getCurrentDataPageId());
        this.writeBuffer = this.store.createData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log free");
        }
        int n = 0;
        if (this.pageOut != null) {
            n = this.pageOut.getCurrentDataPageId();
            this.pageOut.freeReserved();
        }
        try {
            this.freeing = true;
            int n2 = 0;
            int n3 = 1024;
            int n4 = 0;
            PageStreamTrunk.Iterator iterator2 = new PageStreamTrunk.Iterator(this.store, this.firstTrunkPage);
            while (this.firstTrunkPage != 0 && this.firstTrunkPage < this.store.getPageCount()) {
                PageStreamTrunk pageStreamTrunk = iterator2.next();
                if (pageStreamTrunk == null) {
                    if (iterator2.canDelete()) {
                        this.store.free(this.firstTrunkPage, false);
                    }
                    break;
                }
                if (n4++ >= n3) {
                    n2 = pageStreamTrunk.getPos();
                    n4 = 0;
                    n3 *= 2;
                } else if (n2 != 0 && n2 == pageStreamTrunk.getPos()) {
                    throw DbException.throwInternalError("endless loop at " + pageStreamTrunk);
                }
                pageStreamTrunk.free(n);
                this.firstTrunkPage = pageStreamTrunk.getNextTrunk();
            }
        }
        finally {
            this.freeing = false;
        }
    }

    void openForReading(int n, int n2, int n3) {
        this.logKey = n;
        this.firstTrunkPage = n2;
        this.firstDataPage = n3;
    }

    boolean recover(int n) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log recover stage: " + n);
        }
        if (n == 1) {
            PageInputStream pageInputStream = new PageInputStream(this.store, this.logKey, this.firstTrunkPage, this.firstDataPage);
            this.usedLogPages = pageInputStream.allocateAllPages();
            pageInputStream.close();
            return true;
        }
        PageInputStream pageInputStream = new PageInputStream(this.store, this.logKey, this.firstTrunkPage, this.firstDataPage);
        DataReader dataReader = new DataReader(pageInputStream);
        int n2 = 0;
        Data data2 = this.store.createData();
        boolean bl = true;
        try {
            byte by;
            int n3 = 0;
            while ((by = dataReader.readByte()) >= 0) {
                int n4;
                ++n3;
                bl = false;
                if (by == 1) {
                    n4 = dataReader.readVarInt();
                    int n5 = dataReader.readVarInt();
                    if (n5 == 0) {
                        dataReader.readFully(data2.getBytes(), this.store.getPageSize());
                    } else if (n5 == 1) {
                        Arrays.fill(data2.getBytes(), 0, this.store.getPageSize(), (byte)0);
                    } else {
                        dataReader.readFully(this.compressBuffer, n5);
                        try {
                            this.compress.expand(this.compressBuffer, 0, n5, data2.getBytes(), 0, this.store.getPageSize());
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            DbException.convertToIOException(arrayIndexOutOfBoundsException);
                        }
                    }
                    if (n != 0) continue;
                    if (!this.undo.get(n4)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log undo {0}", n4);
                        }
                        this.store.writePage(n4, data2);
                        this.undo.set(n4);
                        this.undoAll.set(n4);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log undo skip {0}", n4);
                    continue;
                }
                if (by == 5) {
                    n4 = dataReader.readVarInt();
                    int n6 = dataReader.readVarInt();
                    Row row2 = PageLog.readRow(this.store.getDatabase().getRowFactory(), dataReader, data2);
                    if (n == 0) {
                        this.store.allocateIfIndexRoot(n3, n6, row2);
                        continue;
                    }
                    if (n != 2) continue;
                    if (this.isSessionCommitted(n4, n2, n3)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo + table: " + n6 + " s: " + n4 + " " + row2);
                        }
                        this.store.redo(n6, row2, true);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s: " + n4 + " + table: " + n6 + " " + row2);
                    continue;
                }
                if (by == 6) {
                    n4 = dataReader.readVarInt();
                    int n7 = dataReader.readVarInt();
                    long l = dataReader.readVarLong();
                    if (n != 2) continue;
                    if (this.isSessionCommitted(n4, n2, n3)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo - table: " + n7 + " s:" + n4 + " key: " + l);
                        }
                        this.store.redoDelete(n7, l);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s: " + n4 + " - table: " + n7 + " " + l);
                    continue;
                }
                if (by == 7) {
                    n4 = dataReader.readVarInt();
                    int n8 = dataReader.readVarInt();
                    if (n != 2) continue;
                    if (this.isSessionCommitted(n4, n2, n3)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo truncate table: " + n8);
                        }
                        this.store.redoTruncate(n8);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s: " + n4 + " truncate table: " + n8);
                    continue;
                }
                if (by == 3) {
                    n4 = dataReader.readVarInt();
                    String string2 = dataReader.readString();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log prepare commit " + n4 + " " + string2 + " pos: " + n3);
                    }
                    if (n != 0) continue;
                    int n9 = pageInputStream.getDataPage();
                    this.setPrepareCommit(n4, n9, string2);
                    continue;
                }
                if (by == 4) {
                    n4 = dataReader.readVarInt();
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log rollback " + n4 + " pos: " + n3);
                    continue;
                }
                if (by == 2) {
                    n4 = dataReader.readVarInt();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log commit " + n4 + " pos: " + n3);
                    }
                    if (n != 0) continue;
                    this.setLastCommitForSession(n4, n2, n3);
                    continue;
                }
                if (by == 0) continue;
                if (by == 8) {
                    ++n2;
                    continue;
                }
                if (by == 9) {
                    n4 = dataReader.readVarInt();
                    for (int j = 0; j < n4; ++j) {
                        int n10 = dataReader.readVarInt();
                        if (n != 2 || this.usedLogPages.get(n10)) continue;
                        this.store.free(n10, false);
                    }
                    continue;
                }
                if (!this.trace.isDebugEnabled()) continue;
                this.trace.debug("log end");
                break;
            }
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 90030) {
                this.trace.debug("log recovery stopped");
            }
            throw dbException;
        }
        catch (IOException iOException) {
            this.trace.debug("log recovery completed");
        }
        this.undo = new BitSet();
        if (n == 2) {
            this.usedLogPages = null;
        }
        return bl;
    }

    private void setPrepareCommit(int n, int n2, String string2) {
        SessionState sessionState = this.getOrAddSessionState(n);
        PageStoreInDoubtTransaction pageStoreInDoubtTransaction = string2 == null ? null : new PageStoreInDoubtTransaction(this.store, n, n2, string2);
        sessionState.inDoubtTransaction = pageStoreInDoubtTransaction;
    }

    public static Row readRow(RowFactory rowFactory, DataReader dataReader, Data data2) throws IOException {
        long l = dataReader.readVarLong();
        int n = dataReader.readVarInt();
        data2.reset();
        data2.checkCapacity(n);
        dataReader.readFully(data2.getBytes(), n);
        int n2 = data2.readVarInt();
        Value[] valueArray = new Value[n2];
        for (int j = 0; j < n2; ++j) {
            valueArray[j] = data2.readValue();
        }
        Row row2 = rowFactory.createRow(valueArray, -1);
        row2.setKey(l);
        return row2;
    }

    boolean getUndo(int n) {
        return this.undo.get(n);
    }

    void addUndo(int n, Data data2) {
        if (this.undo.get(n) || this.freeing) {
            return;
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log undo " + n);
        }
        if (data2 == null) {
            DbException.throwInternalError("Undo entry not written");
        }
        this.undo.set(n);
        this.undoAll.set(n);
        Data data3 = this.getBuffer();
        data3.writeByte((byte)1);
        data3.writeVarInt(n);
        if (data2.getBytes()[0] == 0) {
            data3.writeVarInt(1);
        } else {
            int n2 = this.store.getPageSize();
            int n3 = this.compress.compress(data2.getBytes(), n2, this.compressBuffer, 0);
            if (n3 < n2) {
                data3.writeVarInt(n3);
                data3.checkCapacity(n3);
                data3.write(this.compressBuffer, 0, n3);
            } else {
                data3.writeVarInt(0);
                data3.checkCapacity(n2);
                data3.write(data2.getBytes(), 0, n2);
            }
        }
        this.write(data3);
    }

    private void freeLogPages(IntArray intArray) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log frees " + intArray.get(0) + ".." + intArray.get(intArray.size() - 1));
        }
        Data data2 = this.getBuffer();
        data2.writeByte((byte)9);
        int n = intArray.size();
        data2.writeVarInt(n);
        for (int j = 0; j < n; ++j) {
            data2.writeVarInt(intArray.get(j));
        }
        this.write(data2);
    }

    private void write(Data data2) {
        this.pageOut.write(data2.getBytes(), 0, data2.length());
        data2.reset();
    }

    void commit(int n) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log commit s: " + n);
        }
        if (this.store.getDatabase().getPageStore() == null) {
            return;
        }
        Data data2 = this.getBuffer();
        data2.writeByte((byte)2);
        data2.writeVarInt(n);
        this.write(data2);
        if (this.store.getDatabase().getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void prepareCommit(Session session, String string2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log prepare commit s: " + session.getId() + ", " + string2);
        }
        if (this.store.getDatabase().getPageStore() == null) {
            return;
        }
        int n = this.store.getPageSize();
        this.pageOut.flush();
        this.pageOut.fillPage();
        Data data2 = this.getBuffer();
        data2.writeByte((byte)3);
        data2.writeVarInt(session.getId());
        data2.writeString(string2);
        if (data2.length() >= PageStreamData.getCapacity(n)) {
            throw DbException.getInvalidValueException("transaction name (too long)", string2);
        }
        this.write(data2);
        this.flushOut();
        this.pageOut.fillPage();
        if (this.store.getDatabase().getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void logAddOrRemoveRow(Session session, int n, Row row2, boolean bl) {
        int n2;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log " + (bl ? "+" : "-") + " s: " + session.getId() + " table: " + n + " row: " + row2);
        }
        session.addLogPos(this.logSectionId, this.logPos);
        ++this.logPos;
        Data data2 = this.dataBuffer;
        data2.reset();
        int n3 = row2.getColumnCount();
        data2.writeVarInt(n3);
        data2.checkCapacity(row2.getByteCount(data2));
        if (session.isRedoLogBinaryEnabled()) {
            for (n2 = 0; n2 < n3; ++n2) {
                data2.writeValue(row2.getValue(n2));
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                Value value = row2.getValue(n2);
                if (value.getValueType() == 12) {
                    data2.writeValue(ValueNull.INSTANCE);
                    continue;
                }
                data2.writeValue(value);
            }
        }
        Data data3 = this.getBuffer();
        data3.writeByte((byte)(bl ? 5 : 6));
        data3.writeVarInt(session.getId());
        data3.writeVarInt(n);
        data3.writeVarLong(row2.getKey());
        if (bl) {
            data3.writeVarInt(data2.length());
            data3.checkCapacity(data2.length());
            data3.write(data2.getBytes(), 0, data2.length());
        }
        this.write(data3);
    }

    void logTruncate(Session session, int n) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log truncate s: " + session.getId() + " table: " + n);
        }
        session.addLogPos(this.logSectionId, this.logPos);
        ++this.logPos;
        Data data2 = this.getBuffer();
        data2.writeByte((byte)7);
        data2.writeVarInt(session.getId());
        data2.writeVarInt(n);
        this.write(data2);
    }

    void flush() {
        if (this.pageOut != null) {
            this.flushOut();
        }
    }

    void checkpoint() {
        Data data2 = this.getBuffer();
        data2.writeByte((byte)8);
        this.write(data2);
        this.undo = new BitSet();
        ++this.logSectionId;
        this.logPos = 0;
        this.pageOut.flush();
        this.pageOut.fillPage();
        int n = this.pageOut.getCurrentDataPageId();
        this.logSectionPageMap.put(this.logSectionId, n);
    }

    int getLogSectionId() {
        return this.logSectionId;
    }

    int getLogFirstSectionId() {
        return this.firstSectionId;
    }

    int getLogPos() {
        return this.logPos;
    }

    void removeUntil(int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.logSectionPageMap.get(n);
        this.firstTrunkPage = this.removeUntil(this.firstTrunkPage, n2);
        this.store.setLogFirstPage(this.logKey, this.firstTrunkPage, n2);
        while (this.firstSectionId < n) {
            if (this.firstSectionId > 0) {
                this.logSectionPageMap.remove(this.firstSectionId);
            }
            ++this.firstSectionId;
        }
    }

    private int removeUntil(int n, int n2) {
        this.trace.debug("log.removeUntil " + n + " " + n2);
        int n3 = n;
        while (true) {
            int n4;
            Page page;
            PageStreamTrunk pageStreamTrunk;
            if ((pageStreamTrunk = (PageStreamTrunk)(page = this.store.getPage(n))) == null) {
                throw DbException.throwInternalError("log.removeUntil not found: " + n2 + " last " + n3);
            }
            this.logKey = pageStreamTrunk.getLogKey();
            n3 = pageStreamTrunk.getPos();
            if (pageStreamTrunk.contains(n2)) {
                return n3;
            }
            n = pageStreamTrunk.getNextTrunk();
            IntArray intArray = new IntArray();
            intArray.add(pageStreamTrunk.getPos());
            int n5 = 0;
            while ((n4 = pageStreamTrunk.getPageData(n5)) != -1) {
                intArray.add(n4);
                ++n5;
            }
            this.freeLogPages(intArray);
            this.pageOut.free(pageStreamTrunk);
        }
    }

    void close() {
        this.trace.debug("log close");
        if (this.pageOut != null) {
            this.pageOut.close();
            this.pageOut = null;
        }
        this.writeBuffer = null;
    }

    private boolean isSessionCommitted(int n, int n2, int n3) {
        SessionState sessionState = this.sessionStates.get(n);
        if (sessionState == null) {
            return false;
        }
        return sessionState.isCommitted(n2, n3);
    }

    private void setLastCommitForSession(int n, int n2, int n3) {
        SessionState sessionState = this.getOrAddSessionState(n);
        sessionState.lastCommitLog = n2;
        sessionState.lastCommitPos = n3;
        sessionState.inDoubtTransaction = null;
    }

    private SessionState getOrAddSessionState(int n) {
        Integer n2 = n;
        SessionState sessionState = this.sessionStates.get(n2);
        if (sessionState == null) {
            sessionState = new SessionState();
            this.sessionStates.put(n2, sessionState);
            sessionState.sessionId = n;
        }
        return sessionState;
    }

    long getSize() {
        return this.pageOut == null ? 0L : this.pageOut.getSize();
    }

    ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        ArrayList<InDoubtTransaction> arrayList = Utils.newSmallArrayList();
        for (SessionState sessionState : this.sessionStates.values()) {
            PageStoreInDoubtTransaction pageStoreInDoubtTransaction = sessionState.inDoubtTransaction;
            if (pageStoreInDoubtTransaction == null) continue;
            arrayList.add(pageStoreInDoubtTransaction);
        }
        return arrayList;
    }

    void setInDoubtTransactionState(int n, int n2, boolean bl) {
        PageStreamData pageStreamData = (PageStreamData)this.store.getPage(n2);
        pageStreamData.initWrite();
        Data data2 = this.store.createData();
        data2.writeByte((byte)(bl ? 2 : 4));
        data2.writeVarInt(n);
        byte[] byArray = data2.getBytes();
        pageStreamData.write(byArray, 0, byArray.length);
        byArray = new byte[pageStreamData.getRemaining()];
        pageStreamData.write(byArray, 0, byArray.length);
        pageStreamData.write();
    }

    void recoverEnd() {
        this.sessionStates = new HashMap();
    }

    private void flushOut() {
        this.pageOut.flush();
    }

    private Data getBuffer() {
        if (this.writeBuffer.length() == 0) {
            return this.writeBuffer;
        }
        return this.store.createData();
    }

    int getMinPageId() {
        return this.pageOut == null ? 0 : this.pageOut.getMinPageId();
    }
}

