/*
 * Decompiled with CFR 0.152.
 */
package org.h2.pagestore.db;

import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.pagestore.Page;
import org.h2.pagestore.PageStore;
import org.h2.pagestore.db.PageData;
import org.h2.pagestore.db.PageDataLeaf;
import org.h2.pagestore.db.PageDataNode;
import org.h2.pagestore.db.PageDataOverflow;
import org.h2.pagestore.db.PageIndex;
import org.h2.pagestore.db.PageStoreTable;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class PageDataIndex
extends PageIndex {
    private final PageStore store;
    private final PageStoreTable tableData;
    private long lastKey;
    private long rowCount;
    private int mainIndexColumn = -1;
    private DbException fastDuplicateKeyException;
    private int memoryPerPage;
    private int memoryCount;

    public PageDataIndex(PageStoreTable pageStoreTable, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, Session session) {
        super(pageStoreTable, n, pageStoreTable.getName() + "_DATA", indexColumnArray, indexType);
        this.tableData = pageStoreTable;
        this.store = this.database.getPageStore();
        this.store.addIndex(this);
        if (!this.database.isPersistent()) {
            throw DbException.throwInternalError(pageStoreTable.getName());
        }
        if (bl) {
            this.rootPageId = this.store.allocatePage();
            this.store.addMeta(this, session);
            PageDataLeaf pageDataLeaf = PageDataLeaf.create(this, this.rootPageId, 0);
            this.store.update(pageDataLeaf);
        } else {
            this.rootPageId = this.store.getRootPageId(n);
            PageData pageData = this.getPage(this.rootPageId, 0);
            this.lastKey = pageData.getLastKey();
            this.rowCount = pageData.getRowCount();
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} opened rows: {1}", this, this.rowCount);
        }
        pageStoreTable.setRowCount(this.rowCount);
        this.memoryPerPage = 240 + this.store.getPageSize() >> 2;
    }

    @Override
    public DbException getDuplicateKeyException(String string2) {
        if (this.fastDuplicateKeyException == null) {
            this.fastDuplicateKeyException = super.getDuplicateKeyException(null);
        }
        return this.fastDuplicateKeyException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, Row row2) {
        boolean bl = false;
        if (this.mainIndexColumn != -1) {
            row2.setKey(row2.getValue(this.mainIndexColumn).getLong());
        } else if (row2.getKey() == 0L) {
            row2.setKey((int)(++this.lastKey));
            bl = true;
        }
        if (this.tableData.getContainsLargeObject()) {
            int n = row2.getColumnCount();
            for (int j = 0; j < n; ++j) {
                Value value = row2.getValue(j);
                Value value2 = value.copy(this.database, this.getId());
                if (value2.isLinkedToTable()) {
                    session.removeAtCommitStop(value2);
                }
                if (value == value2) continue;
                row2.setValue(j, value2);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} add {1}", this.getName(), row2);
        }
        long l = 0L;
        while (true) {
            try {
                this.addTry(session, row2);
            }
            catch (DbException dbException) {
                if (dbException != this.fastDuplicateKeyException) {
                    throw dbException;
                }
                if (!bl) {
                    DbException dbException2 = DbException.get(23505, this.getDuplicatePrimaryKeyMessage(this.mainIndexColumn).toString());
                    dbException2.setSource(this);
                    throw dbException2;
                }
                if (l == 0L) {
                    row2.setKey((long)((double)row2.getKey() + Math.random() * 10000.0));
                } else {
                    row2.setKey(row2.getKey() + l);
                }
                ++l;
                continue;
            }
            finally {
                this.store.incrementChangeCount();
                continue;
            }
            break;
        }
        this.lastKey = Math.max(this.lastKey, row2.getKey());
    }

    private void addTry(Session session, Row row2) {
        PageData pageData;
        int n;
        while ((n = (pageData = this.getPage(this.rootPageId, 0)).addRowTry(row2)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("{0} split", this);
            }
            long l = n == 0 ? row2.getKey() : pageData.getKey(n - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n2 = this.store.allocatePage();
            pageData2.setPageId(n2);
            pageData2.setParentPageId(this.rootPageId);
            pageData3.setParentPageId(this.rootPageId);
            PageDataNode pageDataNode = PageDataNode.create(this, this.rootPageId, 0);
            pageDataNode.init(pageData2, l, pageData3);
            this.store.update(pageData2);
            this.store.update(pageData3);
            this.store.update(pageDataNode);
            pageData = pageDataNode;
        }
        row2.setDeleted(false);
        this.invalidateRowCount();
        ++this.rowCount;
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row2, true);
    }

    PageDataOverflow getPageOverflow(int n) {
        Page page = this.store.getPage(n);
        if (page instanceof PageDataOverflow) {
            return (PageDataOverflow)page;
        }
        throw DbException.get(90030, page == null ? "null" : page.toString());
    }

    PageData getPage(int n, int n2) {
        Page page = this.store.getPage(n);
        if (page == null) {
            PageDataLeaf pageDataLeaf = PageDataLeaf.create(this, n, n2);
            this.store.logUndo(pageDataLeaf, null);
            this.store.update(pageDataLeaf);
            return pageDataLeaf;
        }
        if (!(page instanceof PageData)) {
            throw DbException.get(90030, String.valueOf(page));
        }
        PageData pageData = (PageData)page;
        if (n2 != -1 && pageData.getParentPageId() != n2) {
            throw DbException.throwInternalError(pageData + " parent " + pageData.getParentPageId() + " expected " + n2);
        }
        return pageData;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    long getKey(SearchRow searchRow, long l, long l2) {
        if (searchRow == null) {
            return l;
        }
        Value value = searchRow.getValue(this.mainIndexColumn);
        if (value == null) {
            return searchRow.getKey();
        }
        if (value == ValueNull.INSTANCE) {
            return l2;
        }
        return value.getLong();
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l = searchRow == null ? Long.MIN_VALUE : searchRow.getKey();
        long l2 = searchRow2 == null ? Long.MAX_VALUE : searchRow2.getKey();
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, l, l2);
    }

    Cursor find(Session session, long l, long l2) {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.find(session, l, l2);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.throwInternalError(this.toString());
    }

    long getLastKey() {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getLastKey();
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return 10L * (this.tableData.getRowCountApproximation() + 1000L) + 200L;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, Row row2) {
        Object object;
        if (this.tableData.getContainsLargeObject()) {
            int n = row2.getColumnCount();
            for (int j = 0; j < n; ++j) {
                object = row2.getValue(j);
                if (!((Value)object).isLinkedToTable()) continue;
                session.removeAtCommit((Value)object);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove {1}", this.getName(), row2);
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            try {
                long l = row2.getKey();
                object = this.getPage(this.rootPageId, 0);
                ((PageData)object).remove(l);
                this.invalidateRowCount();
                --this.rowCount;
            }
            finally {
                this.store.incrementChangeCount();
            }
        }
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row2, false);
    }

    @Override
    public void remove(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove", this);
        }
        this.removeAllRows();
        this.store.free(this.rootPageId);
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} truncate", this);
        }
        this.store.logTruncate(session, this.tableData.getId());
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            session.commit(false);
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllRows() {
        try {
            PageData pageData = this.getPage(this.rootPageId, 0);
            pageData.freeRecursive();
            pageData = PageDataLeaf.create(this, this.rootPageId, 0);
            this.store.removeFromCache(this.rootPageId);
            this.store.update(pageData);
            this.rowCount = 0L;
            this.lastKey = 0L;
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("PAGE");
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.getRowWithKey(l);
    }

    public Row getRowWithKey(long l) {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getRowWithKey(l);
    }

    PageStore getPageStore() {
        return this.store;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        PageData pageData = this.getPage(this.rootPageId, 0);
        return pageData.getDiskSpaceUsed();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public int getColumnIndex(Column column2) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column2) {
        return false;
    }

    @Override
    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} close", this);
        }
        this.writeRowCount();
    }

    void setRootPageId(Session session, int n) {
        this.store.removeMeta(this, session);
        this.rootPageId = n;
        this.store.addMeta(this, session);
        this.store.addIndex(this);
    }

    public void setMainIndexColumn(int n) {
        this.mainIndexColumn = n;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void invalidateRowCount() {
        PageData pageData = this.getPage(this.rootPageId, 0);
        pageData.setRowCountStored(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRowCount() {
        if (SysProperties.MODIFY_ON_WRITE && this.rootPageId == 0) {
            return;
        }
        try {
            PageData pageData = this.getPage(this.rootPageId, 0);
            pageData.setRowCountStored(MathUtils.convertLongToInt(this.rowCount));
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), false).append(".tableScan").toString();
    }

    int getMemoryPerPage() {
        return this.memoryPerPage;
    }

    void memoryChange(int n) {
        this.memoryPerPage = this.memoryCount < 64 ? (this.memoryPerPage += (n - this.memoryPerPage) / ++this.memoryCount) : (this.memoryPerPage += (n > this.memoryPerPage ? 1 : -1) + (n - this.memoryPerPage) / 64);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }
}

