/*
 * Decompiled with CFR 0.152.
 */
package org.h2.pagestore.db;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.pagestore.db.HashIndex;
import org.h2.pagestore.db.NonUniqueHashIndex;
import org.h2.pagestore.db.PageBtreeIndex;
import org.h2.pagestore.db.PageDataIndex;
import org.h2.pagestore.db.PageDelegateIndex;
import org.h2.pagestore.db.ScanIndex;
import org.h2.pagestore.db.SpatialTreeIndex;
import org.h2.pagestore.db.TreeIndex;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.MathUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;

public class PageStoreTable
extends RegularTable {
    private Index scanIndex;
    private long rowCount;
    private final ArrayDeque<Session> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private long lastModificationId;
    private final PageDataIndex mainIndex;
    private int changesSinceAnalyze;
    private int nextAnalyze;

    public PageStoreTable(CreateTableData createTableData) {
        super(createTableData);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        if (createTableData.persistData && this.database.isPersistent()) {
            this.mainIndex = new PageDataIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData), createTableData.create, createTableData.session);
            this.scanIndex = this.mainIndex;
        } else {
            this.mainIndex = null;
            this.scanIndex = new ScanIndex(this, createTableData.id, IndexColumn.wrap(this.getColumns()), IndexType.createScan(createTableData.persistData));
        }
        this.indexes.add(this.scanIndex);
        this.traceLock = this.database.getTrace(7);
    }

    @Override
    public void close(Session session) {
        for (Index index : this.indexes) {
            index.close(session);
        }
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.scanIndex.getRow(session, l);
    }

    @Override
    public void addRow(Session session, Row row2) {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            int n2 = this.indexes.size();
            for (n = 0; n < n2; ++n) {
                Index index = this.indexes.get(n);
                index.add(session, row2);
                this.checkRowCount(session, index, 1);
            }
            ++this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (--n >= 0) {
                    Index index = this.indexes.get(n);
                    index.remove(session, row2);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session);
    }

    private void checkRowCount(Session session, Index index, int n) {
        long l;
        if (SysProperties.CHECK && !(index instanceof PageDelegateIndex) && (l = index.getRowCount(session)) != this.rowCount + (long)n) {
            DbException.throwInternalError("rowCount expected " + (this.rowCount + (long)n) + " got " + l + " " + this.getName() + "." + index.getName());
        }
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.indexes.get(0);
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Index addIndex(Session session, String string2, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string3) {
        BaseIndex baseIndex;
        boolean bl2;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column2 = indexColumn.column;
                if (column2.isNullable()) {
                    throw DbException.get(90023, column2.getName());
                }
                column2.setPrimaryKey(true);
            }
        }
        boolean bl3 = bl2 = this.isTemporary() && !this.isGlobalTemporary();
        if (!bl2) {
            this.database.lockMeta(session);
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            int n2 = this.database.isStarting() && this.database.getPageStore().getRootPageId(n) != 0 ? -1 : (!this.database.isStarting() && this.mainIndex.getRowCount(session) != 0L || this.mainIndex.getMainIndexColumn() != -1 ? -1 : PageStoreTable.getMainIndexColumn(indexType, indexColumnArray));
            if (n2 != -1) {
                this.mainIndex.setMainIndexColumn(n2);
                baseIndex = new PageDelegateIndex(this, n, string2, indexType, this.mainIndex, bl, session);
            } else {
                baseIndex = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string2, indexColumnArray, indexType, true, bl, session) : new PageBtreeIndex(this, n, string2, indexColumnArray, indexType, bl, session);
            }
        } else if (indexType.isHash()) {
            if (indexColumnArray.length != 1) {
                throw DbException.getUnsupportedException("hash indexes may index only one column");
            }
            baseIndex = indexType.isUnique() ? new HashIndex(this, n, string2, indexColumnArray, indexType) : new NonUniqueHashIndex(this, n, string2, indexColumnArray, indexType);
        } else {
            baseIndex = indexType.isSpatial() ? new SpatialTreeIndex(this, n, string2, indexColumnArray, indexType, false, true, session) : new TreeIndex(this, n, string2, indexColumnArray, indexType);
        }
        if (baseIndex.needRebuild() && this.rowCount > 0L) {
            try {
                long l;
                Index index = this.getScanIndex(session);
                long l2 = l = index.getRowCount(session);
                Cursor cursor = index.find(session, null, null);
                long l3 = 0L;
                int n3 = (int)Math.min(this.rowCount, (long)this.database.getMaxMemoryRows());
                ArrayList<Row> arrayList = new ArrayList<Row>(n3);
                String string4 = this.getName() + ":" + baseIndex.getName();
                int n4 = MathUtils.convertLongToInt(l2);
                while (cursor.next()) {
                    this.database.setProgress(1, string4, MathUtils.convertLongToInt(l3++), n4);
                    Row row2 = cursor.get();
                    arrayList.add(row2);
                    if (arrayList.size() >= n3) {
                        PageStoreTable.addRowsToIndex(session, arrayList, baseIndex);
                    }
                    --l;
                }
                PageStoreTable.addRowsToIndex(session, arrayList, baseIndex);
                if (l != 0L) {
                    DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
                }
            }
            catch (DbException dbException) {
                this.getSchema().freeUniqueName(string2);
                try {
                    baseIndex.remove(session);
                }
                catch (DbException dbException2) {
                    this.trace.error(dbException2, "could not remove index");
                    throw dbException2;
                }
                throw dbException;
            }
        }
        baseIndex.setTemporary(this.isTemporary());
        if (baseIndex.getCreateSQL() != null) {
            baseIndex.setComment(string3);
            if (bl2) {
                session.addLocalTempTableIndex(baseIndex);
            } else {
                this.database.addSchemaObject(session, baseIndex);
            }
        }
        this.indexes.add(baseIndex);
        this.setModified();
        return baseIndex;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public void removeRow(Session session, Row row2) {
        int n;
        this.lastModificationId = this.database.getNextModificationDataId();
        try {
            for (n = this.indexes.size() - 1; n >= 0; --n) {
                Index index = this.indexes.get(n);
                index.remove(session, row2);
                this.checkRowCount(session, index, -1);
            }
            --this.rowCount;
        }
        catch (Throwable throwable) {
            try {
                while (++n < this.indexes.size()) {
                    Index index = this.indexes.get(n);
                    index.add(session, row2);
                    this.checkRowCount(session, index, 0);
                }
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "could not undo operation");
                throw dbException;
            }
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int j = this.indexes.size() - 1; j >= 0; --j) {
            Index index = this.indexes.get(j);
            index.truncate(session);
        }
        this.rowCount = 0L;
        this.changesSinceAnalyze = 0;
    }

    private void analyzeIfRequired(Session session) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        session.markTableForAnalyze(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            return this.lockExclusiveSession != null;
        }
        if (this.lockExclusiveSession == session) {
            return true;
        }
        if (!bl && this.lockSharedSessions.containsKey(session)) {
            return true;
        }
        Database database = this.database;
        synchronized (database) {
            if (!bl && this.lockSharedSessions.contains(session)) {
                return true;
            }
            session.setWaitForLock(this, Thread.currentThread());
            this.waitingSessions.addLast(session);
            try {
                this.doLock1(session, n, bl);
            }
            finally {
                session.setWaitForLock(null, null);
                this.waitingSessions.remove(session);
            }
        }
        return false;
    }

    private void doLock1(Session session, int n, boolean bl) {
        this.traceLock(session, bl, "requesting for");
        long l = 0L;
        boolean bl2 = false;
        while (this.waitingSessions.getFirst() != session || !this.doLock2(session, n, bl)) {
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, PageStoreTable.getDeadlockDetails(arrayList, bl));
                }
            } else {
                bl2 = true;
            }
            long l2 = System.nanoTime();
            if (l == 0L) {
                l = l2 + TimeUnit.MILLISECONDS.toNanos(session.getLockTimeout());
            } else if (l2 >= l) {
                this.traceLock(session, bl, "timeout after " + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int j = 0; j < 20; ++j) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, TimeUnit.NANOSECONDS.toMillis(l - l2))) == 0L) {
                    l3 = 1L;
                }
                this.database.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(Session session, int n, boolean bl) {
        if (bl) {
            if (this.lockExclusiveSession == null) {
                if (this.lockSharedSessions.isEmpty()) {
                    this.traceLock(session, bl, "added for");
                    session.registerTableAsLocked(this);
                    this.lockExclusiveSession = session;
                    return true;
                }
                if (this.lockSharedSessions.size() == 1 && this.lockSharedSessions.containsKey(session)) {
                    this.traceLock(session, bl, "add (upgraded) for ");
                    this.lockExclusiveSession = session;
                    return true;
                }
            }
        } else if (this.lockExclusiveSession == null) {
            if (n == 3) {
                return true;
            }
            if (!this.lockSharedSessions.containsKey(session)) {
                this.traceLock(session, bl, "ok");
                session.registerTableAsLocked(this);
                this.lockSharedSessions.put(session, session);
            }
            return true;
        }
        return false;
    }

    private void traceLock(Session session, boolean bl, String string2) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session.getId(), bl ? "exclusive write lock" : "shared read lock", string2, this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session) {
        if (this.database != null) {
            this.traceLock(session, this.lockExclusiveSession == session, "unlock");
            if (this.lockExclusiveSession == session) {
                this.lockSharedSessions.remove(session);
                this.lockExclusiveSession = null;
            }
            Database database = this.database;
            synchronized (database) {
                if (!this.lockSharedSessions.isEmpty()) {
                    this.lockSharedSessions.remove(session);
                }
                if (!this.waitingSessions.isEmpty()) {
                    this.database.notifyAll();
                }
            }
        }
    }

    public void setRowCount(long l) {
        this.rowCount = l;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session, index);
            }
            this.indexes.remove(index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.scanIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.scanIndex = null;
        this.lockExclusiveSession = null;
        this.lockSharedSessions.clear();
        this.invalidate();
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    @Override
    public long getRowCountApproximation() {
        return this.scanIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.scanIndex.getDiskSpaceUsed();
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }
}

