/*
 * Decompiled with CFR 0.152.
 */
package org.h2.pagestore.db;

import java.util.ArrayList;
import org.h2.command.dml.AllColumnsForPlan;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.pagestore.db.PageStoreTable;
import org.h2.pagestore.db.ScanCursor;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.Utils;

public class ScanIndex
extends BaseIndex {
    private long firstFree = -1L;
    private ArrayList<Row> rows = Utils.newSmallArrayList();
    private final PageStoreTable tableData;
    private long rowCount;

    public ScanIndex(PageStoreTable pageStoreTable, int n, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(pageStoreTable, n, pageStoreTable.getName() + "_DATA", indexColumnArray, indexType);
        this.tableData = pageStoreTable;
    }

    @Override
    public void remove(Session session) {
        this.truncate(session);
    }

    @Override
    public void truncate(Session session) {
        this.rows = Utils.newSmallArrayList();
        this.firstFree = -1L;
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
        this.rowCount = 0L;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.rows.get((int)l);
    }

    @Override
    public void add(Session session, Row row2) {
        if (this.firstFree == -1L) {
            int n = this.rows.size();
            row2.setKey(n);
            this.rows.add(row2);
        } else {
            long l = this.firstFree;
            Row row3 = this.rows.get((int)l);
            this.firstFree = row3.getKey();
            row2.setKey(l);
            this.rows.set((int)l, row2);
        }
        row2.setDeleted(false);
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row2) {
        if (this.rowCount == 1L) {
            this.rows = Utils.newSmallArrayList();
            this.firstFree = -1L;
        } else {
            Row row3 = session.createRow(null, 1);
            row3.setKey(this.firstFree);
            long l = row2.getKey();
            if ((long)this.rows.size() <= l) {
                throw DbException.get(90112, this.rows.size() + ": " + l);
            }
            this.rows.set((int)l, row3);
            this.firstFree = l;
        }
        --this.rowCount;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return new ScanCursor(this);
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return this.tableData.getRowCountApproximation() + 1000L;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    Row getNextRow(Row row2) {
        long l = row2 == null ? -1L : row2.getKey();
        do {
            if (++l < (long)this.rows.size()) continue;
            return null;
        } while ((row2 = this.rows.get((int)l)).isEmpty());
        return row2;
    }

    @Override
    public int getColumnIndex(Column column2) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column2) {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SCAN");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("SCAN");
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), false).append(".tableScan").toString();
    }
}

