/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;

public class RowList
implements AutoCloseable {
    private final Session session;
    private final ArrayList<Row> list = Utils.newSmallArrayList();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private Data rowBuff;
    private ArrayList<Value> lobs;
    private final int maxMemory;
    private int memory;
    private boolean written;

    public RowList(Session session) {
        this.session = session;
        this.maxMemory = session.getDatabase().isPersistent() ? session.getDatabase().getMaxOperationMemory() : 0;
    }

    private void writeRow(Data data2, Row row2) {
        data2.checkCapacity(22);
        data2.writeByte((byte)1);
        data2.writeInt(row2.getMemory());
        int n = row2.getColumnCount();
        data2.writeInt(n);
        data2.writeLong(row2.getKey());
        data2.writeByte(row2.isDeleted() ? (byte)1 : 0);
        for (int j = 0; j < n; ++j) {
            Value value = row2.getValue(j);
            data2.checkCapacity(1);
            if (value == null) {
                data2.writeByte((byte)0);
                continue;
            }
            data2.writeByte((byte)1);
            if (DataType.isLargeObject(value.getValueType()) && value.getSmall() == null && value.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = Utils.newSmallArrayList();
                }
                value = value.copyToTemp();
                this.lobs.add(value);
            }
            data2.checkCapacity(data2.getValueLen(value));
            data2.writeValue(value);
        }
    }

    private void writeAllRows() {
        Object object;
        if (this.file == null) {
            object = this.session.getDatabase();
            String string2 = ((Database)object).createTempFile();
            this.file = ((Database)object).openFile(string2, "rw", false);
            this.file.setCheckedWriting(false);
            this.file.seek(48L);
            this.rowBuff = Data.create((DataHandler)object, 4096, true);
            this.file.seek(48L);
        }
        object = this.rowBuff;
        RowList.initBuffer((Data)object);
        int n = this.list.size();
        for (int j = 0; j < n; ++j) {
            if (j > 0 && ((Data)object).length() > 4096) {
                this.flushBuffer((Data)object);
                RowList.initBuffer((Data)object);
            }
            Row row2 = this.list.get(j);
            this.writeRow((Data)object, row2);
        }
        this.flushBuffer((Data)object);
        this.list.clear();
        this.memory = 0;
    }

    private static void initBuffer(Data data2) {
        data2.reset();
        data2.writeInt(0);
    }

    private void flushBuffer(Data data2) {
        data2.checkCapacity(1);
        data2.writeByte((byte)0);
        data2.fillAligned();
        data2.setInt(0, data2.length() / 16);
        this.file.write(data2.getBytes(), 0, data2.length());
    }

    public void add(Row row2) {
        this.list.add(row2);
        this.memory += row2.getMemory() + 8;
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(Data data2) {
        if (data2.readByte() == 0) {
            return null;
        }
        int n = data2.readInt();
        int n2 = data2.readInt();
        long l = data2.readLong();
        boolean bl = data2.readByte() != 0;
        Value[] valueArray = new Value[n2];
        for (int j = 0; j < n2; ++j) {
            Value value;
            if (data2.readByte() == 0) {
                value = null;
            } else {
                value = data2.readValue();
                if (value.isLinkedToTable() && value.getTableId() == 0) {
                    this.session.removeAtCommit(value);
                }
            }
            valueArray[j] = value;
        }
        Row row2 = this.session.createRow(valueArray, n);
        row2.setKey(l);
        row2.setDeleted(bl);
        return row2;
    }

    public Row next() {
        Row row2;
        if (this.file == null) {
            row2 = this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                Data data2 = this.rowBuff;
                data2.reset();
                int n = 16;
                this.file.readFully(data2.getBytes(), 0, n);
                int n2 = data2.readInt() * 16;
                data2.checkCapacity(n2);
                if (n2 - n > 0) {
                    this.file.readFully(data2.getBytes(), n, n2 - n);
                }
                while ((row2 = this.readRow(data2)) != null) {
                    this.list.add(row2);
                }
            }
            ++this.index;
            row2 = this.list.get(this.listIndex++);
        }
        return row2;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        if (this.file != null) {
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

