/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import org.h2.engine.SessionInterface;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class SimpleResult
implements ResultInterface,
ResultTarget {
    private final ArrayList<Column> columns;
    private final ArrayList<Value[]> rows;
    private int rowId;

    public SimpleResult() {
        this.columns = Utils.newSmallArrayList();
        this.rows = new ArrayList();
        this.rowId = -1;
    }

    private SimpleResult(ArrayList<Column> arrayList, ArrayList<Value[]> arrayList2) {
        this.columns = arrayList;
        this.rows = arrayList2;
        this.rowId = -1;
    }

    public void addColumn(String string2, String string3, int n, long l, int n2) {
        this.addColumn(string2, string3, TypeInfo.getTypeInfo(n, l, n2, null));
    }

    public void addColumn(String string2, String string3, TypeInfo typeInfo) {
        this.addColumn(new Column(string2, string3, typeInfo));
    }

    void addColumn(Column column2) {
        assert (this.rows.isEmpty());
        this.columns.add(column2);
    }

    @Override
    public void addRow(Value ... valueArray) {
        assert (valueArray.length == this.columns.size());
        this.rows.add(valueArray);
    }

    @Override
    public void reset() {
        this.rowId = -1;
    }

    @Override
    public Value[] currentRow() {
        return this.rows.get(this.rowId);
    }

    @Override
    public boolean next() {
        int n = this.rows.size();
        if (this.rowId < n) {
            return ++this.rowId < n;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowId >= this.rows.size();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public boolean hasNext() {
        return this.rowId < this.rows.size() - 1;
    }

    @Override
    public boolean needToClose() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public String getAlias(int n) {
        return this.columns.get((int)n).alias;
    }

    @Override
    public String getSchemaName(int n) {
        return "";
    }

    @Override
    public String getTableName(int n) {
        return "";
    }

    @Override
    public String getColumnName(int n) {
        return this.columns.get((int)n).columnName;
    }

    @Override
    public TypeInfo getColumnType(int n) {
        return this.columns.get((int)n).columnType;
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return false;
    }

    @Override
    public int getNullable(int n) {
        return 2;
    }

    @Override
    public void setFetchSize(int n) {
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public ResultInterface createShallowCopy(SessionInterface sessionInterface) {
        return new SimpleResult(this.columns, this.rows);
    }

    @Override
    public void limitsWereApplied() {
    }

    static final class Column {
        final String alias;
        final String columnName;
        final TypeInfo columnType;

        Column(String string2, String string3, TypeInfo typeInfo) {
            if (string2 == null || string3 == null) {
                throw new NullPointerException();
            }
            this.alias = string2;
            this.columnName = string3;
            this.columnType = typeInfo;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.alias.hashCode();
            n = 31 * n + this.columnName.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Column column2 = (Column)object;
            return this.alias.equals(column2.alias) && this.columnName.equals(column2.columnName);
        }

        public String toString() {
            if (this.alias.equals(this.columnName)) {
                return this.columnName;
            }
            return this.columnName + ' ' + this.alias;
        }
    }
}

