/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.h2.util.StringUtils;

public class PageParser {
    private static final int TAB_WIDTH = 4;
    private final String page;
    private int pos;
    private final Map<String, Object> settings;
    private final int len;
    private StringBuilder result;

    private PageParser(String string2, Map<String, Object> map2, int n) {
        this.page = string2;
        this.pos = n;
        this.len = string2.length();
        this.settings = map2;
        this.result = new StringBuilder(this.len);
    }

    public static String parse(String string2, Map<String, Object> map2) {
        PageParser pageParser = new PageParser(string2, map2, 0);
        return pageParser.replaceTags();
    }

    private void setError(int n) {
        String string2 = this.page.substring(0, n) + "####BUG####" + this.page.substring(n);
        string2 = PageParser.escapeHtml(string2);
        this.result = new StringBuilder();
        this.result.append(string2);
    }

    private String parseBlockUntil(String string2) throws ParseException {
        PageParser pageParser = new PageParser(this.page, this.settings, this.pos);
        pageParser.parseAll();
        if (!pageParser.readIf(string2)) {
            throw new ParseException(this.page, pageParser.pos);
        }
        this.pos = pageParser.pos;
        return pageParser.result.toString();
    }

    private String replaceTags() {
        try {
            this.parseAll();
            if (this.pos != this.len) {
                this.setError(this.pos);
            }
        }
        catch (ParseException parseException) {
            this.setError(this.pos);
        }
        return this.result.toString();
    }

    private void parseAll() throws ParseException {
        int n;
        StringBuilder stringBuilder = this.result;
        String string2 = this.page;
        block4: for (n = this.pos; n < this.len; ++n) {
            char c = string2.charAt(n);
            switch (c) {
                case '<': {
                    String string3;
                    if (string2.charAt(n + 3) == ':' && string2.charAt(n + 1) == '/') {
                        this.pos = n;
                        return;
                    }
                    if (string2.charAt(n + 2) == ':') {
                        Object object;
                        Object object2;
                        String string4;
                        this.pos = n;
                        if (this.readIf("<c:forEach")) {
                            string4 = this.readParam("var");
                            string3 = this.readParam("items");
                            this.read(">");
                            int n2 = this.pos;
                            object2 = (ArrayList)this.get(string3);
                            if (object2 == null) {
                                this.result.append("?items?");
                                object2 = new ArrayList();
                            }
                            if (object2.isEmpty()) {
                                this.parseBlockUntil("</c:forEach>");
                            }
                            object = object2.iterator();
                            while (object.hasNext()) {
                                Object e = object.next();
                                this.settings.put(string4, e);
                                this.pos = n2;
                                String string5 = this.parseBlockUntil("</c:forEach>");
                                this.result.append(string5);
                            }
                        } else if (this.readIf("<c:if")) {
                            string4 = this.readParam("test");
                            int n3 = string4.indexOf("=='");
                            if (n3 < 0) {
                                this.setError(n);
                                return;
                            }
                            String string6 = string4.substring(n3 + 3, string4.length() - 1);
                            string4 = string4.substring(0, n3);
                            object2 = (String)this.get(string4);
                            this.read(">");
                            object = this.parseBlockUntil("</c:if>");
                            --this.pos;
                            if (((String)object2).equals(string6)) {
                                this.result.append((String)object);
                            }
                        } else {
                            this.setError(n);
                            return;
                        }
                        n = this.pos;
                        continue block4;
                    }
                    stringBuilder.append(c);
                    continue block4;
                }
                case '$': {
                    String string3;
                    if (string2.length() > n + 1 && string2.charAt(n + 1) == '{') {
                        int n4 = string2.indexOf(125, n += 2);
                        if (n4 < 0) {
                            this.setError(n);
                            return;
                        }
                        string3 = StringUtils.trimSubstring(string2, n, n4);
                        n = n4;
                        String string7 = (String)this.get(string3);
                        this.replaceTags(string7);
                        continue block4;
                    }
                    stringBuilder.append(c);
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        this.pos = n;
    }

    private Object get(String string2) {
        int n = string2.indexOf(46);
        if (n >= 0) {
            String string3 = string2.substring(n + 1);
            HashMap hashMap = (HashMap)this.settings.get(string2 = string2.substring(0, n));
            if (hashMap == null) {
                return "?" + string2 + "?";
            }
            return hashMap.get(string3);
        }
        return this.settings.get(string2);
    }

    private void replaceTags(String string2) {
        if (string2 != null) {
            this.result.append(PageParser.parse(string2, this.settings));
        }
    }

    private String readParam(String string2) throws ParseException {
        this.read(string2);
        this.read("=");
        this.read("\"");
        int n = this.pos;
        while (this.page.charAt(this.pos) != '\"') {
            ++this.pos;
        }
        int n2 = this.pos;
        this.read("\"");
        String string3 = this.page.substring(n, n2);
        return PageParser.parse(string3, this.settings);
    }

    private void skipSpaces() {
        while (this.page.charAt(this.pos) == ' ') {
            ++this.pos;
        }
    }

    private void read(String string2) throws ParseException {
        if (!this.readIf(string2)) {
            throw new ParseException(string2, this.pos);
        }
    }

    private boolean readIf(String string2) {
        this.skipSpaces();
        if (this.page.regionMatches(this.pos, string2, 0, string2.length())) {
            this.pos += string2.length();
            this.skipSpaces();
            return true;
        }
        return false;
    }

    static String escapeHtmlData(String string2) {
        return PageParser.escapeHtml(string2, false);
    }

    public static String escapeHtml(String string2) {
        return PageParser.escapeHtml(string2, true);
    }

    private static String escapeHtml(String string2, boolean bl) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        if (bl && n == 0) {
            return "&nbsp;";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl2 = true;
        block9: for (int j = 0; j < n; ++j) {
            char c = string2.charAt(j);
            if (c == ' ' || c == '\t') {
                for (int k = 0; k < (c == ' ' ? 1 : 4); ++k) {
                    if (bl2 && bl) {
                        stringBuilder.append("&nbsp;");
                        continue;
                    }
                    stringBuilder.append(' ');
                    bl2 = true;
                }
                continue;
            }
            bl2 = false;
            switch (c) {
                case '$': {
                    stringBuilder.append("&#36;");
                    continue block9;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block9;
                }
                case '\n': {
                    if (bl) {
                        stringBuilder.append("<br />");
                        bl2 = true;
                        continue block9;
                    }
                    stringBuilder.append(c);
                    continue block9;
                }
                default: {
                    if (c >= '\u0080') {
                        stringBuilder.append("&#").append((int)c).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static String escapeJavaScript(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        block8: for (int j = 0; j < n; ++j) {
            char c = string2.charAt(j);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

