/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableType;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class TableLink
extends Table {
    private static final int MAX_RETRY = 2;
    private static final long ROW_COUNT_APPROXIMATION = 100000L;
    private final String originalSchema;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private String qualifiedTableName;
    private TableLinkConnection conn;
    private HashMap<String, PreparedStatement> preparedMap = new HashMap();
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private DbException connectException;
    private boolean storesLowerCase;
    private boolean storesMixedCase;
    private boolean storesMixedCaseQuoted;
    private boolean supportsMixedCaseIdentifiers;
    private boolean globalTemporary;
    private boolean readOnly;
    private boolean targetsMySql;

    public TableLink(Schema schema, int n, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2) {
        super(schema, n, string2, false, true);
        this.driver = string3;
        this.url = string4;
        this.user = string5;
        this.password = string6;
        this.originalSchema = string7;
        this.originalTable = string8;
        this.emitUpdates = bl;
        this.targetsMySql = TableLink.isMySqlUrl(this.url);
        try {
            this.connect();
        }
        catch (DbException dbException) {
            if (!bl2) {
                throw dbException;
            }
            Column[] columnArray = new Column[]{};
            this.setColumns(columnArray);
            this.linkedIndex = new LinkedIndex(this, n, IndexColumn.wrap(columnArray), IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    private void connect() {
        this.connectException = null;
        int n = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn = this.database.getLinkConnection(this.driver, this.url, this.user, this.password);
                synchronized (tableLinkConnection) {
                    try {
                        this.readMetaData();
                        return;
                    }
                    catch (Exception exception) {
                        this.conn.close(true);
                        this.conn = null;
                        throw DbException.convert(exception);
                    }
                }
            }
            catch (DbException dbException) {
                if (n >= 2) {
                    this.connectException = dbException;
                    throw dbException;
                }
                ++n;
                continue;
            }
            break;
        }
    }

    private void readMetaData() throws SQLException {
        int n;
        int n2;
        String string2;
        Object object;
        Object object2;
        Throwable throwable;
        AutoCloseable autoCloseable;
        DatabaseMetaData databaseMetaData = this.conn.getConnection().getMetaData();
        this.storesLowerCase = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCase = databaseMetaData.storesMixedCaseIdentifiers();
        this.storesMixedCaseQuoted = databaseMetaData.storesMixedCaseQuotedIdentifiers();
        this.supportsMixedCaseIdentifiers = databaseMetaData.supportsMixedCaseIdentifiers();
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        HashMap<String, Column> hashMap = new HashMap<String, Column>();
        String string3 = null;
        boolean bl = this.originalTable.startsWith("(");
        if (!bl) {
            autoCloseable = databaseMetaData.getTables(null, this.originalSchema, this.originalTable, null);
            throwable = null;
            try {
                if (autoCloseable.next() && autoCloseable.next()) {
                    throw DbException.get(90080, this.originalTable);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (autoCloseable != null) {
                    if (throwable != null) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        autoCloseable.close();
                    }
                }
            }
            autoCloseable = databaseMetaData.getColumns(null, this.originalSchema, this.originalTable, null);
            throwable = null;
            try {
                int n3 = 0;
                object2 = null;
                while (autoCloseable.next()) {
                    object = autoCloseable.getString("TABLE_CAT");
                    if (object2 == null) {
                        object2 = object;
                    }
                    String string4 = autoCloseable.getString("TABLE_SCHEM");
                    if (string3 == null) {
                        string3 = string4;
                    }
                    if (!Objects.equals(object2, object) || !Objects.equals(string3, string4)) {
                        hashMap.clear();
                        arrayList.clear();
                        break;
                    }
                    string2 = autoCloseable.getString("COLUMN_NAME");
                    string2 = this.convertColumnName(string2);
                    n2 = autoCloseable.getInt("DATA_TYPE");
                    String string5 = autoCloseable.getString("TYPE_NAME");
                    long l = autoCloseable.getInt("COLUMN_SIZE");
                    l = TableLink.convertPrecision(n2, l);
                    n = autoCloseable.getInt("DECIMAL_DIGITS");
                    n = TableLink.convertScale(n2, n);
                    int n4 = DataType.convertSQLTypeToValueType(n2, string5);
                    Column column2 = new Column(string2, TypeInfo.getTypeInfo(n4, l, n, null));
                    column2.setTable(this, n3++);
                    arrayList.add(column2);
                    hashMap.put(string2, column2);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (autoCloseable != null) {
                    if (throwable != null) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        autoCloseable.close();
                    }
                }
            }
        }
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(string3) ? string3 + '.' + this.originalTable : this.originalTable;
        try {
            autoCloseable = this.conn.getConnection().createStatement();
            throwable = null;
            try {
                ResultSet resultSet = autoCloseable.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");
                object2 = null;
                try {
                    if (arrayList.isEmpty()) {
                        object = resultSet.getMetaData();
                        int n5 = 0;
                        while (n5 < object.getColumnCount()) {
                            string2 = object.getColumnName(n5 + 1);
                            string2 = this.convertColumnName(string2);
                            n2 = object.getColumnType(n5 + 1);
                            long l = object.getPrecision(n5 + 1);
                            l = TableLink.convertPrecision(n2, l);
                            int n6 = object.getScale(n5 + 1);
                            n6 = TableLink.convertScale(n2, n6);
                            n = DataType.getValueTypeFromResultSet((ResultSetMetaData)object, n5 + 1);
                            Column column3 = new Column(string2, TypeInfo.getTypeInfo(n, l, n6, null));
                            column3.setTable(this, n5++);
                            arrayList.add(column3);
                            hashMap.put(string2, column3);
                        }
                    }
                }
                catch (Throwable throwable6) {
                    object2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (resultSet != null) {
                        if (object2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable7) {
                                ((Throwable)object2).addSuppressed(throwable7);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (autoCloseable != null) {
                    if (throwable != null) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        autoCloseable.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw DbException.get(42102, exception, this.originalTable + '(' + exception.toString() + ')');
        }
        autoCloseable = arrayList.toArray(new Column[0]);
        this.setColumns((Column[])autoCloseable);
        int n7 = this.getId();
        this.linkedIndex = new LinkedIndex(this, n7, IndexColumn.wrap((Column[])autoCloseable), IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        if (!bl) {
            this.readIndexes(databaseMetaData, hashMap);
        }
    }

    private void readIndexes(DatabaseMetaData databaseMetaData, HashMap<String, Column> hashMap) {
        Throwable throwable;
        ResultSet resultSet;
        String string2 = null;
        try {
            resultSet = databaseMetaData.getPrimaryKeys(null, this.originalSchema, this.originalTable);
            throwable = null;
            try {
                if (resultSet.next()) {
                    string2 = this.readPrimaryKey(resultSet, hashMap);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            resultSet = databaseMetaData.getIndexInfo(null, this.originalSchema, this.originalTable, false, true);
            throwable = null;
            try {
                this.readIndexes(resultSet, hashMap, string2);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String readPrimaryKey(ResultSet resultSet, HashMap<String, Column> hashMap) throws SQLException {
        String string2 = null;
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        do {
            int n = resultSet.getInt("KEY_SEQ");
            if (StringUtils.isNullOrEmpty(string2)) {
                string2 = resultSet.getString("PK_NAME");
            }
            while (arrayList.size() < n) {
                arrayList.add(null);
            }
            String string3 = resultSet.getString("COLUMN_NAME");
            string3 = this.convertColumnName(string3);
            Column column2 = hashMap.get(string3);
            if (n == 0) {
                arrayList.add(column2);
                continue;
            }
            arrayList.set(n - 1, column2);
        } while (resultSet.next());
        this.addIndex(arrayList, IndexType.createPrimaryKey(false, false));
        return string2;
    }

    private void readIndexes(ResultSet resultSet, HashMap<String, Column> hashMap, String string2) throws SQLException {
        String string3 = null;
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        IndexType indexType = null;
        while (resultSet.next()) {
            if (resultSet.getShort("TYPE") == 0) continue;
            String string4 = resultSet.getString("INDEX_NAME");
            if (string2 != null && string2.equals(string4)) continue;
            if (string3 != null && !string3.equals(string4)) {
                this.addIndex(arrayList, indexType);
                string3 = null;
            }
            if (string3 == null) {
                string3 = string4;
                arrayList.clear();
            }
            boolean bl = !resultSet.getBoolean("NON_UNIQUE");
            indexType = bl ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
            String string5 = resultSet.getString("COLUMN_NAME");
            string5 = this.convertColumnName(string5);
            Column column2 = hashMap.get(string5);
            arrayList.add(column2);
        }
        if (string3 != null) {
            this.addIndex(arrayList, indexType);
        }
    }

    private static long convertPrecision(int n, long l) {
        switch (n) {
            case 2: 
            case 3: {
                if (l != 0L) break;
                l = 65535L;
                break;
            }
            case 91: {
                l = Math.max(10L, l);
                break;
            }
            case 93: {
                l = Math.max(29L, l);
                break;
            }
            case 92: {
                l = Math.max(18L, l);
            }
        }
        return l;
    }

    private static int convertScale(int n, int n2) {
        switch (n) {
            case 2: 
            case 3: {
                if (n2 >= 0) break;
                n2 = Short.MAX_VALUE;
            }
        }
        return n2;
    }

    private String convertColumnName(String string2) {
        if (this.targetsMySql) {
            string2 = StringUtils.toUpperEnglish(string2);
        } else if ((this.storesMixedCase || this.storesLowerCase) && string2.equals(StringUtils.toLowerEnglish(string2))) {
            string2 = StringUtils.toUpperEnglish(string2);
        } else if (this.storesMixedCase && !this.supportsMixedCaseIdentifiers) {
            string2 = StringUtils.toUpperEnglish(string2);
        } else if (this.storesMixedCase && this.storesMixedCaseQuoted) {
            string2 = StringUtils.toUpperEnglish(string2);
        }
        return string2;
    }

    private void addIndex(List<Column> list2, IndexType indexType) {
        int n = list2.indexOf(null);
        if (n == 0) {
            this.trace.info("Omitting linked index - no recognized columns.");
            return;
        }
        if (n > 0) {
            this.trace.info("Unrecognized columns in linked index. Registering the index against the leading {0} recognized columns of {1} total columns.", n, list2.size());
            list2 = list2.subList(0, n);
        }
        Column[] columnArray = list2.toArray(new Column[0]);
        LinkedIndex linkedIndex = new LinkedIndex(this, 0, IndexColumn.wrap(columnArray), indexType);
        this.indexes.add(linkedIndex);
    }

    @Override
    public String getDropSQL() {
        StringBuilder stringBuilder = new StringBuilder("DROP TABLE IF EXISTS ");
        return this.getSQL(stringBuilder, true).toString();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                stringBuilder.append("GLOBAL ");
            } else {
                stringBuilder.append("LOCAL ");
            }
            stringBuilder.append("TEMPORARY ");
        }
        stringBuilder.append("LINKED TABLE ");
        this.getSQL(stringBuilder, true);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        stringBuilder.append('(');
        StringUtils.quoteStringSQL(stringBuilder, this.driver).append(", ");
        StringUtils.quoteStringSQL(stringBuilder, this.url).append(", ");
        StringUtils.quoteStringSQL(stringBuilder, this.user).append(", ");
        StringUtils.quoteStringSQL(stringBuilder, this.password).append(", ");
        StringUtils.quoteStringSQL(stringBuilder, this.originalTable).append(')');
        if (this.emitUpdates) {
            stringBuilder.append(" EMIT UPDATES");
        }
        if (this.readOnly) {
            stringBuilder.append(" READONLY");
        }
        stringBuilder.append(" /*").append("--hide--").append("*/");
        return stringBuilder.toString();
    }

    @Override
    public Index addIndex(Session session, String string2, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string3) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.linkedIndex;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
    }

    @Override
    public void removeRow(Session session, Row row2) {
        this.checkReadOnly();
        this.getScanIndex(session).remove(session, row2);
    }

    @Override
    public void addRow(Session session, Row row2) {
        this.checkReadOnly();
        this.getScanIndex(session).add(session, row2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) {
        if (this.conn != null) {
            try {
                this.conn.close(false);
            }
            finally {
                this.conn = null;
            }
        }
    }

    @Override
    public synchronized long getRowCount(Session session) {
        String string2 = "SELECT COUNT(*) FROM " + this.qualifiedTableName + " as foo";
        try {
            PreparedStatement preparedStatement = this.execute(string2, null, false);
            ResultSet resultSet = preparedStatement.getResultSet();
            resultSet.next();
            long l = resultSet.getLong(1);
            resultSet.close();
            this.reusePreparedStatement(preparedStatement, string2);
            return l;
        }
        catch (Exception exception) {
            throw TableLink.wrapException(string2, exception);
        }
    }

    public static DbException wrapException(String string2, Exception exception) {
        SQLException sQLException = DbException.toSQLException(exception);
        return DbException.get(90111, sQLException, string2, sQLException.toString());
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement execute(String string2, ArrayList<Value> arrayList, boolean bl) {
        if (this.conn == null) {
            throw this.connectException;
        }
        int n = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn;
                synchronized (tableLinkConnection) {
                    int n2;
                    PreparedStatement preparedStatement = this.preparedMap.remove(string2);
                    if (preparedStatement == null) {
                        preparedStatement = this.conn.getConnection().prepareStatement(string2);
                    }
                    if (this.trace.isDebugEnabled()) {
                        StringBuilder stringBuilder = new StringBuilder(this.getName()).append(":\n").append(string2);
                        if (arrayList != null && !arrayList.isEmpty()) {
                            stringBuilder.append(" {");
                            n2 = 0;
                            int n3 = arrayList.size();
                            while (n2 < n3) {
                                Value value = arrayList.get(n2);
                                if (n2 > 0) {
                                    stringBuilder.append(", ");
                                }
                                stringBuilder.append(++n2).append(": ");
                                value.getSQL(stringBuilder);
                            }
                            stringBuilder.append('}');
                        }
                        stringBuilder.append(';');
                        this.trace.debug(stringBuilder.toString());
                    }
                    if (arrayList != null) {
                        n2 = arrayList.size();
                        for (int j = 0; j < n2; ++j) {
                            Value value = arrayList.get(j);
                            value.set(preparedStatement, j + 1);
                        }
                    }
                    preparedStatement.execute();
                    if (bl) {
                        this.reusePreparedStatement(preparedStatement, string2);
                        return null;
                    }
                    return preparedStatement;
                }
            }
            catch (SQLException sQLException) {
                if (n >= 2) {
                    throw DbException.convert(sQLException);
                }
                this.conn.close(true);
                this.connect();
                ++n;
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE_LINK;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.preparedMap = null;
        this.invalidate();
    }

    public boolean isOracle() {
        return this.url.startsWith("jdbc:oracle:");
    }

    private static boolean isMySqlUrl(String string2) {
        return string2.startsWith("jdbc:mysql:") || string2.startsWith("jdbc:mariadb:");
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isUnique()) continue;
            return index;
        }
        return null;
    }

    @Override
    public void updateRows(Prepared prepared, Session session, RowList rowList) {
        boolean bl;
        this.checkReadOnly();
        if (this.emitUpdates) {
            rowList.reset();
            while (rowList.hasNext()) {
                prepared.checkCanceled();
                Row row2 = rowList.next();
                Row row3 = rowList.next();
                this.linkedIndex.update(row2, row3);
                session.log(this, (short)1, row2);
                session.log(this, (short)0, row3);
            }
            bl = false;
        } else {
            bl = true;
        }
        if (bl) {
            super.updateRows(prepared, session, rowList);
        }
    }

    public void setGlobalTemporary(boolean bl) {
        this.globalTemporary = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public long getRowCountApproximation() {
        return 100000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reusePreparedStatement(PreparedStatement preparedStatement, String string2) {
        TableLinkConnection tableLinkConnection = this.conn;
        synchronized (tableLinkConnection) {
            this.preparedMap.put(string2, preparedStatement);
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void validateConvertUpdateSequence(Session session, Row row2) {
        for (int j = 0; j < this.columns.length; ++j) {
            Column column2;
            Value value;
            Value value2 = row2.getValue(j);
            if (value2 == null || (value = (column2 = this.columns[j]).validateConvertUpdateSequence(session, value2)) == value2) continue;
            row2.setValue(j, value);
        }
    }

    @Override
    public Value getDefaultValue(Session session, Column column2) {
        return null;
    }
}

