/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.dml.TableValueConstructor;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.VirtualConstructedTable;

public class TableValueConstructorTable
extends VirtualConstructedTable {
    private final ArrayList<ArrayList<Expression>> rows;

    public TableValueConstructorTable(Schema schema, Session session, Column[] columnArray, ArrayList<ArrayList<Expression>> arrayList) {
        super(schema, 0, "VALUES");
        this.setColumns(columnArray);
        this.rows = arrayList;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rows.size();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rows.size();
    }

    @Override
    public ResultInterface getResult(Session session) {
        SimpleResult simpleResult = new SimpleResult();
        for (Column column2 : this.columns) {
            String string2 = column2.getName();
            simpleResult.addColumn(string2, string2, column2.getType());
        }
        TableValueConstructor.getVisibleResult(session, simpleResult, this.columns, this.rows);
        return simpleResult;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        TableValueConstructor.getValuesSQL(stringBuilder, bl, this.rows);
        return stringBuilder.append(')');
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

