/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.dml.BackupCommand;
import org.h2.message.DbException;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

public class Backup
extends Tool {
    public static void main(String ... stringArray) throws SQLException {
        new Backup().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string2 = "backup.zip";
        String string3 = ".";
        String string4 = null;
        boolean bl = false;
        for (int j = 0; stringArray != null && j < stringArray.length; ++j) {
            String string5 = stringArray[j];
            if (string5.equals("-dir")) {
                string3 = stringArray[++j];
                continue;
            }
            if (string5.equals("-db")) {
                string4 = stringArray[++j];
                continue;
            }
            if (string5.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string5.equals("-file")) {
                string2 = stringArray[++j];
                continue;
            }
            if (string5.equals("-help") || string5.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string5);
        }
        try {
            this.process(string2, string3, string4, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public static void execute(String string2, String string3, String string4, boolean bl) throws SQLException {
        try {
            new Backup().process(string2, string3, string4, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string2, String string3, String string4, boolean bl) throws SQLException {
        boolean bl2 = string4 != null && string4.isEmpty();
        List<String> list2 = bl2 ? FileUtils.newDirectoryStream(string3) : FileLister.getDatabaseFiles(string3, string4, true);
        if (list2.isEmpty()) {
            if (!bl) {
                this.printNoDatabaseFilesFound(string3, string4);
            }
            return;
        }
        if (!bl) {
            FileLister.tryUnlockDatabase(list2, "backup");
        }
        string2 = FileUtils.toRealPath(string2);
        FileUtils.delete(string2);
        OutputStream outputStream2 = null;
        try {
            outputStream2 = FileUtils.newOutputStream(string2, false);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream2);){
                String string5 = "";
                for (String string6 : list2) {
                    if (!bl2 && !string6.endsWith(".h2.db") && !string6.endsWith(".mv.db")) continue;
                    string5 = FileUtils.getParent(string6);
                    break;
                }
                for (String string6 : list2) {
                    String string7 = FileUtils.toRealPath(string6);
                    if (!string7.startsWith(string5)) {
                        DbException.throwInternalError(string7 + " does not start with " + string5);
                    }
                    if (string7.endsWith(string2) || FileUtils.isDirectory(string6)) continue;
                    string7 = string7.substring(string5.length());
                    string7 = BackupCommand.correctFileName(string7);
                    ZipEntry zipEntry = new ZipEntry(string7);
                    zipOutputStream.putNextEntry(zipEntry);
                    InputStream inputStream2 = null;
                    try {
                        inputStream2 = FileUtils.newInputStream(string6);
                        IOUtils.copyAndCloseInput(inputStream2, zipOutputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    finally {
                        IOUtils.closeSilently(inputStream2);
                    }
                    zipOutputStream.closeEntry();
                    if (bl) continue;
                    this.out.println("Processed: " + string6);
                }
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string2);
        }
        finally {
            IOUtils.closeSilently(outputStream2);
        }
    }
}

