/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.server.pg.PgServer;
import org.h2.server.web.WebServer;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class Server
extends Tool
implements Runnable,
ShutdownHandler {
    private final Service service;
    private Server web;
    private Server tcp;
    private Server pg;
    private ShutdownHandler shutdownHandler;
    private boolean started;

    public Server() {
        this.service = null;
    }

    public Server(Service service, String ... stringArray) throws SQLException {
        this.verifyArgs(stringArray);
        this.service = service;
        try {
            service.init(stringArray);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    public static void main(String ... stringArray) throws SQLException {
        new Server().runTool(stringArray);
    }

    private void verifyArgs(String ... stringArray) throws SQLException {
        for (int j = 0; stringArray != null && j < stringArray.length; ++j) {
            String string2 = stringArray[j];
            if (string2 == null || "-?".equals(string2) || "-help".equals(string2)) continue;
            if (string2.startsWith("-web")) {
                if ("-web".equals(string2) || "-webAllowOthers".equals(string2) || "-webDaemon".equals(string2) || "-webSSL".equals(string2)) continue;
                if ("-webPort".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-webAdminPassword".equals(string2)) {
                    j += 2;
                    continue;
                }
                this.throwUnsupportedOption(string2);
                continue;
            }
            if ("-browser".equals(string2)) continue;
            if (string2.startsWith("-tcp")) {
                if ("-tcp".equals(string2) || "-tcpAllowOthers".equals(string2) || "-tcpDaemon".equals(string2) || "-tcpSSL".equals(string2)) continue;
                if ("-tcpPort".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-tcpPassword".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-tcpShutdown".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-tcpShutdownForce".equals(string2)) continue;
                this.throwUnsupportedOption(string2);
                continue;
            }
            if (string2.startsWith("-pg")) {
                if ("-pg".equals(string2) || "-pgAllowOthers".equals(string2) || "-pgDaemon".equals(string2)) continue;
                if ("-pgPort".equals(string2)) {
                    ++j;
                    continue;
                }
                this.throwUnsupportedOption(string2);
                continue;
            }
            if (string2.startsWith("-ftp")) {
                if ("-ftpPort".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-ftpDir".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-ftpRead".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-ftpWrite".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-ftpWritePassword".equals(string2)) {
                    ++j;
                    continue;
                }
                if ("-ftpTask".equals(string2)) continue;
                this.throwUnsupportedOption(string2);
                continue;
            }
            if ("-properties".equals(string2)) {
                ++j;
                continue;
            }
            if ("-trace".equals(string2) || "-ifExists".equals(string2) || "-ifNotExists".equals(string2)) continue;
            if ("-baseDir".equals(string2)) {
                ++j;
                continue;
            }
            if ("-key".equals(string2)) {
                j += 2;
                continue;
            }
            if ("-tool".equals(string2)) continue;
            this.throwUnsupportedOption(string2);
        }
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        block33: {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            String string2 = "";
            String string3 = "";
            boolean bl7 = true;
            for (int j = 0; stringArray != null && j < stringArray.length; ++j) {
                String string4 = stringArray[j];
                if (string4 == null) continue;
                if ("-?".equals(string4) || "-help".equals(string4)) {
                    this.showUsage();
                    return;
                }
                if (string4.startsWith("-web")) {
                    if ("-web".equals(string4)) {
                        bl7 = false;
                        bl3 = true;
                        continue;
                    }
                    if ("-webAllowOthers".equals(string4) || "-webDaemon".equals(string4) || "-webSSL".equals(string4)) continue;
                    if ("-webPort".equals(string4)) {
                        ++j;
                        continue;
                    }
                    if ("-webAdminPassword".equals(string4)) {
                        j += 2;
                        continue;
                    }
                    this.showUsageAndThrowUnsupportedOption(string4);
                    continue;
                }
                if ("-browser".equals(string4)) {
                    bl7 = false;
                    bl4 = true;
                    continue;
                }
                if (string4.startsWith("-tcp")) {
                    if ("-tcp".equals(string4)) {
                        bl7 = false;
                        bl = true;
                        continue;
                    }
                    if ("-tcpAllowOthers".equals(string4) || "-tcpDaemon".equals(string4) || "-tcpSSL".equals(string4)) continue;
                    if ("-tcpPort".equals(string4)) {
                        ++j;
                        continue;
                    }
                    if ("-tcpPassword".equals(string4)) {
                        string2 = stringArray[++j];
                        continue;
                    }
                    if ("-tcpShutdown".equals(string4)) {
                        bl7 = false;
                        bl5 = true;
                        string3 = stringArray[++j];
                        continue;
                    }
                    if ("-tcpShutdownForce".equals(string4)) {
                        bl6 = true;
                        continue;
                    }
                    this.showUsageAndThrowUnsupportedOption(string4);
                    continue;
                }
                if (string4.startsWith("-pg")) {
                    if ("-pg".equals(string4)) {
                        bl7 = false;
                        bl2 = true;
                        continue;
                    }
                    if ("-pgAllowOthers".equals(string4) || "-pgDaemon".equals(string4)) continue;
                    if ("-pgPort".equals(string4)) {
                        ++j;
                        continue;
                    }
                    this.showUsageAndThrowUnsupportedOption(string4);
                    continue;
                }
                if ("-properties".equals(string4)) {
                    ++j;
                    continue;
                }
                if ("-trace".equals(string4) || "-ifExists".equals(string4) || "-ifNotExists".equals(string4)) continue;
                if ("-baseDir".equals(string4)) {
                    ++j;
                    continue;
                }
                if ("-key".equals(string4)) {
                    j += 2;
                    continue;
                }
                this.showUsageAndThrowUnsupportedOption(string4);
            }
            this.verifyArgs(stringArray);
            if (bl7) {
                bl = true;
                bl2 = true;
                bl3 = true;
                bl4 = true;
            }
            if (bl5) {
                this.out.println("Shutting down TCP Server at " + string3);
                Server.shutdownTcpServer(string3, string2, bl6, false);
            }
            try {
                if (bl) {
                    this.tcp = Server.createTcpServer(stringArray);
                    this.tcp.start();
                    this.out.println(this.tcp.getStatus());
                    this.tcp.setShutdownHandler(this);
                }
                if (bl2) {
                    this.pg = Server.createPgServer(stringArray);
                    this.pg.start();
                    this.out.println(this.pg.getStatus());
                }
                if (bl3) {
                    this.web = Server.createWebServer(stringArray);
                    this.web.setShutdownHandler(this);
                    SQLException sQLException = null;
                    try {
                        this.web.start();
                    }
                    catch (Exception exception) {
                        sQLException = DbException.toSQLException(exception);
                    }
                    this.out.println(this.web.getStatus());
                    if (bl4) {
                        try {
                            Server.openBrowser(this.web.getURL());
                        }
                        catch (Exception exception) {
                            this.out.println(exception.getMessage());
                        }
                    }
                    if (sQLException != null) {
                        throw sQLException;
                    }
                    break block33;
                }
                if (bl4) {
                    this.out.println("The browser can only start if a web server is started (-web)");
                }
            }
            catch (SQLException sQLException) {
                this.stopAll();
                throw sQLException;
            }
        }
    }

    public static void shutdownTcpServer(String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        TcpServer.shutdown(string2, string3, bl, bl2);
    }

    public String getStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.started) {
            stringBuilder.append("Not started");
        } else if (this.isRunning(false)) {
            stringBuilder.append(this.service.getType()).append(" server running at ").append(this.service.getURL()).append(" (");
            if (this.service.getAllowOthers()) {
                stringBuilder.append("others can connect");
            } else {
                stringBuilder.append("only local connections");
            }
            stringBuilder.append(')');
        } else {
            stringBuilder.append("The ").append(this.service.getType()).append(" server could not be started. Possible cause: another server is already running at ").append(this.service.getURL());
        }
        return stringBuilder.toString();
    }

    public static Server createWebServer(String ... stringArray) throws SQLException {
        return Server.createWebServer(stringArray, null, false);
    }

    static Server createWebServer(String[] stringArray, String string2, boolean bl) throws SQLException {
        WebServer webServer = new WebServer();
        webServer.setKey(string2);
        webServer.setAllowSecureCreation(bl);
        Server server = new Server(webServer, stringArray);
        webServer.setShutdownHandler(server);
        return server;
    }

    public static Server createTcpServer(String ... stringArray) throws SQLException {
        TcpServer tcpServer = new TcpServer();
        Server server = new Server(tcpServer, stringArray);
        tcpServer.setShutdownHandler(server);
        return server;
    }

    public static Server createPgServer(String ... stringArray) throws SQLException {
        return new Server(new PgServer(), stringArray);
    }

    public Server start() throws SQLException {
        try {
            this.started = true;
            this.service.start();
            String string2 = this.service.getURL();
            int n = string2.indexOf(63);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            String string3 = this.service.getName() + " (" + string2 + ')';
            Thread thread2 = new Thread((Runnable)this, string3);
            thread2.setDaemon(this.service.isDaemon());
            thread2.start();
            for (int j = 1; j < 64; j += j) {
                Server.wait(j);
                if (!this.isRunning(false)) continue;
                return this;
            }
            if (this.isRunning(true)) {
                return this;
            }
            throw DbException.get(90061, string3, "timeout; please check your network configuration, specially the file /etc/hosts");
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private static void wait(int n) {
        try {
            long l = (long)n * (long)n;
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopAll() {
        Server server = this.web;
        if (server != null && server.isRunning(false)) {
            server.stop();
            this.web = null;
        }
        if ((server = this.tcp) != null && server.isRunning(false)) {
            server.stop();
            this.tcp = null;
        }
        if ((server = this.pg) != null && server.isRunning(false)) {
            server.stop();
            this.pg = null;
        }
    }

    public boolean isRunning(boolean bl) {
        return this.service.isRunning(bl);
    }

    public void stop() {
        this.started = false;
        if (this.service != null) {
            this.service.stop();
        }
    }

    public String getURL() {
        return this.service.getURL();
    }

    public int getPort() {
        return this.service.getPort();
    }

    @Override
    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception exception) {
            DbException.traceThrowable(exception);
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    @Override
    public void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        } else {
            this.stopAll();
        }
    }

    public Service getService() {
        return this.service;
    }

    public static void openBrowser(String string2) throws Exception {
        try {
            String[] stringArray;
            String string3 = StringUtils.toLowerEnglish(Utils.getProperty("os.name", "linux"));
            Runtime runtime = Runtime.getRuntime();
            String string4 = Utils.getProperty("h2.browser", null);
            if (string4 == null) {
                try {
                    string4 = System.getenv("BROWSER");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (string4 != null) {
                if (string4.startsWith("call:")) {
                    string4 = string4.substring("call:".length());
                    Utils.callStaticMethod(string4, string2);
                } else if (string4.contains("%url")) {
                    String[] stringArray2 = StringUtils.arraySplit(string4, ',', false);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        stringArray2[j] = StringUtils.replaceAll(stringArray2[j], "%url", string2);
                    }
                    runtime.exec(stringArray2);
                } else if (string3.contains("windows")) {
                    runtime.exec(new String[]{"cmd.exe", "/C", string4, string2});
                } else {
                    runtime.exec(new String[]{string4, string2});
                }
                return;
            }
            try {
                stringArray = Class.forName("java.awt.Desktop");
                Boolean bl = (Boolean)stringArray.getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0]);
                String[] stringArray3 = new URI(string2);
                if (bl.booleanValue()) {
                    Object object = stringArray.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    stringArray.getMethod("browse", URI.class).invoke(object, new Object[]{stringArray3});
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3.contains("windows")) {
                runtime.exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", string2});
            } else if (string3.contains("mac") || string3.contains("darwin")) {
                Runtime.getRuntime().exec(new String[]{"open", string2});
            } else {
                stringArray = new String[]{"xdg-open", "chromium", "google-chrome", "firefox", "mozilla-firefox", "mozilla", "konqueror", "netscape", "opera", "midori"};
                boolean bl = false;
                for (String string5 : stringArray) {
                    try {
                        runtime.exec(new String[]{string5, string2});
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (!bl) {
                    throw new Exception("Browser detection failed, and java property 'h2.browser' and environment variable BROWSER are not set to a browser executable.");
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("Failed to start a browser to open the URL " + string2 + ": " + exception.getMessage());
        }
    }

    public static void startWebServer(Connection connection) throws SQLException {
        Server.startWebServer(connection, false);
    }

    public static void startWebServer(Connection connection, boolean bl) throws SQLException {
        WebServer webServer = new WebServer();
        String[] stringArray = bl ? new String[]{"-webPort", "0", "-properties", "null"} : new String[]{"-webPort", "0"};
        Server server = new Server(webServer, stringArray);
        server.start();
        Server server2 = new Server();
        server2.web = server;
        webServer.setShutdownHandler(server2);
        String string2 = webServer.addSession(connection);
        try {
            Server.openBrowser(string2);
            while (!webServer.isStopped()) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

