/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.regex.Pattern;
import org.h2.engine.Mode;
import org.h2.message.DbException;

public class ColumnNamerConfiguration {
    private static final String DEFAULT_COMMAND = "DEFAULT";
    private static final String REGULAR_EXPRESSION_MATCH_DISALLOWED = "REGULAR_EXPRESSION_MATCH_DISALLOWED = ";
    private static final String REGULAR_EXPRESSION_MATCH_ALLOWED = "REGULAR_EXPRESSION_MATCH_ALLOWED = ";
    private static final String DEFAULT_COLUMN_NAME_PATTERN = "DEFAULT_COLUMN_NAME_PATTERN = ";
    private static final String MAX_IDENTIFIER_LENGTH = "MAX_IDENTIFIER_LENGTH = ";
    private static final String EMULATE_COMMAND = "EMULATE = ";
    private static final String GENERATE_UNIQUE_COLUMN_NAMES = "GENERATE_UNIQUE_COLUMN_NAMES = ";
    private int maxIdentiferLength;
    private String regularExpressionMatchAllowed;
    private String regularExpressionMatchDisallowed;
    private String defaultColumnNamePattern;
    private boolean generateUniqueColumnNames;
    private Pattern compiledRegularExpressionMatchAllowed;
    private Pattern compiledRegularExpressionMatchDisallowed;

    public ColumnNamerConfiguration(int n, String string2, String string3, String string4, boolean bl) {
        this.maxIdentiferLength = n;
        this.regularExpressionMatchAllowed = string2;
        this.regularExpressionMatchDisallowed = string3;
        this.defaultColumnNamePattern = string4;
        this.generateUniqueColumnNames = bl;
        this.recompilePatterns();
    }

    public int getMaxIdentiferLength() {
        return this.maxIdentiferLength;
    }

    public void setMaxIdentiferLength(int n) {
        this.maxIdentiferLength = Math.max(30, n);
        if (n != this.getMaxIdentiferLength()) {
            throw DbException.getInvalidValueException("Illegal value (<30) in SET COLUMN_NAME_RULES", "MAX_IDENTIFIER_LENGTH=" + n);
        }
    }

    public String getRegularExpressionMatchAllowed() {
        return this.regularExpressionMatchAllowed;
    }

    public void setRegularExpressionMatchAllowed(String string2) {
        this.regularExpressionMatchAllowed = string2;
    }

    public String getRegularExpressionMatchDisallowed() {
        return this.regularExpressionMatchDisallowed;
    }

    public void setRegularExpressionMatchDisallowed(String string2) {
        this.regularExpressionMatchDisallowed = string2;
    }

    public String getDefaultColumnNamePattern() {
        return this.defaultColumnNamePattern;
    }

    public void setDefaultColumnNamePattern(String string2) {
        this.defaultColumnNamePattern = string2;
    }

    public Pattern getCompiledRegularExpressionMatchAllowed() {
        return this.compiledRegularExpressionMatchAllowed;
    }

    public void setCompiledRegularExpressionMatchAllowed(Pattern pattern) {
        this.compiledRegularExpressionMatchAllowed = pattern;
    }

    public Pattern getCompiledRegularExpressionMatchDisallowed() {
        return this.compiledRegularExpressionMatchDisallowed;
    }

    public void setCompiledRegularExpressionMatchDisallowed(Pattern pattern) {
        this.compiledRegularExpressionMatchDisallowed = pattern;
    }

    public void configure(String string2) {
        try {
            if (string2.equalsIgnoreCase(DEFAULT_COMMAND)) {
                this.configure(Mode.ModeEnum.REGULAR);
            } else if (string2.startsWith(EMULATE_COMMAND)) {
                this.configure(Mode.ModeEnum.valueOf(ColumnNamerConfiguration.unquoteString(string2.substring(EMULATE_COMMAND.length()))));
            } else if (string2.startsWith(MAX_IDENTIFIER_LENGTH)) {
                int n = Integer.parseInt(string2.substring(MAX_IDENTIFIER_LENGTH.length()));
                this.setMaxIdentiferLength(n);
            } else if (string2.startsWith(GENERATE_UNIQUE_COLUMN_NAMES)) {
                this.setGenerateUniqueColumnNames(Integer.parseInt(string2.substring(GENERATE_UNIQUE_COLUMN_NAMES.length())) == 1);
            } else if (string2.startsWith(DEFAULT_COLUMN_NAME_PATTERN)) {
                this.setDefaultColumnNamePattern(ColumnNamerConfiguration.unquoteString(string2.substring(DEFAULT_COLUMN_NAME_PATTERN.length())));
            } else if (string2.startsWith(REGULAR_EXPRESSION_MATCH_ALLOWED)) {
                this.setRegularExpressionMatchAllowed(ColumnNamerConfiguration.unquoteString(string2.substring(REGULAR_EXPRESSION_MATCH_ALLOWED.length())));
            } else if (string2.startsWith(REGULAR_EXPRESSION_MATCH_DISALLOWED)) {
                this.setRegularExpressionMatchDisallowed(ColumnNamerConfiguration.unquoteString(string2.substring(REGULAR_EXPRESSION_MATCH_DISALLOWED.length())));
            } else {
                throw DbException.getInvalidValueException("SET COLUMN_NAME_RULES: unknown id:" + string2, string2);
            }
            this.recompilePatterns();
        }
        catch (RuntimeException runtimeException) {
            throw DbException.getInvalidValueException("SET COLUMN_NAME_RULES:" + runtimeException.getMessage(), string2);
        }
    }

    private void recompilePatterns() {
        try {
            this.setCompiledRegularExpressionMatchAllowed(this.regularExpressionMatchAllowed != null ? Pattern.compile(this.regularExpressionMatchAllowed) : null);
            this.setCompiledRegularExpressionMatchDisallowed(this.regularExpressionMatchDisallowed != null ? Pattern.compile(this.regularExpressionMatchDisallowed) : null);
        }
        catch (Exception exception) {
            this.configure(Mode.ModeEnum.REGULAR);
            throw exception;
        }
    }

    public static ColumnNamerConfiguration getDefault() {
        return new ColumnNamerConfiguration(Integer.MAX_VALUE, null, null, "_UNNAMED_$$", false);
    }

    private static String unquoteString(String string2) {
        if (string2.startsWith("'") && string2.endsWith("'")) {
            string2 = string2.substring(1, string2.length() - 1);
            return string2;
        }
        return string2;
    }

    public boolean isGenerateUniqueColumnNames() {
        return this.generateUniqueColumnNames;
    }

    public void setGenerateUniqueColumnNames(boolean bl) {
        this.generateUniqueColumnNames = bl;
    }

    public void configure(Mode.ModeEnum modeEnum) {
        switch (modeEnum) {
            case Oracle: {
                this.setMaxIdentiferLength(128);
                this.setRegularExpressionMatchAllowed("(?m)(?s)\"?[A-Za-z0-9_\\$#]+\"?");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_\"\\$#]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            case MSSQLServer: {
                this.setMaxIdentiferLength(128);
                this.setRegularExpressionMatchAllowed("(?m)(?s)[A-Za-z0-9_\\[\\]]+");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_\\[\\]]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            case PostgreSQL: {
                this.setMaxIdentiferLength(63);
                this.setRegularExpressionMatchAllowed("(?m)(?s)[A-Za-z0-9_\\$]+");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_\\$]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            case MySQL: {
                this.setMaxIdentiferLength(64);
                this.setRegularExpressionMatchAllowed("(?m)(?s)`?[A-Za-z0-9_`\\$]+`?");
                this.setRegularExpressionMatchDisallowed("(?m)(?s)[^A-Za-z0-9_`\\$]");
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
                break;
            }
            default: {
                this.setMaxIdentiferLength(Integer.MAX_VALUE);
                this.setRegularExpressionMatchAllowed(null);
                this.setRegularExpressionMatchDisallowed(null);
                this.setDefaultColumnNamePattern("_UNNAMED_$$");
                this.setGenerateUniqueColumnNames(false);
            }
        }
        this.recompilePatterns();
    }
}

