/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.security.CipherFactory;
import org.h2.util.StringUtils;

public class NetUtils {
    private static final int CACHE_MILLIS = 1000;
    private static InetAddress cachedBindAddress;
    private static String cachedLocalAddress;
    private static long cachedLocalAddressTime;

    private NetUtils() {
    }

    public static Socket createLoopbackSocket(int n, boolean bl) throws IOException {
        String string2 = NetUtils.getLocalAddress();
        try {
            return NetUtils.createSocket(string2, n, bl);
        }
        catch (IOException iOException) {
            try {
                return NetUtils.createSocket("localhost", n, bl);
            }
            catch (IOException iOException2) {
                throw iOException;
            }
        }
    }

    public static Socket createSocket(String string2, int n, boolean bl) throws IOException {
        int n2 = n;
        int n3 = string2.startsWith("[") ? string2.indexOf(93) : 0;
        int n4 = string2.indexOf(58, n3);
        if (n4 >= 0) {
            n2 = Integer.decode(string2.substring(n4 + 1));
            string2 = string2.substring(0, n4);
        }
        InetAddress inetAddress = InetAddress.getByName(string2);
        return NetUtils.createSocket(inetAddress, n2, bl);
    }

    public static Socket createSocket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        long l = System.nanoTime();
        int n2 = 0;
        while (true) {
            try {
                if (bl) {
                    return CipherFactory.createSocket(inetAddress, n);
                }
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(inetAddress, n), SysProperties.SOCKET_CONNECT_TIMEOUT);
                return socket;
            }
            catch (IOException iOException) {
                if (System.nanoTime() - l >= TimeUnit.MILLISECONDS.toNanos(SysProperties.SOCKET_CONNECT_TIMEOUT)) {
                    throw iOException;
                }
                if (n2 >= SysProperties.SOCKET_CONNECT_RETRY) {
                    throw iOException;
                }
                try {
                    long l2 = Math.min(256, n2 * n2);
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    public static ServerSocket createServerSocket(int n, boolean bl) {
        try {
            return NetUtils.createServerSocketTry(n, bl);
        }
        catch (Exception exception) {
            return NetUtils.createServerSocketTry(n, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getBindAddress() throws UnknownHostException {
        String string2 = SysProperties.BIND_ADDRESS;
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (cachedBindAddress == null) {
                cachedBindAddress = InetAddress.getByName(string2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cachedBindAddress;
        }
    }

    private static ServerSocket createServerSocketTry(int n, boolean bl) {
        try {
            InetAddress inetAddress = NetUtils.getBindAddress();
            if (bl) {
                return CipherFactory.createServerSocket(n, inetAddress);
            }
            if (inetAddress == null) {
                return new ServerSocket(n);
            }
            return new ServerSocket(n, 0, inetAddress);
        }
        catch (BindException bindException) {
            throw DbException.get(90061, bindException, Integer.toString(n), bindException.toString());
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "port: " + n + " ssl: " + bl);
        }
    }

    public static boolean isLocalAddress(Socket socket) throws UnknownHostException {
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress.isLoopbackAddress()) {
            return true;
        }
        InetAddress inetAddress2 = InetAddress.getLocalHost();
        String string2 = inetAddress2.getHostAddress();
        for (InetAddress inetAddress3 : InetAddress.getAllByName(string2)) {
            if (!inetAddress.equals(inetAddress3)) continue;
            return true;
        }
        return false;
    }

    public static ServerSocket closeSilently(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized String getLocalAddress() {
        String string2;
        long l = System.nanoTime();
        if (cachedLocalAddress != null && cachedLocalAddressTime + TimeUnit.MILLISECONDS.toNanos(1000L) > l) {
            return cachedLocalAddress;
        }
        InetAddress inetAddress = null;
        boolean bl = false;
        try {
            inetAddress = NetUtils.getBindAddress();
            if (inetAddress == null) {
                bl = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (bl) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                throw DbException.convert(unknownHostException);
            }
        }
        if (inetAddress == null) {
            string2 = "localhost";
        } else {
            string2 = inetAddress.getHostAddress();
            if (inetAddress instanceof Inet6Address) {
                if (string2.indexOf(37) >= 0) {
                    string2 = "localhost";
                } else if (string2.indexOf(58) >= 0 && !string2.startsWith("[")) {
                    string2 = "[" + string2 + "]";
                }
            }
        }
        if (string2.equals("127.0.0.1")) {
            string2 = "localhost";
        }
        cachedLocalAddress = string2;
        cachedLocalAddressTime = l;
        return string2;
    }

    public static String getHostName(String string2) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            return inetAddress.getHostName();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    public static StringBuilder ipToShortForm(StringBuilder stringBuilder, byte[] byArray, boolean bl) {
        switch (byArray.length) {
            case 4: {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(15);
                }
                stringBuilder.append(byArray[0] & 0xFF).append('.').append(byArray[1] & 0xFF).append('.').append(byArray[2] & 0xFF).append('.').append(byArray[3] & 0xFF).toString();
                break;
            }
            case 16: {
                int n;
                short[] sArray = new short[8];
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (n = 0; n < 8; ++n) {
                    if ((sArray[n] = (short)((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF)) == 0) {
                        if (++n4 <= n3) continue;
                        n3 = n4;
                        n2 = n - n4 + 1;
                        continue;
                    }
                    n4 = 0;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(bl ? 41 : 39);
                }
                if (bl) {
                    stringBuilder.append('[');
                }
                if (n3 > 1) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        stringBuilder.append(Integer.toHexString(sArray[n5] & 0xFFFF)).append(':');
                    }
                    if (n2 == 0) {
                        stringBuilder.append(':');
                    }
                    stringBuilder.append(':');
                    n = n2 + n3;
                } else {
                    n = 0;
                }
                for (n5 = n; n5 < 8; ++n5) {
                    stringBuilder.append(Integer.toHexString(sArray[n5] & 0xFFFF));
                    if (n5 >= 7) continue;
                    stringBuilder.append(':');
                }
                if (!bl) break;
                stringBuilder.append(']');
                break;
            }
            default: {
                StringUtils.convertBytesToHex(stringBuilder, byArray);
            }
        }
        return stringBuilder;
    }
}

