/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.jdbcx.JdbcDataSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;

public class OsgiDataSourceFactory
implements DataSourceFactory {
    private final Driver driver;

    public OsgiDataSourceFactory(Driver driver) {
        this.driver = driver;
    }

    public DataSource createDataSource(Properties properties2) throws SQLException {
        Properties properties3 = new Properties();
        if (properties2 != null) {
            properties3.putAll((Map<?, ?>)properties2);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(properties3);
        OsgiDataSourceFactory.rejectPoolingOptions(properties3);
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(jdbcDataSource, properties3);
        return jdbcDataSource;
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties2) throws SQLException {
        Properties properties3 = new Properties();
        if (properties2 != null) {
            properties3.putAll((Map<?, ?>)properties2);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(properties3);
        OsgiDataSourceFactory.rejectPoolingOptions(properties3);
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(jdbcDataSource, properties3);
        return jdbcDataSource;
    }

    public XADataSource createXADataSource(Properties properties2) throws SQLException {
        Properties properties3 = new Properties();
        if (properties2 != null) {
            properties3.putAll((Map<?, ?>)properties2);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(properties3);
        OsgiDataSourceFactory.rejectPoolingOptions(properties3);
        JdbcDataSource jdbcDataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(jdbcDataSource, properties3);
        return jdbcDataSource;
    }

    public java.sql.Driver createDriver(Properties properties2) throws SQLException {
        if (properties2 != null && !properties2.isEmpty()) {
            throw new SQLException();
        }
        return this.driver;
    }

    private static void rejectUnsupportedOptions(Properties properties2) throws SQLFeatureNotSupportedException {
        if (properties2.containsKey("roleName")) {
            throw new SQLFeatureNotSupportedException("The roleName property is not supported by H2");
        }
        if (properties2.containsKey("dataSourceName")) {
            throw new SQLFeatureNotSupportedException("The dataSourceName property is not supported by H2");
        }
    }

    private static void setupH2DataSource(JdbcDataSource jdbcDataSource, Properties properties2) {
        if (properties2.containsKey("user")) {
            jdbcDataSource.setUser((String)properties2.remove("user"));
        }
        if (properties2.containsKey("password")) {
            jdbcDataSource.setPassword((String)properties2.remove("password"));
        }
        if (properties2.containsKey("description")) {
            jdbcDataSource.setDescription((String)properties2.remove("description"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (properties2.containsKey("url")) {
            stringBuilder.append(properties2.remove("url"));
            properties2.remove("networkProtocol");
            properties2.remove("serverName");
            properties2.remove("portNumber");
            properties2.remove("databaseName");
        } else {
            stringBuilder.append("jdbc:h2:");
            Object object = "";
            if (properties2.containsKey("networkProtocol")) {
                object = (String)properties2.remove("networkProtocol");
                stringBuilder.append((String)object).append(":");
            }
            if (properties2.containsKey("serverName")) {
                stringBuilder.append("//").append(properties2.remove("serverName"));
                if (properties2.containsKey("portNumber")) {
                    stringBuilder.append(":").append(properties2.remove("portNumber"));
                }
                stringBuilder.append("/");
            } else if (properties2.containsKey("portNumber")) {
                stringBuilder.append("//localhost:").append(properties2.remove("portNumber")).append("/");
            } else if (((String)object).equals("tcp") || ((String)object).equals("ssl")) {
                stringBuilder.append("//localhost/");
            }
            if (properties2.containsKey("databaseName")) {
                stringBuilder.append(properties2.remove("databaseName"));
            }
        }
        for (Object e : properties2.keySet()) {
            stringBuilder.append(";").append(e).append("=").append(properties2.get(e));
        }
        if (stringBuilder.length() > "jdbc:h2:".length()) {
            jdbcDataSource.setURL(stringBuilder.toString());
        }
    }

    private static void rejectPoolingOptions(Properties properties2) throws SQLFeatureNotSupportedException {
        if (properties2.containsKey("initialPoolSize") || properties2.containsKey("maxIdleTime") || properties2.containsKey("maxPoolSize") || properties2.containsKey("maxStatements") || properties2.containsKey("minPoolSize") || properties2.containsKey("propertyCycle")) {
            throw new SQLFeatureNotSupportedException("Pooling properties are not supported by H2");
        }
    }

    static void registerService(BundleContext bundleContext, Driver driver) {
        Properties properties2 = new Properties();
        properties2.put("osgi.jdbc.driver.class", Driver.class.getName());
        properties2.put("osgi.jdbc.driver.name", "H2 JDBC Driver");
        properties2.put("osgi.jdbc.driver.version", Constants.FULL_VERSION);
        bundleContext.registerService(DataSourceFactory.class.getName(), (Object)new OsgiDataSourceFactory(driver), (Dictionary)properties2);
    }
}

